/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.permission;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.permission.CommerceInventoryWarehousePermission;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.permission.PortalPermission;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceInventoryWarehousePermission.class})
public class CommerceInventoryWarehousePermissionImpl
implements CommerceInventoryWarehousePermission {
    @Reference
    private CommerceInventoryWarehouseLocalService _commerceInventoryWarehouseLocalService;
    @Reference
    private PortalPermission _portalPermission;

    public void check(PermissionChecker permissionChecker, CommerceInventoryWarehouse commerceInventoryWarehouse, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceInventoryWarehouse, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long commerceInventoryWarehouseId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceInventoryWarehouseId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouseId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CommerceInventoryWarehouse commerceInventoryWarehouse, String actionId) throws PortalException {
        return this.contains(permissionChecker, commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long commerceInventoryWarehouseId, String actionId) throws PortalException {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseLocalService.getCommerceInventoryWarehouse(commerceInventoryWarehouseId);
        if (commerceInventoryWarehouse == null) {
            return false;
        }
        return this._contains(permissionChecker, commerceInventoryWarehouse, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] commerceAccountIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])commerceAccountIds)) {
            return false;
        }
        for (long commerceInventoryWarehouseId : commerceAccountIds) {
            if (this.contains(permissionChecker, commerceInventoryWarehouseId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CommerceInventoryWarehouse commerceInventoryWarehouse, String actionId) throws PortalException {
        if (permissionChecker.isCompanyAdmin(commerceInventoryWarehouse.getCompanyId()) || permissionChecker.isOmniadmin()) {
            return true;
        }
        if (this._portalPermission.contains(PermissionThreadLocal.getPermissionChecker(), "MANAGE_INVENTORY")) {
            return true;
        }
        return permissionChecker.hasPermission(null, CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), actionId);
    }
}

