/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.inventory.model.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceInventoryWarehouse service. Represents a row in the &quot;CIWarehouse&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceInventoryWarehouseModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceInventoryWarehouseImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceInventoryWarehouseImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceInventoryWarehouseModelImpl
	extends BaseModelImpl<CommerceInventoryWarehouse>
	implements CommerceInventoryWarehouseModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce inventory warehouse model instance should use the <code>CommerceInventoryWarehouse</code> interface instead.
	 */
	public static final String TABLE_NAME = "CIWarehouse";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"externalReferenceCode", Types.VARCHAR},
		{"CIWarehouseId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"name", Types.VARCHAR}, {"description", Types.VARCHAR},
		{"active_", Types.BOOLEAN}, {"street1", Types.VARCHAR},
		{"street2", Types.VARCHAR}, {"street3", Types.VARCHAR},
		{"city", Types.VARCHAR}, {"zip", Types.VARCHAR},
		{"commerceRegionCode", Types.VARCHAR},
		{"countryTwoLettersISOCode", Types.VARCHAR}, {"latitude", Types.DOUBLE},
		{"longitude", Types.DOUBLE}, {"type_", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("CIWarehouseId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("street1", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("street2", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("street3", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("city", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("zip", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceRegionCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("countryTwoLettersISOCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("latitude", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("longitude", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("type_", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CIWarehouse (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,CIWarehouseId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,name VARCHAR(75) null,description VARCHAR(75) null,active_ BOOLEAN,street1 VARCHAR(75) null,street2 VARCHAR(75) null,street3 VARCHAR(75) null,city VARCHAR(75) null,zip VARCHAR(75) null,commerceRegionCode VARCHAR(75) null,countryTwoLettersISOCode VARCHAR(75) null,latitude DOUBLE,longitude DOUBLE,type_ VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP = "drop table CIWarehouse";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceInventoryWarehouse.name ASC";

	public static final String ORDER_BY_SQL = " ORDER BY CIWarehouse.name ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACTIVE_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COUNTRYTWOLETTERSISOCODE_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 32L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.inventory.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.inventory.model.CommerceInventoryWarehouse"));

	public CommerceInventoryWarehouseModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceInventoryWarehouseId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceInventoryWarehouseId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceInventoryWarehouseId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceInventoryWarehouse.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceInventoryWarehouse.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceInventoryWarehouse, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceInventoryWarehouse, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceInventoryWarehouse, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(CommerceInventoryWarehouse)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceInventoryWarehouse, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceInventoryWarehouse, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceInventoryWarehouse)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceInventoryWarehouse, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceInventoryWarehouse, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map
		<String, Function<CommerceInventoryWarehouse, Object>>
			_attributeGetterFunctions;
	private static final Map
		<String, BiConsumer<CommerceInventoryWarehouse, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceInventoryWarehouse, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<CommerceInventoryWarehouse, Object>>();
		Map<String, BiConsumer<CommerceInventoryWarehouse, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<CommerceInventoryWarehouse, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", CommerceInventoryWarehouse::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<CommerceInventoryWarehouse, Long>)
				CommerceInventoryWarehouse::setMvccVersion);
		attributeGetterFunctions.put(
			"uuid", CommerceInventoryWarehouse::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<CommerceInventoryWarehouse, String>)
				CommerceInventoryWarehouse::setUuid);
		attributeGetterFunctions.put(
			"externalReferenceCode",
			CommerceInventoryWarehouse::getExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<CommerceInventoryWarehouse, String>)
				CommerceInventoryWarehouse::setExternalReferenceCode);
		attributeGetterFunctions.put(
			"commerceInventoryWarehouseId",
			CommerceInventoryWarehouse::getCommerceInventoryWarehouseId);
		attributeSetterBiConsumers.put(
			"commerceInventoryWarehouseId",
			(BiConsumer<CommerceInventoryWarehouse, Long>)
				CommerceInventoryWarehouse::setCommerceInventoryWarehouseId);
		attributeGetterFunctions.put(
			"companyId", CommerceInventoryWarehouse::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommerceInventoryWarehouse, Long>)
				CommerceInventoryWarehouse::setCompanyId);
		attributeGetterFunctions.put(
			"userId", CommerceInventoryWarehouse::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommerceInventoryWarehouse, Long>)
				CommerceInventoryWarehouse::setUserId);
		attributeGetterFunctions.put(
			"userName", CommerceInventoryWarehouse::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommerceInventoryWarehouse, String>)
				CommerceInventoryWarehouse::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommerceInventoryWarehouse::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommerceInventoryWarehouse, Date>)
				CommerceInventoryWarehouse::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommerceInventoryWarehouse::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommerceInventoryWarehouse, Date>)
				CommerceInventoryWarehouse::setModifiedDate);
		attributeGetterFunctions.put(
			"name", CommerceInventoryWarehouse::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<CommerceInventoryWarehouse, String>)
				CommerceInventoryWarehouse::setName);
		attributeGetterFunctions.put(
			"description", CommerceInventoryWarehouse::getDescription);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<CommerceInventoryWarehouse, String>)
				CommerceInventoryWarehouse::setDescription);
		attributeGetterFunctions.put(
			"active", CommerceInventoryWarehouse::getActive);
		attributeSetterBiConsumers.put(
			"active",
			(BiConsumer<CommerceInventoryWarehouse, Boolean>)
				CommerceInventoryWarehouse::setActive);
		attributeGetterFunctions.put(
			"street1", CommerceInventoryWarehouse::getStreet1);
		attributeSetterBiConsumers.put(
			"street1",
			(BiConsumer<CommerceInventoryWarehouse, String>)
				CommerceInventoryWarehouse::setStreet1);
		attributeGetterFunctions.put(
			"street2", CommerceInventoryWarehouse::getStreet2);
		attributeSetterBiConsumers.put(
			"street2",
			(BiConsumer<CommerceInventoryWarehouse, String>)
				CommerceInventoryWarehouse::setStreet2);
		attributeGetterFunctions.put(
			"street3", CommerceInventoryWarehouse::getStreet3);
		attributeSetterBiConsumers.put(
			"street3",
			(BiConsumer<CommerceInventoryWarehouse, String>)
				CommerceInventoryWarehouse::setStreet3);
		attributeGetterFunctions.put(
			"city", CommerceInventoryWarehouse::getCity);
		attributeSetterBiConsumers.put(
			"city",
			(BiConsumer<CommerceInventoryWarehouse, String>)
				CommerceInventoryWarehouse::setCity);
		attributeGetterFunctions.put("zip", CommerceInventoryWarehouse::getZip);
		attributeSetterBiConsumers.put(
			"zip",
			(BiConsumer<CommerceInventoryWarehouse, String>)
				CommerceInventoryWarehouse::setZip);
		attributeGetterFunctions.put(
			"commerceRegionCode",
			CommerceInventoryWarehouse::getCommerceRegionCode);
		attributeSetterBiConsumers.put(
			"commerceRegionCode",
			(BiConsumer<CommerceInventoryWarehouse, String>)
				CommerceInventoryWarehouse::setCommerceRegionCode);
		attributeGetterFunctions.put(
			"countryTwoLettersISOCode",
			CommerceInventoryWarehouse::getCountryTwoLettersISOCode);
		attributeSetterBiConsumers.put(
			"countryTwoLettersISOCode",
			(BiConsumer<CommerceInventoryWarehouse, String>)
				CommerceInventoryWarehouse::setCountryTwoLettersISOCode);
		attributeGetterFunctions.put(
			"latitude", CommerceInventoryWarehouse::getLatitude);
		attributeSetterBiConsumers.put(
			"latitude",
			(BiConsumer<CommerceInventoryWarehouse, Double>)
				CommerceInventoryWarehouse::setLatitude);
		attributeGetterFunctions.put(
			"longitude", CommerceInventoryWarehouse::getLongitude);
		attributeSetterBiConsumers.put(
			"longitude",
			(BiConsumer<CommerceInventoryWarehouse, Double>)
				CommerceInventoryWarehouse::setLongitude);
		attributeGetterFunctions.put(
			"type", CommerceInventoryWarehouse::getType);
		attributeSetterBiConsumers.put(
			"type",
			(BiConsumer<CommerceInventoryWarehouse, String>)
				CommerceInventoryWarehouse::setType);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getCommerceInventoryWarehouseId() {
		return _commerceInventoryWarehouseId;
	}

	@Override
	public void setCommerceInventoryWarehouseId(
		long commerceInventoryWarehouseId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceInventoryWarehouseId = commerceInventoryWarehouseId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public boolean getActive() {
		return _active;
	}

	@JSON
	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_active = active;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalActive() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("active_"));
	}

	@JSON
	@Override
	public String getStreet1() {
		if (_street1 == null) {
			return "";
		}
		else {
			return _street1;
		}
	}

	@Override
	public void setStreet1(String street1) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_street1 = street1;
	}

	@JSON
	@Override
	public String getStreet2() {
		if (_street2 == null) {
			return "";
		}
		else {
			return _street2;
		}
	}

	@Override
	public void setStreet2(String street2) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_street2 = street2;
	}

	@JSON
	@Override
	public String getStreet3() {
		if (_street3 == null) {
			return "";
		}
		else {
			return _street3;
		}
	}

	@Override
	public void setStreet3(String street3) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_street3 = street3;
	}

	@JSON
	@Override
	public String getCity() {
		if (_city == null) {
			return "";
		}
		else {
			return _city;
		}
	}

	@Override
	public void setCity(String city) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_city = city;
	}

	@JSON
	@Override
	public String getZip() {
		if (_zip == null) {
			return "";
		}
		else {
			return _zip;
		}
	}

	@Override
	public void setZip(String zip) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_zip = zip;
	}

	@JSON
	@Override
	public String getCommerceRegionCode() {
		if (_commerceRegionCode == null) {
			return "";
		}
		else {
			return _commerceRegionCode;
		}
	}

	@Override
	public void setCommerceRegionCode(String commerceRegionCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceRegionCode = commerceRegionCode;
	}

	@JSON
	@Override
	public String getCountryTwoLettersISOCode() {
		if (_countryTwoLettersISOCode == null) {
			return "";
		}
		else {
			return _countryTwoLettersISOCode;
		}
	}

	@Override
	public void setCountryTwoLettersISOCode(String countryTwoLettersISOCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_countryTwoLettersISOCode = countryTwoLettersISOCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalCountryTwoLettersISOCode() {
		return getColumnOriginalValue("countryTwoLettersISOCode");
	}

	@JSON
	@Override
	public double getLatitude() {
		return _latitude;
	}

	@Override
	public void setLatitude(double latitude) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_latitude = latitude;
	}

	@JSON
	@Override
	public double getLongitude() {
		return _longitude;
	}

	@Override
	public void setLongitude(double longitude) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_longitude = longitude;
	}

	@JSON
	@Override
	public String getType() {
		if (_type == null) {
			return "";
		}
		else {
			return _type;
		}
	}

	@Override
	public void setType(String type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(
				CommerceInventoryWarehouse.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceInventoryWarehouse.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceInventoryWarehouse toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceInventoryWarehouse>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceInventoryWarehouseImpl commerceInventoryWarehouseImpl =
			new CommerceInventoryWarehouseImpl();

		commerceInventoryWarehouseImpl.setMvccVersion(getMvccVersion());
		commerceInventoryWarehouseImpl.setUuid(getUuid());
		commerceInventoryWarehouseImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		commerceInventoryWarehouseImpl.setCommerceInventoryWarehouseId(
			getCommerceInventoryWarehouseId());
		commerceInventoryWarehouseImpl.setCompanyId(getCompanyId());
		commerceInventoryWarehouseImpl.setUserId(getUserId());
		commerceInventoryWarehouseImpl.setUserName(getUserName());
		commerceInventoryWarehouseImpl.setCreateDate(getCreateDate());
		commerceInventoryWarehouseImpl.setModifiedDate(getModifiedDate());
		commerceInventoryWarehouseImpl.setName(getName());
		commerceInventoryWarehouseImpl.setDescription(getDescription());
		commerceInventoryWarehouseImpl.setActive(isActive());
		commerceInventoryWarehouseImpl.setStreet1(getStreet1());
		commerceInventoryWarehouseImpl.setStreet2(getStreet2());
		commerceInventoryWarehouseImpl.setStreet3(getStreet3());
		commerceInventoryWarehouseImpl.setCity(getCity());
		commerceInventoryWarehouseImpl.setZip(getZip());
		commerceInventoryWarehouseImpl.setCommerceRegionCode(
			getCommerceRegionCode());
		commerceInventoryWarehouseImpl.setCountryTwoLettersISOCode(
			getCountryTwoLettersISOCode());
		commerceInventoryWarehouseImpl.setLatitude(getLatitude());
		commerceInventoryWarehouseImpl.setLongitude(getLongitude());
		commerceInventoryWarehouseImpl.setType(getType());

		commerceInventoryWarehouseImpl.resetOriginalValues();

		return commerceInventoryWarehouseImpl;
	}

	@Override
	public CommerceInventoryWarehouse cloneWithOriginalValues() {
		CommerceInventoryWarehouseImpl commerceInventoryWarehouseImpl =
			new CommerceInventoryWarehouseImpl();

		commerceInventoryWarehouseImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		commerceInventoryWarehouseImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		commerceInventoryWarehouseImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		commerceInventoryWarehouseImpl.setCommerceInventoryWarehouseId(
			this.<Long>getColumnOriginalValue("CIWarehouseId"));
		commerceInventoryWarehouseImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		commerceInventoryWarehouseImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		commerceInventoryWarehouseImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		commerceInventoryWarehouseImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		commerceInventoryWarehouseImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		commerceInventoryWarehouseImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		commerceInventoryWarehouseImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		commerceInventoryWarehouseImpl.setActive(
			this.<Boolean>getColumnOriginalValue("active_"));
		commerceInventoryWarehouseImpl.setStreet1(
			this.<String>getColumnOriginalValue("street1"));
		commerceInventoryWarehouseImpl.setStreet2(
			this.<String>getColumnOriginalValue("street2"));
		commerceInventoryWarehouseImpl.setStreet3(
			this.<String>getColumnOriginalValue("street3"));
		commerceInventoryWarehouseImpl.setCity(
			this.<String>getColumnOriginalValue("city"));
		commerceInventoryWarehouseImpl.setZip(
			this.<String>getColumnOriginalValue("zip"));
		commerceInventoryWarehouseImpl.setCommerceRegionCode(
			this.<String>getColumnOriginalValue("commerceRegionCode"));
		commerceInventoryWarehouseImpl.setCountryTwoLettersISOCode(
			this.<String>getColumnOriginalValue("countryTwoLettersISOCode"));
		commerceInventoryWarehouseImpl.setLatitude(
			this.<Double>getColumnOriginalValue("latitude"));
		commerceInventoryWarehouseImpl.setLongitude(
			this.<Double>getColumnOriginalValue("longitude"));
		commerceInventoryWarehouseImpl.setType(
			this.<String>getColumnOriginalValue("type_"));

		return commerceInventoryWarehouseImpl;
	}

	@Override
	public int compareTo(
		CommerceInventoryWarehouse commerceInventoryWarehouse) {

		int value = 0;

		value = getName().compareTo(commerceInventoryWarehouse.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceInventoryWarehouse)) {
			return false;
		}

		CommerceInventoryWarehouse commerceInventoryWarehouse =
			(CommerceInventoryWarehouse)object;

		long primaryKey = commerceInventoryWarehouse.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceInventoryWarehouse> toCacheModel() {
		CommerceInventoryWarehouseCacheModel
			commerceInventoryWarehouseCacheModel =
				new CommerceInventoryWarehouseCacheModel();

		commerceInventoryWarehouseCacheModel.mvccVersion = getMvccVersion();

		commerceInventoryWarehouseCacheModel.uuid = getUuid();

		String uuid = commerceInventoryWarehouseCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceInventoryWarehouseCacheModel.uuid = null;
		}

		commerceInventoryWarehouseCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commerceInventoryWarehouseCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commerceInventoryWarehouseCacheModel.externalReferenceCode = null;
		}

		commerceInventoryWarehouseCacheModel.commerceInventoryWarehouseId =
			getCommerceInventoryWarehouseId();

		commerceInventoryWarehouseCacheModel.companyId = getCompanyId();

		commerceInventoryWarehouseCacheModel.userId = getUserId();

		commerceInventoryWarehouseCacheModel.userName = getUserName();

		String userName = commerceInventoryWarehouseCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceInventoryWarehouseCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceInventoryWarehouseCacheModel.createDate =
				createDate.getTime();
		}
		else {
			commerceInventoryWarehouseCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceInventoryWarehouseCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commerceInventoryWarehouseCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceInventoryWarehouseCacheModel.name = getName();

		String name = commerceInventoryWarehouseCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			commerceInventoryWarehouseCacheModel.name = null;
		}

		commerceInventoryWarehouseCacheModel.description = getDescription();

		String description = commerceInventoryWarehouseCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			commerceInventoryWarehouseCacheModel.description = null;
		}

		commerceInventoryWarehouseCacheModel.active = isActive();

		commerceInventoryWarehouseCacheModel.street1 = getStreet1();

		String street1 = commerceInventoryWarehouseCacheModel.street1;

		if ((street1 != null) && (street1.length() == 0)) {
			commerceInventoryWarehouseCacheModel.street1 = null;
		}

		commerceInventoryWarehouseCacheModel.street2 = getStreet2();

		String street2 = commerceInventoryWarehouseCacheModel.street2;

		if ((street2 != null) && (street2.length() == 0)) {
			commerceInventoryWarehouseCacheModel.street2 = null;
		}

		commerceInventoryWarehouseCacheModel.street3 = getStreet3();

		String street3 = commerceInventoryWarehouseCacheModel.street3;

		if ((street3 != null) && (street3.length() == 0)) {
			commerceInventoryWarehouseCacheModel.street3 = null;
		}

		commerceInventoryWarehouseCacheModel.city = getCity();

		String city = commerceInventoryWarehouseCacheModel.city;

		if ((city != null) && (city.length() == 0)) {
			commerceInventoryWarehouseCacheModel.city = null;
		}

		commerceInventoryWarehouseCacheModel.zip = getZip();

		String zip = commerceInventoryWarehouseCacheModel.zip;

		if ((zip != null) && (zip.length() == 0)) {
			commerceInventoryWarehouseCacheModel.zip = null;
		}

		commerceInventoryWarehouseCacheModel.commerceRegionCode =
			getCommerceRegionCode();

		String commerceRegionCode =
			commerceInventoryWarehouseCacheModel.commerceRegionCode;

		if ((commerceRegionCode != null) &&
			(commerceRegionCode.length() == 0)) {

			commerceInventoryWarehouseCacheModel.commerceRegionCode = null;
		}

		commerceInventoryWarehouseCacheModel.countryTwoLettersISOCode =
			getCountryTwoLettersISOCode();

		String countryTwoLettersISOCode =
			commerceInventoryWarehouseCacheModel.countryTwoLettersISOCode;

		if ((countryTwoLettersISOCode != null) &&
			(countryTwoLettersISOCode.length() == 0)) {

			commerceInventoryWarehouseCacheModel.countryTwoLettersISOCode =
				null;
		}

		commerceInventoryWarehouseCacheModel.latitude = getLatitude();

		commerceInventoryWarehouseCacheModel.longitude = getLongitude();

		commerceInventoryWarehouseCacheModel.type = getType();

		String type = commerceInventoryWarehouseCacheModel.type;

		if ((type != null) && (type.length() == 0)) {
			commerceInventoryWarehouseCacheModel.type = null;
		}

		return commerceInventoryWarehouseCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceInventoryWarehouse, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceInventoryWarehouse, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceInventoryWarehouse, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceInventoryWarehouse)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceInventoryWarehouse, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceInventoryWarehouse, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceInventoryWarehouse, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply(
					(CommerceInventoryWarehouse)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, CommerceInventoryWarehouse>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						CommerceInventoryWarehouse.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _externalReferenceCode;
	private long _commerceInventoryWarehouseId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _name;
	private String _description;
	private boolean _active;
	private String _street1;
	private String _street2;
	private String _street3;
	private String _city;
	private String _zip;
	private String _commerceRegionCode;
	private String _countryTwoLettersISOCode;
	private double _latitude;
	private double _longitude;
	private String _type;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceInventoryWarehouse, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceInventoryWarehouse)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put(
			"CIWarehouseId", _commerceInventoryWarehouseId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("active_", _active);
		_columnOriginalValues.put("street1", _street1);
		_columnOriginalValues.put("street2", _street2);
		_columnOriginalValues.put("street3", _street3);
		_columnOriginalValues.put("city", _city);
		_columnOriginalValues.put("zip", _zip);
		_columnOriginalValues.put("commerceRegionCode", _commerceRegionCode);
		_columnOriginalValues.put(
			"countryTwoLettersISOCode", _countryTwoLettersISOCode);
		_columnOriginalValues.put("latitude", _latitude);
		_columnOriginalValues.put("longitude", _longitude);
		_columnOriginalValues.put("type_", _type);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("CIWarehouseId", "commerceInventoryWarehouseId");
		attributeNames.put("active_", "active");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("externalReferenceCode", 4L);

		columnBitmasks.put("CIWarehouseId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("userName", 64L);

		columnBitmasks.put("createDate", 128L);

		columnBitmasks.put("modifiedDate", 256L);

		columnBitmasks.put("name", 512L);

		columnBitmasks.put("description", 1024L);

		columnBitmasks.put("active_", 2048L);

		columnBitmasks.put("street1", 4096L);

		columnBitmasks.put("street2", 8192L);

		columnBitmasks.put("street3", 16384L);

		columnBitmasks.put("city", 32768L);

		columnBitmasks.put("zip", 65536L);

		columnBitmasks.put("commerceRegionCode", 131072L);

		columnBitmasks.put("countryTwoLettersISOCode", 262144L);

		columnBitmasks.put("latitude", 524288L);

		columnBitmasks.put("longitude", 1048576L);

		columnBitmasks.put("type_", 2097152L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceInventoryWarehouse _escapedModel;

}