/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.upgrade;

import com.liferay.commerce.inventory.internal.upgrade.v1_1_0.CommerceInventoryWarehouseItemUpgradeProcess;
import com.liferay.commerce.inventory.internal.upgrade.v2_0_0.CommerceInventoryAuditUpgradeProcess;
import com.liferay.commerce.inventory.internal.upgrade.v2_1_0.MVCCUpgradeProcess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.BaseExternalReferenceCodeUpgradeProcess;
import com.liferay.portal.kernel.upgrade.BaseUuidUpgradeProcess;
import com.liferay.portal.kernel.upgrade.DummyUpgradeProcess;
import com.liferay.portal.kernel.upgrade.MVCCVersionUpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import org.osgi.service.component.annotations.Component;

@Component(enabled=false, immediate=true, service={UpgradeStepRegistrator.class})
public class CommerceInventoryUpgradeStepRegistrator
implements UpgradeStepRegistrator {
    private static final Log _log = LogFactoryUtil.getLog(CommerceInventoryUpgradeStepRegistrator.class);

    public void register(UpgradeStepRegistrator.Registry registry) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce inventory upgrade step registrator started");
        }
        registry.register("1.0.0", "1.1.0", new UpgradeStep[]{new CommerceInventoryWarehouseItemUpgradeProcess()});
        registry.register("1.1.0", "1.2.0", new UpgradeStep[]{new DummyUpgradeProcess()});
        registry.register("1.2.0", "2.0.0", new UpgradeStep[]{new CommerceInventoryAuditUpgradeProcess()});
        registry.register("2.0.0", "2.1.0", new UpgradeStep[]{new MVCCUpgradeProcess()});
        registry.register("2.1.0", "2.2.0", new UpgradeStep[]{new MVCCVersionUpgradeProcess(){

            protected String[] getModuleTableNames() {
                return new String[]{"CIAudit", "CIBookedQuantity", "CIReplenishmentItem", "CIWarehouse", "CIWarehouseGroupRel", "CIWarehouseItem"};
            }
        }});
        registry.register("2.2.0", "2.3.0", new UpgradeStep[]{new BaseUuidUpgradeProcess(){

            protected String[][] getTableAndPrimaryKeyColumnNames() {
                return new String[][]{{"CIWarehouse", "CIWarehouseId"}, {"CIWarehouseItem", "CIWarehouseItemId"}};
            }
        }});
        registry.register("2.3.0", "2.3.1", new UpgradeStep[]{new BaseExternalReferenceCodeUpgradeProcess(){

            protected String[][] getTableAndPrimaryKeyColumnNames() {
                return new String[][]{{"CIWarehouse", "CIWarehouseId"}, {"CIWarehouseItem", "CIWarehouseItemId"}};
            }
        }});
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce inventory upgrade step registrator finished");
        }
    }
}

