/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryReplenishmentItem;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.base.CommerceInventoryReplenishmentItemServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.util.Date;
import java.util.List;

public class CommerceInventoryReplenishmentItemServiceImpl
extends CommerceInventoryReplenishmentItemServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceInventoryWarehouse> _commerceInventoryWarehouseModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceInventoryReplenishmentItemServiceImpl.class, (String)"_commerceInventoryWarehouseModelResourcePermission", CommerceInventoryWarehouse.class);

    public CommerceInventoryReplenishmentItem addCommerceInventoryReplenishmentItem(long commerceInventoryWarehouseId, String sku, Date availabilityDate, int quantity) throws PortalException {
        _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.commerceInventoryReplenishmentItemLocalService.addCommerceInventoryReplenishmentItem(this.getUserId(), commerceInventoryWarehouseId, sku, availabilityDate, quantity);
    }

    public void deleteCommerceInventoryReplenishmentItem(long commerceInventoryReplenishmentItemId) throws PortalException {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemLocalService.fetchCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItemId);
        if (commerceInventoryReplenishmentItem != null) {
            _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryReplenishmentItem.getCommerceInventoryWarehouseId(), "UPDATE");
        }
        this.commerceInventoryReplenishmentItemLocalService.deleteCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItemId);
    }

    public CommerceInventoryReplenishmentItem getCommerceInventoryReplenishmentItem(long commerceInventoryReplenishmentItemId) throws PortalException {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemLocalService.fetchCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItemId);
        if (commerceInventoryReplenishmentItem != null) {
            _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryReplenishmentItem.getCommerceInventoryWarehouseId(), "VIEW");
        }
        return this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItemId);
    }

    public List<CommerceInventoryReplenishmentItem> getCommerceInventoryReplenishmentItemsByCompanyIdAndSku(long companyId, String sku, int start, int end) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItemsByCompanyIdAndSku(companyId, sku, start, end);
    }

    public long getCommerceInventoryReplenishmentItemsCount(long commerceInventoryWarehouseId, String sku) throws PortalException {
        _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "VIEW");
        return this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItemsCount(commerceInventoryWarehouseId, sku);
    }

    public int getCommerceInventoryReplenishmentItemsCountByCompanyIdAndSku(long companyId, String sku) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItemsCountByCompanyIdAndSku(companyId, sku);
    }

    public CommerceInventoryReplenishmentItem updateCommerceInventoryReplenishmentItem(long commerceInventoryReplenishmentItemId, Date availabilityDate, int quantity, long mvccVersion) throws PortalException {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemLocalService.fetchCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItemId);
        if (commerceInventoryReplenishmentItem != null) {
            _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryReplenishmentItem.getCommerceInventoryWarehouseId(), "UPDATE");
        }
        return this.commerceInventoryReplenishmentItemLocalService.updateCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItemId, availabilityDate, quantity, mvccVersion);
    }
}

