/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.type;

import com.liferay.commerce.inventory.type.CommerceInventoryAuditType;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"commerce.inventory.audit.type.key=restore-quantity"}, service={CommerceInventoryAuditType.class})
public class RestoreQuantityCommerceInventoryAuditTypeImpl
implements CommerceInventoryAuditType {
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private UserLocalService _userLocalService;

    public String formatLog(long userId, String context, Locale locale) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(context);
        User user = this._userLocalService.getUserById(userId);
        return this._language.format(locale, "x-restocked-the-quantity-from-shipment-x", new Object[]{user.getFullName(), jsonObject.get("shipmentId")});
    }

    public String formatQuantity(int quantity, Locale locale) {
        return "+ " + quantity;
    }

    public String getLog(Map<String, String> context) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (Map.Entry<String, String> entry : context.entrySet()) {
            jsonObject.put(entry.getKey(), entry.getValue());
        }
        return jsonObject.toString();
    }

    public String getType() {
        return "restore-quantity";
    }
}

