/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.upgrade.registry;

import com.liferay.commerce.inventory.internal.upgrade.v2_0_0.CommerceInventoryAuditUpgradeProcess;
import com.liferay.commerce.inventory.internal.upgrade.v2_1_0.MVCCUpgradeProcess;
import com.liferay.commerce.inventory.internal.upgrade.v2_5_0.CommerceInventoryWarehouseUpgradeProcess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.upgrade.BaseExternalReferenceCodeUpgradeProcess;
import com.liferay.portal.kernel.upgrade.BaseUuidUpgradeProcess;
import com.liferay.portal.kernel.upgrade.DummyUpgradeProcess;
import com.liferay.portal.kernel.upgrade.MVCCVersionUpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={UpgradeStepRegistrator.class})
public class CommerceInventoryServiceUpgradeStepRegistrator
implements UpgradeStepRegistrator {
    private static final Log _log = LogFactoryUtil.getLog(CommerceInventoryServiceUpgradeStepRegistrator.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;

    public void register(UpgradeStepRegistrator.Registry registry) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce inventory upgrade step registrator started");
        }
        registry.register("1.0.0", "1.1.0", new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"CIWarehouseItem", (String[])new String[]{"externalReferenceCode VARCHAR(75)"})});
        registry.register("1.1.0", "1.2.0", new UpgradeStep[]{new DummyUpgradeProcess()});
        registry.register("1.2.0", "2.0.0", new UpgradeStep[]{new CommerceInventoryAuditUpgradeProcess()});
        registry.register("2.0.0", "2.1.0", new UpgradeStep[]{new MVCCUpgradeProcess()});
        registry.register("2.1.0", "2.2.0", new UpgradeStep[]{new MVCCVersionUpgradeProcess(){

            protected String[] getModuleTableNames() {
                return new String[]{"CIAudit", "CIBookedQuantity", "CIReplenishmentItem", "CIWarehouse", "CIWarehouseGroupRel", "CIWarehouseItem"};
            }
        }});
        registry.register("2.2.0", "2.3.0", new UpgradeStep[]{new BaseUuidUpgradeProcess(){

            protected String[][] getTableAndPrimaryKeyColumnNames() {
                return new String[][]{{"CIWarehouse", "CIWarehouseId"}, {"CIWarehouseItem", "CIWarehouseItemId"}};
            }
        }});
        registry.register("2.3.0", "2.3.1", new UpgradeStep[]{new BaseExternalReferenceCodeUpgradeProcess(){

            protected String[][] getTableAndPrimaryKeyColumnNames() {
                return new String[][]{{"CIWarehouse", "CIWarehouseId"}, {"CIWarehouseItem", "CIWarehouseItemId"}};
            }
        }});
        registry.register("2.3.1", "2.4.0", new UpgradeStep[]{new BaseUuidUpgradeProcess(){

            protected String[][] getTableAndPrimaryKeyColumnNames() {
                return new String[][]{{"CIReplenishmentItem", "CIReplenishmentItemId"}};
            }
        }});
        registry.register("2.4.0", "2.4.1", new UpgradeStep[]{new BaseExternalReferenceCodeUpgradeProcess(){

            protected String[][] getTableAndPrimaryKeyColumnNames() {
                return new String[][]{{"CIReplenishmentItem", "CIReplenishmentItemId"}};
            }
        }});
        registry.register("2.4.1", "2.5.0", new UpgradeStep[]{new CommerceInventoryWarehouseUpgradeProcess(this._companyLocalService, this._resourceActionLocalService, this._resourceLocalService)});
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce inventory upgrade step registrator finished");
        }
    }
}

