/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.upgrade.v2_5_0;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;

public class CommerceInventoryWarehouseUpgradeProcess
extends UpgradeProcess {
    private static final String[] _OWNER_PERMISSIONS = new String[]{"DELETE", "PERMISSIONS", "UPDATE", "VIEW"};
    private final CompanyLocalService _companyLocalService;
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourceLocalService _resourceLocalService;

    public CommerceInventoryWarehouseUpgradeProcess(CompanyLocalService companyLocalService, ResourceActionLocalService resourceActionLocalService, ResourceLocalService resourceLocalService) {
        this._companyLocalService = companyLocalService;
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourceLocalService = resourceLocalService;
    }

    public void doUpgrade() throws Exception {
        this._resourceActionLocalService.checkResourceActions(CommerceInventoryWarehouse.class.getName(), Arrays.asList(_OWNER_PERMISSIONS), true);
        String selectCommerceInventoryWarehouseSQL = "select companyId, CIWarehouseId from CIWarehouse";
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery(selectCommerceInventoryWarehouseSQL);){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                Company company = this._companyLocalService.getCompany(companyId);
                long commerceInventoryWarehouseId = resultSet.getLong("CIWarehouseId");
                this._resourceLocalService.updateResources(companyId, company.getGroupId(), CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouseId, new String[]{"VIEW"}, new String[]{"VIEW"});
            }
        }
    }
}

