/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryAudit;
import com.liferay.commerce.inventory.service.base.CommerceInventoryAuditLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryAudit"}, service={AopService.class})
public class CommerceInventoryAuditLocalServiceImpl
extends CommerceInventoryAuditLocalServiceBaseImpl {
    @Reference
    private UserLocalService _userLocalService;

    public CommerceInventoryAudit addCommerceInventoryAudit(long userId, String sku, String logType, String logTypeSettings, int quantity) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long commerceInventoryAuditId = this.counterLocalService.increment();
        CommerceInventoryAudit commerceInventoryAudit = this.commerceInventoryAuditPersistence.create(commerceInventoryAuditId);
        commerceInventoryAudit.setCompanyId(user.getCompanyId());
        commerceInventoryAudit.setUserId(user.getUserId());
        commerceInventoryAudit.setUserName(user.getFullName());
        commerceInventoryAudit.setSku(sku);
        commerceInventoryAudit.setLogType(logType);
        commerceInventoryAudit.setLogTypeSettings(logTypeSettings);
        commerceInventoryAudit.setQuantity(quantity);
        return (CommerceInventoryAudit)this.commerceInventoryAuditPersistence.update((BaseModel)commerceInventoryAudit);
    }

    public void checkCommerceInventoryAudit(Date date) {
        this.commerceInventoryAuditPersistence.removeByLtCreateDate(date);
    }

    public List<CommerceInventoryAudit> getCommerceInventoryAudits(long companyId, String sku, int start, int end) {
        return this.commerceInventoryAuditPersistence.findByC_S(companyId, sku, start, end);
    }

    public int getCommerceInventoryAuditsCount(long companyId, String sku) {
        return this.commerceInventoryAuditPersistence.countByC_S(companyId, sku);
    }
}

