/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.exception.MVCCException;
import com.liferay.commerce.inventory.exception.NoSuchInventoryBookedQuantityException;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.service.CommerceInventoryAuditLocalService;
import com.liferay.commerce.inventory.service.base.CommerceInventoryBookedQuantityLocalServiceBaseImpl;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditType;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditTypeRegistry;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity"}, service={AopService.class})
public class CommerceInventoryBookedQuantityLocalServiceImpl
extends CommerceInventoryBookedQuantityLocalServiceBaseImpl {
    @Reference
    private CommerceInventoryAuditLocalService _commerceInventoryAuditLocalService;
    @Reference
    private CommerceInventoryAuditTypeRegistry _commerceInventoryAuditTypeRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceInventoryBookedQuantity addCommerceBookedQuantity(long userId, String sku, int quantity, Date expirationDate, Map<String, String> context) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long commerceInventoryBookedQuantityId = this.counterLocalService.increment();
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.commerceInventoryBookedQuantityPersistence.create(commerceInventoryBookedQuantityId);
        commerceInventoryBookedQuantity.setCompanyId(user.getCompanyId());
        commerceInventoryBookedQuantity.setUserId(user.getUserId());
        commerceInventoryBookedQuantity.setUserName(user.getFullName());
        commerceInventoryBookedQuantity.setSku(sku);
        commerceInventoryBookedQuantity.setQuantity(quantity);
        commerceInventoryBookedQuantity.setExpirationDate(expirationDate);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("booked-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, sku, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), quantity);
        return (CommerceInventoryBookedQuantity)this.commerceInventoryBookedQuantityPersistence.update((BaseModel)commerceInventoryBookedQuantity);
    }

    public void checkCommerceInventoryBookedQuantities() {
        this.commerceInventoryBookedQuantityPersistence.removeByLtExpirationDate(new Date());
    }

    public CommerceInventoryBookedQuantity consumeCommerceBookedQuantity(long commerceBookedQuantityId, int quantity) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.commerceInventoryBookedQuantityPersistence.findByPrimaryKey(commerceBookedQuantityId);
        if (quantity < commerceInventoryBookedQuantity.getQuantity()) {
            int newQuantity = commerceInventoryBookedQuantity.getQuantity() - quantity;
            commerceInventoryBookedQuantity.setQuantity(newQuantity);
            return (CommerceInventoryBookedQuantity)this.commerceInventoryBookedQuantityPersistence.update((BaseModel)commerceInventoryBookedQuantity);
        }
        return this.commerceInventoryBookedQuantityPersistence.remove(commerceBookedQuantityId);
    }

    public int getCommerceBookedQuantity(long companyId, String sku) {
        List commerceInventoryBookedQuantities = this.commerceInventoryBookedQuantityPersistence.findByC_S(companyId, sku);
        int resultQuantity = 0;
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : commerceInventoryBookedQuantities) {
            resultQuantity += commerceInventoryBookedQuantity.getQuantity();
        }
        return resultQuantity;
    }

    public List<CommerceInventoryBookedQuantity> getCommerceInventoryBookedQuantities(long companyId, String sku, int start, int end) {
        return this.commerceInventoryBookedQuantityPersistence.findByC_S(companyId, sku, start, end);
    }

    public int getCommerceInventoryBookedQuantitiesCount(long companyId, String sku) {
        return this.commerceInventoryBookedQuantityPersistence.countByC_S(companyId, sku);
    }

    public CommerceInventoryBookedQuantity resetCommerceBookedQuantity(long commerceBookedQuantityId, long userId, String sku, int quantity, Date expirationDate, Map<String, String> context) throws PortalException {
        CommerceInventoryBookedQuantity commerceBookedQuantity = this.commerceInventoryBookedQuantityPersistence.fetchByPrimaryKey(commerceBookedQuantityId);
        if (commerceBookedQuantity == null) {
            User user = this._userLocalService.getUser(userId);
            commerceBookedQuantity = this.commerceInventoryBookedQuantityPersistence.create(commerceBookedQuantityId);
            commerceBookedQuantity.setCompanyId(user.getCompanyId());
            commerceBookedQuantity.setUserId(userId);
            commerceBookedQuantity.setUserName(user.getFullName());
            commerceBookedQuantity.setSku(sku);
            commerceBookedQuantity.setExpirationDate(expirationDate);
        } else {
            quantity = commerceBookedQuantity.getQuantity() + quantity;
            if (quantity < 0) {
                quantity = 0;
            }
        }
        commerceBookedQuantity.setQuantity(quantity);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("restore-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, sku, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), quantity);
        return (CommerceInventoryBookedQuantity)this.commerceInventoryBookedQuantityPersistence.update((BaseModel)commerceBookedQuantity);
    }

    public CommerceInventoryBookedQuantity restockCommerceInventoryBookedQuantity(long userId, long commerceInventoryBookedQuantityId, Map<String, String> context) throws PortalException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.commerceInventoryBookedQuantityPersistence.remove(commerceInventoryBookedQuantityId);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("restock-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryBookedQuantity.getSku(), commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), commerceInventoryBookedQuantity.getQuantity());
        return commerceInventoryBookedQuantity;
    }

    public CommerceInventoryBookedQuantity updateCommerceInventoryBookedQuantity(long userId, long commerceInventoryBookedQuantityId, int quantity, Map<String, String> context, long mvccVersion) throws PortalException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.commerceInventoryBookedQuantityLocalService.getCommerceInventoryBookedQuantity(commerceInventoryBookedQuantityId);
        if (commerceInventoryBookedQuantity.getMvccVersion() != mvccVersion) {
            throw new MVCCException();
        }
        commerceInventoryBookedQuantity.setQuantity(quantity);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("update-booked-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryBookedQuantity.getSku(), commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), quantity);
        return this.commerceInventoryBookedQuantityLocalService.updateCommerceInventoryBookedQuantity(commerceInventoryBookedQuantity);
    }
}

