/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryReplenishmentItem;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.base.CommerceInventoryReplenishmentItemServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceInventoryReplenishmentItem"}, service={AopService.class})
public class CommerceInventoryReplenishmentItemServiceImpl
extends CommerceInventoryReplenishmentItemServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryWarehouse)")
    private ModelResourcePermission<CommerceInventoryWarehouse> _commerceInventoryWarehouseModelResourcePermission;

    public CommerceInventoryReplenishmentItem addCommerceInventoryReplenishmentItem(String externalReferenceCode, long commerceInventoryWarehouseId, String sku, Date availabilityDate, int quantity) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.commerceInventoryReplenishmentItemLocalService.addCommerceInventoryReplenishmentItem(externalReferenceCode, this.getUserId(), commerceInventoryWarehouseId, sku, availabilityDate, quantity);
    }

    public void deleteCommerceInventoryReplenishmentItem(long commerceInventoryReplenishmentItemId) throws PortalException {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemLocalService.fetchCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItemId);
        if (commerceInventoryReplenishmentItem != null) {
            this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryReplenishmentItem.getCommerceInventoryWarehouseId(), "UPDATE");
        }
        this.commerceInventoryReplenishmentItemLocalService.deleteCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItemId);
    }

    public void deleteCommerceInventoryReplenishmentItems(long companyId, String sku) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        this.commerceInventoryReplenishmentItemLocalService.deleteCommerceInventoryReplenishmentItems(companyId, sku);
    }

    public CommerceInventoryReplenishmentItem fetchCommerceInventoryReplenishmentItemByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemLocalService.fetchCommerceInventoryReplenishmentItemByExternalReferenceCode(companyId, externalReferenceCode);
        if (commerceInventoryReplenishmentItem != null) {
            this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryReplenishmentItem.getCommerceInventoryWarehouseId(), "VIEW");
        }
        return commerceInventoryReplenishmentItem;
    }

    public CommerceInventoryReplenishmentItem getCommerceInventoryReplenishmentItem(long commerceInventoryReplenishmentItemId) throws PortalException {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItemId);
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryReplenishmentItem.getCommerceInventoryWarehouseId(), "VIEW");
        return commerceInventoryReplenishmentItem;
    }

    public List<CommerceInventoryReplenishmentItem> getCommerceInventoryReplenishmentItemsByCommerceInventoryWarehouseId(long commerceInventoryWarehouseId, int start, int end) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "VIEW");
        return this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItemsByCommerceInventoryWarehouseId(commerceInventoryWarehouseId, start, end);
    }

    public List<CommerceInventoryReplenishmentItem> getCommerceInventoryReplenishmentItemsByCompanyIdAndSku(long companyId, String sku, int start, int end) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItemsByCompanyIdAndSku(companyId, sku, start, end);
    }

    public long getCommerceInventoryReplenishmentItemsCount(long commerceInventoryWarehouseId, String sku) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "VIEW");
        return this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItemsCount(commerceInventoryWarehouseId, sku);
    }

    public int getCommerceInventoryReplenishmentItemsCountByCommerceInventoryWarehouseId(long commerceInventoryWarehouseId) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "VIEW");
        return this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItemsCountByCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
    }

    public int getCommerceInventoryReplenishmentItemsCountByCompanyIdAndSku(long companyId, String sku) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItemsCountByCompanyIdAndSku(companyId, sku);
    }

    public CommerceInventoryReplenishmentItem updateCommerceInventoryReplenishmentItem(String externalReferenceCode, long commerceInventoryReplenishmentItemId, Date availabilityDate, int quantity, long mvccVersion) throws PortalException {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemLocalService.fetchCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItemId);
        if (commerceInventoryReplenishmentItem != null) {
            this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryReplenishmentItem.getCommerceInventoryWarehouseId(), "UPDATE");
        }
        return this.commerceInventoryReplenishmentItemLocalService.updateCommerceInventoryReplenishmentItem(externalReferenceCode, commerceInventoryReplenishmentItemId, availabilityDate, quantity, mvccVersion);
    }
}

