/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.inventory.model.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryAudit;
import com.liferay.commerce.inventory.service.CommerceInventoryAuditLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceInventoryAudit service. Represents a row in the &quot;CIAudit&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceInventoryAuditImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceInventoryAuditImpl
 * @see CommerceInventoryAudit
 * @generated
 */
public abstract class CommerceInventoryAuditBaseImpl
	extends CommerceInventoryAuditModelImpl implements CommerceInventoryAudit {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce inventory audit model instance should use the <code>CommerceInventoryAudit</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceInventoryAuditLocalServiceUtil.addCommerceInventoryAudit(
				this);
		}
		else {
			CommerceInventoryAuditLocalServiceUtil.updateCommerceInventoryAudit(
				this);
		}
	}

}