/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.inventory.model.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceInventoryWarehouseItem service. Represents a row in the &quot;CIWarehouseItem&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceInventoryWarehouseItemImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceInventoryWarehouseItemImpl
 * @see CommerceInventoryWarehouseItem
 * @generated
 */
public abstract class CommerceInventoryWarehouseItemBaseImpl
	extends CommerceInventoryWarehouseItemModelImpl
	implements CommerceInventoryWarehouseItem {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce inventory warehouse item model instance should use the <code>CommerceInventoryWarehouseItem</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceInventoryWarehouseItemLocalServiceUtil.
				addCommerceInventoryWarehouseItem(this);
		}
		else {
			CommerceInventoryWarehouseItemLocalServiceUtil.
				updateCommerceInventoryWarehouseItem(this);
		}
	}

}