/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.inventory.model.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItemModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceInventoryWarehouseItem service. Represents a row in the &quot;CIWarehouseItem&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceInventoryWarehouseItemModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceInventoryWarehouseItemImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceInventoryWarehouseItemImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceInventoryWarehouseItemModelImpl
	extends BaseModelImpl<CommerceInventoryWarehouseItem>
	implements CommerceInventoryWarehouseItemModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce inventory warehouse item model instance should use the <code>CommerceInventoryWarehouseItem</code> interface instead.
	 */
	public static final String TABLE_NAME = "CIWarehouseItem";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"externalReferenceCode", Types.VARCHAR},
		{"CIWarehouseItemId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"commerceInventoryWarehouseId", Types.BIGINT},
		{"quantity", Types.DECIMAL}, {"reservedQuantity", Types.DECIMAL},
		{"sku", Types.VARCHAR}, {"unitOfMeasureKey", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("CIWarehouseItemId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commerceInventoryWarehouseId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("quantity", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("reservedQuantity", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("sku", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("unitOfMeasureKey", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CIWarehouseItem (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,CIWarehouseItemId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commerceInventoryWarehouseId LONG,quantity BIGDECIMAL null,reservedQuantity BIGDECIMAL null,sku VARCHAR(75) null,unitOfMeasureKey VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP = "drop table CIWarehouseItem";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceInventoryWarehouseItem.commerceInventoryWarehouseItemId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CIWarehouseItem.CIWarehouseItemId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCEINVENTORYWAREHOUSEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SKU_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCEINVENTORYWAREHOUSEITEMID_COLUMN_BITMASK =
		32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CommerceInventoryWarehouseItemModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceInventoryWarehouseItemId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceInventoryWarehouseItemId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceInventoryWarehouseItemId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceInventoryWarehouseItem.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceInventoryWarehouseItem.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceInventoryWarehouseItem, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceInventoryWarehouseItem, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceInventoryWarehouseItem, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(CommerceInventoryWarehouseItem)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceInventoryWarehouseItem, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceInventoryWarehouseItem, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceInventoryWarehouseItem)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceInventoryWarehouseItem, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceInventoryWarehouseItem, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map
			<String, Function<CommerceInventoryWarehouseItem, Object>>
				_attributeGetterFunctions;

		static {
			Map<String, Function<CommerceInventoryWarehouseItem, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String,
						 Function<CommerceInventoryWarehouseItem, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", CommerceInventoryWarehouseItem::getMvccVersion);
			attributeGetterFunctions.put(
				"uuid", CommerceInventoryWarehouseItem::getUuid);
			attributeGetterFunctions.put(
				"externalReferenceCode",
				CommerceInventoryWarehouseItem::getExternalReferenceCode);
			attributeGetterFunctions.put(
				"commerceInventoryWarehouseItemId",
				CommerceInventoryWarehouseItem::
					getCommerceInventoryWarehouseItemId);
			attributeGetterFunctions.put(
				"companyId", CommerceInventoryWarehouseItem::getCompanyId);
			attributeGetterFunctions.put(
				"userId", CommerceInventoryWarehouseItem::getUserId);
			attributeGetterFunctions.put(
				"userName", CommerceInventoryWarehouseItem::getUserName);
			attributeGetterFunctions.put(
				"createDate", CommerceInventoryWarehouseItem::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate",
				CommerceInventoryWarehouseItem::getModifiedDate);
			attributeGetterFunctions.put(
				"commerceInventoryWarehouseId",
				CommerceInventoryWarehouseItem::
					getCommerceInventoryWarehouseId);
			attributeGetterFunctions.put(
				"quantity", CommerceInventoryWarehouseItem::getQuantity);
			attributeGetterFunctions.put(
				"reservedQuantity",
				CommerceInventoryWarehouseItem::getReservedQuantity);
			attributeGetterFunctions.put(
				"sku", CommerceInventoryWarehouseItem::getSku);
			attributeGetterFunctions.put(
				"unitOfMeasureKey",
				CommerceInventoryWarehouseItem::getUnitOfMeasureKey);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<CommerceInventoryWarehouseItem, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<CommerceInventoryWarehouseItem, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String,
						 BiConsumer<CommerceInventoryWarehouseItem, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<CommerceInventoryWarehouseItem, Long>)
					CommerceInventoryWarehouseItem::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<CommerceInventoryWarehouseItem, String>)
					CommerceInventoryWarehouseItem::setUuid);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<CommerceInventoryWarehouseItem, String>)
					CommerceInventoryWarehouseItem::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"commerceInventoryWarehouseItemId",
				(BiConsumer<CommerceInventoryWarehouseItem, Long>)
					CommerceInventoryWarehouseItem::
						setCommerceInventoryWarehouseItemId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<CommerceInventoryWarehouseItem, Long>)
					CommerceInventoryWarehouseItem::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<CommerceInventoryWarehouseItem, Long>)
					CommerceInventoryWarehouseItem::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<CommerceInventoryWarehouseItem, String>)
					CommerceInventoryWarehouseItem::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<CommerceInventoryWarehouseItem, Date>)
					CommerceInventoryWarehouseItem::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<CommerceInventoryWarehouseItem, Date>)
					CommerceInventoryWarehouseItem::setModifiedDate);
			attributeSetterBiConsumers.put(
				"commerceInventoryWarehouseId",
				(BiConsumer<CommerceInventoryWarehouseItem, Long>)
					CommerceInventoryWarehouseItem::
						setCommerceInventoryWarehouseId);
			attributeSetterBiConsumers.put(
				"quantity",
				(BiConsumer<CommerceInventoryWarehouseItem, BigDecimal>)
					CommerceInventoryWarehouseItem::setQuantity);
			attributeSetterBiConsumers.put(
				"reservedQuantity",
				(BiConsumer<CommerceInventoryWarehouseItem, BigDecimal>)
					CommerceInventoryWarehouseItem::setReservedQuantity);
			attributeSetterBiConsumers.put(
				"sku",
				(BiConsumer<CommerceInventoryWarehouseItem, String>)
					CommerceInventoryWarehouseItem::setSku);
			attributeSetterBiConsumers.put(
				"unitOfMeasureKey",
				(BiConsumer<CommerceInventoryWarehouseItem, String>)
					CommerceInventoryWarehouseItem::setUnitOfMeasureKey);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getCommerceInventoryWarehouseItemId() {
		return _commerceInventoryWarehouseItemId;
	}

	@Override
	public void setCommerceInventoryWarehouseItemId(
		long commerceInventoryWarehouseItemId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceInventoryWarehouseItemId = commerceInventoryWarehouseItemId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommerceInventoryWarehouseId() {
		return _commerceInventoryWarehouseId;
	}

	@Override
	public void setCommerceInventoryWarehouseId(
		long commerceInventoryWarehouseId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceInventoryWarehouseId = commerceInventoryWarehouseId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommerceInventoryWarehouseId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commerceInventoryWarehouseId"));
	}

	@JSON
	@Override
	public BigDecimal getQuantity() {
		return _quantity;
	}

	@Override
	public void setQuantity(BigDecimal quantity) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_quantity = quantity;
	}

	@JSON
	@Override
	public BigDecimal getReservedQuantity() {
		return _reservedQuantity;
	}

	@Override
	public void setReservedQuantity(BigDecimal reservedQuantity) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_reservedQuantity = reservedQuantity;
	}

	@JSON
	@Override
	public String getSku() {
		if (_sku == null) {
			return "";
		}
		else {
			return _sku;
		}
	}

	@Override
	public void setSku(String sku) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sku = sku;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalSku() {
		return getColumnOriginalValue("sku");
	}

	@JSON
	@Override
	public String getUnitOfMeasureKey() {
		if (_unitOfMeasureKey == null) {
			return "";
		}
		else {
			return _unitOfMeasureKey;
		}
	}

	@Override
	public void setUnitOfMeasureKey(String unitOfMeasureKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_unitOfMeasureKey = unitOfMeasureKey;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(
				CommerceInventoryWarehouseItem.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceInventoryWarehouseItem.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceInventoryWarehouseItem toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceInventoryWarehouseItem>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceInventoryWarehouseItemImpl commerceInventoryWarehouseItemImpl =
			new CommerceInventoryWarehouseItemImpl();

		commerceInventoryWarehouseItemImpl.setMvccVersion(getMvccVersion());
		commerceInventoryWarehouseItemImpl.setUuid(getUuid());
		commerceInventoryWarehouseItemImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		commerceInventoryWarehouseItemImpl.setCommerceInventoryWarehouseItemId(
			getCommerceInventoryWarehouseItemId());
		commerceInventoryWarehouseItemImpl.setCompanyId(getCompanyId());
		commerceInventoryWarehouseItemImpl.setUserId(getUserId());
		commerceInventoryWarehouseItemImpl.setUserName(getUserName());
		commerceInventoryWarehouseItemImpl.setCreateDate(getCreateDate());
		commerceInventoryWarehouseItemImpl.setModifiedDate(getModifiedDate());
		commerceInventoryWarehouseItemImpl.setCommerceInventoryWarehouseId(
			getCommerceInventoryWarehouseId());
		commerceInventoryWarehouseItemImpl.setQuantity(getQuantity());
		commerceInventoryWarehouseItemImpl.setReservedQuantity(
			getReservedQuantity());
		commerceInventoryWarehouseItemImpl.setSku(getSku());
		commerceInventoryWarehouseItemImpl.setUnitOfMeasureKey(
			getUnitOfMeasureKey());

		commerceInventoryWarehouseItemImpl.resetOriginalValues();

		return commerceInventoryWarehouseItemImpl;
	}

	@Override
	public CommerceInventoryWarehouseItem cloneWithOriginalValues() {
		CommerceInventoryWarehouseItemImpl commerceInventoryWarehouseItemImpl =
			new CommerceInventoryWarehouseItemImpl();

		commerceInventoryWarehouseItemImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		commerceInventoryWarehouseItemImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		commerceInventoryWarehouseItemImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		commerceInventoryWarehouseItemImpl.setCommerceInventoryWarehouseItemId(
			this.<Long>getColumnOriginalValue("CIWarehouseItemId"));
		commerceInventoryWarehouseItemImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		commerceInventoryWarehouseItemImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		commerceInventoryWarehouseItemImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		commerceInventoryWarehouseItemImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		commerceInventoryWarehouseItemImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		commerceInventoryWarehouseItemImpl.setCommerceInventoryWarehouseId(
			this.<Long>getColumnOriginalValue("commerceInventoryWarehouseId"));
		commerceInventoryWarehouseItemImpl.setQuantity(
			this.<BigDecimal>getColumnOriginalValue("quantity"));
		commerceInventoryWarehouseItemImpl.setReservedQuantity(
			this.<BigDecimal>getColumnOriginalValue("reservedQuantity"));
		commerceInventoryWarehouseItemImpl.setSku(
			this.<String>getColumnOriginalValue("sku"));
		commerceInventoryWarehouseItemImpl.setUnitOfMeasureKey(
			this.<String>getColumnOriginalValue("unitOfMeasureKey"));

		return commerceInventoryWarehouseItemImpl;
	}

	@Override
	public int compareTo(
		CommerceInventoryWarehouseItem commerceInventoryWarehouseItem) {

		long primaryKey = commerceInventoryWarehouseItem.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceInventoryWarehouseItem)) {
			return false;
		}

		CommerceInventoryWarehouseItem commerceInventoryWarehouseItem =
			(CommerceInventoryWarehouseItem)object;

		long primaryKey = commerceInventoryWarehouseItem.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceInventoryWarehouseItem> toCacheModel() {
		CommerceInventoryWarehouseItemCacheModel
			commerceInventoryWarehouseItemCacheModel =
				new CommerceInventoryWarehouseItemCacheModel();

		commerceInventoryWarehouseItemCacheModel.mvccVersion = getMvccVersion();

		commerceInventoryWarehouseItemCacheModel.uuid = getUuid();

		String uuid = commerceInventoryWarehouseItemCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceInventoryWarehouseItemCacheModel.uuid = null;
		}

		commerceInventoryWarehouseItemCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commerceInventoryWarehouseItemCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commerceInventoryWarehouseItemCacheModel.externalReferenceCode =
				null;
		}

		commerceInventoryWarehouseItemCacheModel.
			commerceInventoryWarehouseItemId =
				getCommerceInventoryWarehouseItemId();

		commerceInventoryWarehouseItemCacheModel.companyId = getCompanyId();

		commerceInventoryWarehouseItemCacheModel.userId = getUserId();

		commerceInventoryWarehouseItemCacheModel.userName = getUserName();

		String userName = commerceInventoryWarehouseItemCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceInventoryWarehouseItemCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceInventoryWarehouseItemCacheModel.createDate =
				createDate.getTime();
		}
		else {
			commerceInventoryWarehouseItemCacheModel.createDate =
				Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceInventoryWarehouseItemCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commerceInventoryWarehouseItemCacheModel.modifiedDate =
				Long.MIN_VALUE;
		}

		commerceInventoryWarehouseItemCacheModel.commerceInventoryWarehouseId =
			getCommerceInventoryWarehouseId();

		commerceInventoryWarehouseItemCacheModel.quantity = getQuantity();

		commerceInventoryWarehouseItemCacheModel.reservedQuantity =
			getReservedQuantity();

		commerceInventoryWarehouseItemCacheModel.sku = getSku();

		String sku = commerceInventoryWarehouseItemCacheModel.sku;

		if ((sku != null) && (sku.length() == 0)) {
			commerceInventoryWarehouseItemCacheModel.sku = null;
		}

		commerceInventoryWarehouseItemCacheModel.unitOfMeasureKey =
			getUnitOfMeasureKey();

		String unitOfMeasureKey =
			commerceInventoryWarehouseItemCacheModel.unitOfMeasureKey;

		if ((unitOfMeasureKey != null) && (unitOfMeasureKey.length() == 0)) {
			commerceInventoryWarehouseItemCacheModel.unitOfMeasureKey = null;
		}

		return commerceInventoryWarehouseItemCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceInventoryWarehouseItem, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceInventoryWarehouseItem, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceInventoryWarehouseItem, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceInventoryWarehouseItem)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, CommerceInventoryWarehouseItem>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						CommerceInventoryWarehouseItem.class,
						ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _externalReferenceCode;
	private long _commerceInventoryWarehouseItemId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commerceInventoryWarehouseId;
	private BigDecimal _quantity;
	private BigDecimal _reservedQuantity;
	private String _sku;
	private String _unitOfMeasureKey;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceInventoryWarehouseItem, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceInventoryWarehouseItem)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put(
			"CIWarehouseItemId", _commerceInventoryWarehouseItemId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"commerceInventoryWarehouseId", _commerceInventoryWarehouseId);
		_columnOriginalValues.put("quantity", _quantity);
		_columnOriginalValues.put("reservedQuantity", _reservedQuantity);
		_columnOriginalValues.put("sku", _sku);
		_columnOriginalValues.put("unitOfMeasureKey", _unitOfMeasureKey);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put(
			"CIWarehouseItemId", "commerceInventoryWarehouseItemId");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("externalReferenceCode", 4L);

		columnBitmasks.put("CIWarehouseItemId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("userName", 64L);

		columnBitmasks.put("createDate", 128L);

		columnBitmasks.put("modifiedDate", 256L);

		columnBitmasks.put("commerceInventoryWarehouseId", 512L);

		columnBitmasks.put("quantity", 1024L);

		columnBitmasks.put("reservedQuantity", 2048L);

		columnBitmasks.put("sku", 4096L);

		columnBitmasks.put("unitOfMeasureKey", 8192L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceInventoryWarehouseItem _escapedModel;

}