/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.engine;

import com.liferay.commerce.inventory.configuration.CommerceInventoryGroupConfiguration;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.inventory.method.CommerceInventoryMethod;
import com.liferay.commerce.inventory.method.CommerceInventoryMethodRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceInventoryEngine.class})
public class CommerceInventoryEngineImpl
implements CommerceInventoryEngine {
    private static final Log _log = LogFactoryUtil.getLog(CommerceInventoryEngineImpl.class);
    @Reference
    private CommerceInventoryMethodRegistry _commerceInventoryMethodRegistry;
    @Reference
    private ConfigurationProvider _configurationProvider;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void consumeQuantity(long userId, long commerceCatalogGroupId, long commerceInventoryWarehouseId, String sku, int quantity, long bookedQuantityId, Map<String, String> context) throws PortalException {
        CommerceInventoryMethod commerceInventoryMethod = this._getCommerceInventoryMethod(commerceCatalogGroupId);
        if (commerceInventoryMethod == null) {
            return;
        }
        commerceInventoryMethod.consumeQuantity(userId, commerceInventoryWarehouseId, sku, quantity, bookedQuantityId, context);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void decreaseStockQuantity(long userId, long commerceCatalogGroupId, long commerceInventoryWarehouseId, String sku, int quantity) throws PortalException {
        CommerceInventoryMethod commerceInventoryMethod = this._getCommerceInventoryMethod(commerceCatalogGroupId);
        commerceInventoryMethod.decreaseStockQuantity(userId, commerceInventoryWarehouseId, sku, quantity);
    }

    public String getAvailabilityStatus(long companyId, long commerceCatalogGroupId, long commerceChannelGroupId, int minStockQuantity, String sku) {
        CommerceInventoryMethod commerceInventoryMethod = this._getCommerceInventoryMethod(commerceCatalogGroupId);
        if (commerceInventoryMethod == null) {
            return null;
        }
        return commerceInventoryMethod.getAvailabilityStatus(companyId, commerceChannelGroupId, minStockQuantity, sku);
    }

    public int getStockQuantity(long companyId, long commerceCatalogGroupId, long commerceChannelGroupId, String sku) throws PortalException {
        CommerceInventoryMethod commerceInventoryMethod = this._getCommerceInventoryMethod(commerceCatalogGroupId);
        if (commerceInventoryMethod == null) {
            return 0;
        }
        return commerceInventoryMethod.getStockQuantity(companyId, commerceChannelGroupId, sku);
    }

    public int getStockQuantity(long companyId, long commerceCatalogGroupId, String sku) throws PortalException {
        CommerceInventoryMethod commerceInventoryMethod = this._getCommerceInventoryMethod(commerceCatalogGroupId);
        if (commerceInventoryMethod == null) {
            return 0;
        }
        return commerceInventoryMethod.getStockQuantity(companyId, sku);
    }

    public boolean hasStockQuantity(long companyId, long commerceCatalogGroupId, String sku, int quantity) {
        CommerceInventoryMethod commerceInventoryMethod = this._getCommerceInventoryMethod(commerceCatalogGroupId);
        if (commerceInventoryMethod == null) {
            return false;
        }
        return commerceInventoryMethod.hasStockQuantity(companyId, sku, quantity);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void increaseStockQuantity(long userId, long commerceCatalogGroupId, long commerceInventoryWarehouseId, String sku, int quantity) throws PortalException {
        CommerceInventoryMethod commerceInventoryMethod = this._getCommerceInventoryMethod(commerceCatalogGroupId);
        commerceInventoryMethod.increaseStockQuantity(userId, commerceInventoryWarehouseId, sku, quantity);
    }

    private CommerceInventoryMethod _getCommerceInventoryMethod(long commerceCatalogGroupId) {
        try {
            CommerceInventoryGroupConfiguration commerceInventoryGroupConfiguration = (CommerceInventoryGroupConfiguration)this._configurationProvider.getGroupConfiguration(CommerceInventoryGroupConfiguration.class, commerceCatalogGroupId);
            CommerceInventoryMethod commerceInventoryMethod = this._commerceInventoryMethodRegistry.getCommerceInventoryMethod(commerceInventoryGroupConfiguration.inventoryMethodKey());
            if (commerceInventoryMethod == null) {
                return this._commerceInventoryMethodRegistry.getCommerceInventoryMethod("default");
            }
            return commerceInventoryMethod;
        }
        catch (ConfigurationException configurationException) {
            _log.error((Throwable)configurationException);
            return this._commerceInventoryMethodRegistry.getCommerceInventoryMethod("default");
        }
    }
}

