/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.method;

import com.liferay.commerce.inventory.engine.contributor.CommerceInventoryEngineContributor;
import com.liferay.commerce.inventory.engine.contributor.CommerceInventoryEngineContributorRegistry;
import com.liferay.commerce.inventory.exception.MVCCException;
import com.liferay.commerce.inventory.method.CommerceInventoryMethod;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryAuditLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemService;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditType;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditTypeRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.inventory.method.key=default", "commerce.inventory.method.order:Integer=100"}, service={CommerceInventoryMethod.class})
public class DefaultCommerceInventoryMethodImpl
implements CommerceInventoryMethod {
    private static final Log _log = LogFactoryUtil.getLog(DefaultCommerceInventoryMethodImpl.class);
    @Reference
    private CommerceInventoryBookedQuantityLocalService _commerceBookedQuantityLocalService;
    @Reference
    private CommerceInventoryAuditLocalService _commerceInventoryAuditLocalService;
    @Reference
    private CommerceInventoryAuditTypeRegistry _commerceInventoryAuditTypeRegistry;
    @Reference
    private CommerceInventoryEngineContributorRegistry _commerceInventoryEngineContributorRegistry;
    @Reference
    private CommerceInventoryWarehouseItemLocalService _commerceInventoryWarehouseItemLocalService;
    @Reference
    private CommerceInventoryWarehouseItemService _commerceInventoryWarehouseItemService;
    @Reference
    private Language _language;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void consumeQuantity(long userId, long commerceInventoryWarehouseId, String sku, int quantity, long bookedQuantityId, Map<String, String> context) throws PortalException {
        if (bookedQuantityId > 0L) {
            this._commerceBookedQuantityLocalService.consumeCommerceBookedQuantity(bookedQuantityId, quantity);
        }
        this.decreaseStockQuantity(userId, commerceInventoryWarehouseId, sku, quantity);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("consume-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), BigDecimal.valueOf(quantity), sku, "");
        for (CommerceInventoryEngineContributor commerceInventoryEngineContributor : this._commerceInventoryEngineContributorRegistry.getCommerceInventoryEngineContributors()) {
            commerceInventoryEngineContributor.consumeQuantityContribute(userId, commerceInventoryWarehouseId, sku, quantity, bookedQuantityId, context);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void decreaseStockQuantity(long userId, long commerceInventoryWarehouseId, String sku, int quantity) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseId, sku);
        BigDecimal commerceInventoryWarehouseItemQuantity = commerceInventoryWarehouseItem.getQuantity();
        this._commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), commerceInventoryWarehouseItem.getMvccVersion(), commerceInventoryWarehouseItemQuantity.subtract(BigDecimal.valueOf(quantity)), commerceInventoryWarehouseItem.getUnitOfMeasureKey());
        for (CommerceInventoryEngineContributor commerceInventoryEngineContributor : this._commerceInventoryEngineContributorRegistry.getCommerceInventoryEngineContributors()) {
            commerceInventoryEngineContributor.decreaseStockQuantityContribute(userId, commerceInventoryWarehouseId, sku, quantity);
        }
    }

    public String getAvailabilityStatus(long companyId, long commerceChannelGroupId, int minStockQuantity, String sku) {
        return this._getAvailabilityStatus(minStockQuantity, this.getStockQuantity(companyId, commerceChannelGroupId, sku));
    }

    public String getKey() {
        return "default";
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return this._language.get(resourceBundle, this.getKey());
    }

    public int getStockQuantity(long companyId, long commerceChannelGroupId, String sku) {
        BigDecimal stockQuantity = this._commerceInventoryWarehouseItemService.getStockQuantity(companyId, commerceChannelGroupId, sku);
        int commerceBookedQuantity = this._commerceBookedQuantityLocalService.getCommerceBookedQuantity(companyId, commerceChannelGroupId, sku);
        return stockQuantity.intValue() - commerceBookedQuantity;
    }

    public int getStockQuantity(long companyId, String sku) {
        BigDecimal stockQuantity = this._commerceInventoryWarehouseItemService.getStockQuantity(companyId, sku);
        int commerceBookedQuantity = this._commerceBookedQuantityLocalService.getCommerceBookedQuantity(companyId, sku);
        return stockQuantity.intValue() - commerceBookedQuantity;
    }

    public boolean hasStockQuantity(long companyId, String sku, int quantity) {
        return quantity <= this.getStockQuantity(companyId, sku);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void increaseStockQuantity(long userId, long commerceInventoryWarehouseId, String sku, int quantity) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseId, sku);
        try {
            BigDecimal commerceInventoryWarehouseItemQuantity = commerceInventoryWarehouseItem.getQuantity();
            this._commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), commerceInventoryWarehouseItem.getMvccVersion(), commerceInventoryWarehouseItemQuantity.add(BigDecimal.valueOf(quantity)), commerceInventoryWarehouseItem.getUnitOfMeasureKey());
        }
        catch (MVCCException mvccException) {
            _log.error((Throwable)mvccException);
            throw mvccException;
        }
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("increase-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(null), BigDecimal.valueOf(quantity), sku, "");
        for (CommerceInventoryEngineContributor commerceInventoryEngineContributor : this._commerceInventoryEngineContributorRegistry.getCommerceInventoryEngineContributors()) {
            commerceInventoryEngineContributor.increaseStockQuantityContribute(userId, commerceInventoryWarehouseId, sku, quantity);
        }
    }

    private String _getAvailabilityStatus(int minStockQuantity, int stockQuantity) {
        String availabilityStatus = "unavailable";
        boolean available = false;
        if (stockQuantity > minStockQuantity) {
            available = true;
        }
        if (available) {
            availabilityStatus = "available";
        }
        return availabilityStatus;
    }
}

