/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.scheduler;

import com.liferay.commerce.inventory.configuration.CommerceInventorySystemConfiguration;
import com.liferay.commerce.inventory.service.CommerceInventoryAuditLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.inventory.configuration.CommerceInventorySystemConfiguration"}, service={SchedulerJobConfiguration.class})
public class CheckCommerceInventoryAuditSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    @Reference
    private CommerceInventoryAuditLocalService _commerceInventoryAuditLocalService;
    private CommerceInventorySystemConfiguration _commerceInventorySystemConfiguration;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> {
            int deleteAuditMonthInterval = this._commerceInventorySystemConfiguration.deleteAuditMonthInterval();
            Date date = new Date(System.currentTimeMillis() - (long)deleteAuditMonthInterval * 2592000000L);
            this._commerceInventoryAuditLocalService.checkCommerceInventoryAudit(date);
        };
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return TriggerConfiguration.createTriggerConfiguration((int)this._commerceInventorySystemConfiguration.checkCommerceInventoryAuditQuantityInterval(), (TimeUnit)TimeUnit.MINUTE);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._commerceInventorySystemConfiguration = (CommerceInventorySystemConfiguration)ConfigurableUtil.createConfigurable(CommerceInventorySystemConfiguration.class, properties);
    }
}

