/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.exception.MVCCException;
import com.liferay.commerce.inventory.exception.NoSuchInventoryBookedQuantityException;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantityTable;
import com.liferay.commerce.inventory.service.CommerceInventoryAuditLocalService;
import com.liferay.commerce.inventory.service.base.CommerceInventoryBookedQuantityLocalServiceBaseImpl;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditType;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditTypeRegistry;
import com.liferay.commerce.model.CommerceOrderItemTable;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupTable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity"}, service={AopService.class})
public class CommerceInventoryBookedQuantityLocalServiceImpl
extends CommerceInventoryBookedQuantityLocalServiceBaseImpl {
    @Reference
    private CommerceInventoryAuditLocalService _commerceInventoryAuditLocalService;
    @Reference
    private CommerceInventoryAuditTypeRegistry _commerceInventoryAuditTypeRegistry;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceInventoryBookedQuantity addCommerceBookedQuantity(long userId, Date expirationDate, int quantity, String sku, String unitOfMeasureKey, Map<String, String> context) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long commerceInventoryBookedQuantityId = this.counterLocalService.increment();
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.commerceInventoryBookedQuantityPersistence.create(commerceInventoryBookedQuantityId);
        commerceInventoryBookedQuantity.setCompanyId(user.getCompanyId());
        commerceInventoryBookedQuantity.setUserId(user.getUserId());
        commerceInventoryBookedQuantity.setUserName(user.getFullName());
        commerceInventoryBookedQuantity.setExpirationDate(expirationDate);
        commerceInventoryBookedQuantity.setQuantity(quantity);
        commerceInventoryBookedQuantity.setSku(sku);
        commerceInventoryBookedQuantity.setUnitOfMeasureKey(unitOfMeasureKey);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("booked-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), BigDecimal.valueOf(quantity), sku, "");
        return (CommerceInventoryBookedQuantity)this.commerceInventoryBookedQuantityPersistence.update((BaseModel)commerceInventoryBookedQuantity);
    }

    public void checkCommerceInventoryBookedQuantities() {
        this.commerceInventoryBookedQuantityPersistence.removeByLtExpirationDate(new Date());
    }

    public CommerceInventoryBookedQuantity consumeCommerceBookedQuantity(long commerceBookedQuantityId, int quantity) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.commerceInventoryBookedQuantityPersistence.findByPrimaryKey(commerceBookedQuantityId);
        if (quantity < commerceInventoryBookedQuantity.getQuantity()) {
            int newQuantity = commerceInventoryBookedQuantity.getQuantity() - quantity;
            commerceInventoryBookedQuantity.setQuantity(newQuantity);
            return (CommerceInventoryBookedQuantity)this.commerceInventoryBookedQuantityPersistence.update((BaseModel)commerceInventoryBookedQuantity);
        }
        return this.commerceInventoryBookedQuantityPersistence.remove(commerceBookedQuantityId);
    }

    public int getCommerceBookedQuantity(long companyId, long commerceChannelGroupId, String sku) {
        List result = (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.sum((Expression)CommerceInventoryBookedQuantityTable.INSTANCE.quantity).as("SUM_VALUE")}).from((Table)CommerceInventoryBookedQuantityTable.INSTANCE).innerJoinON((Table)CommerceOrderItemTable.INSTANCE, CommerceInventoryBookedQuantityTable.INSTANCE.commerceInventoryBookedQuantityId.eq((Expression)CommerceOrderItemTable.INSTANCE.bookedQuantityId)).innerJoinON((Table)GroupTable.INSTANCE, CommerceOrderItemTable.INSTANCE.groupId.eq((Expression)GroupTable.INSTANCE.groupId).and((Expression)GroupTable.INSTANCE.classNameId.eq((Object)this._portal.getClassNameId(CommerceChannel.class.getName())))).where(CommerceInventoryBookedQuantityTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceInventoryBookedQuantityTable.INSTANCE.sku.eq((Object)sku)).and((Expression)GroupTable.INSTANCE.groupId.eq((Object)commerceChannelGroupId))));
        if (result.get(0) == null) {
            return 0;
        }
        return (Integer)result.get(0);
    }

    public int getCommerceBookedQuantity(long companyId, String sku) {
        List result = (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.sum((Expression)CommerceInventoryBookedQuantityTable.INSTANCE.quantity).as("SUM_VALUE")}).from((Table)CommerceInventoryBookedQuantityTable.INSTANCE).where(CommerceInventoryBookedQuantityTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceInventoryBookedQuantityTable.INSTANCE.sku.eq((Object)sku))));
        if (result.get(0) == null) {
            return 0;
        }
        return (Integer)result.get(0);
    }

    public List<CommerceInventoryBookedQuantity> getCommerceInventoryBookedQuantities(long companyId, String sku, int start, int end) {
        return this.commerceInventoryBookedQuantityPersistence.findByC_S(companyId, sku, start, end);
    }

    public List<CommerceInventoryBookedQuantity> getCommerceInventoryBookedQuantities(long companyId, String keywords, String sku, int start, int end) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, keywords, sku, start, end);
        BaseModelSearchResult baseModelSearchResult = this.commerceInventoryBookedQuantityLocalService.searchCommerceInventoryBookedQuantities(searchContext);
        return baseModelSearchResult.getBaseModels();
    }

    public int getCommerceInventoryBookedQuantitiesCount(long companyId, String sku) {
        return this.commerceInventoryBookedQuantityPersistence.countByC_S(companyId, sku);
    }

    public int getCommerceInventoryBookedQuantitiesCount(long companyId, String keywords, String sku) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, keywords, sku, -1, -1);
        return this.commerceInventoryBookedQuantityLocalService.searchCommerceInventoryBookedQuantitiesCount(searchContext);
    }

    public CommerceInventoryBookedQuantity resetCommerceBookedQuantity(long commerceBookedQuantityId, long userId, Date expirationDate, int quantity, String sku, Map<String, String> context) throws PortalException {
        CommerceInventoryBookedQuantity commerceBookedQuantity = this.commerceInventoryBookedQuantityPersistence.fetchByPrimaryKey(commerceBookedQuantityId);
        if (commerceBookedQuantity == null) {
            User user = this._userLocalService.getUser(userId);
            commerceBookedQuantity = this.commerceInventoryBookedQuantityPersistence.create(commerceBookedQuantityId);
            commerceBookedQuantity.setCompanyId(user.getCompanyId());
            commerceBookedQuantity.setUserId(userId);
            commerceBookedQuantity.setUserName(user.getFullName());
            commerceBookedQuantity.setExpirationDate(expirationDate);
            commerceBookedQuantity.setSku(sku);
        } else {
            quantity = commerceBookedQuantity.getQuantity() + quantity;
            if (quantity < 0) {
                quantity = 0;
            }
        }
        commerceBookedQuantity.setQuantity(quantity);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("restore-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), BigDecimal.valueOf(quantity), sku, "");
        return (CommerceInventoryBookedQuantity)this.commerceInventoryBookedQuantityPersistence.update((BaseModel)commerceBookedQuantity);
    }

    public CommerceInventoryBookedQuantity restockCommerceInventoryBookedQuantity(long userId, long commerceInventoryBookedQuantityId, Map<String, String> context) throws PortalException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.commerceInventoryBookedQuantityPersistence.remove(commerceInventoryBookedQuantityId);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("restock-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), BigDecimal.valueOf(commerceInventoryBookedQuantity.getQuantity()), commerceInventoryBookedQuantity.getSku(), "");
        return commerceInventoryBookedQuantity;
    }

    public BaseModelSearchResult<CommerceInventoryBookedQuantity> searchCommerceInventoryBookedQuantities(SearchContext searchContext) throws PortalException {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(CommerceInventoryBookedQuantity.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<CommerceInventoryBookedQuantity> commerceInventoryBookedQuantities = this._getCommerceInventoryBookedQuantities(hits);
            if (commerceInventoryBookedQuantities == null) continue;
            return new BaseModelSearchResult(commerceInventoryBookedQuantities, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    public int searchCommerceInventoryBookedQuantitiesCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(CommerceInventoryBookedQuantity.class);
        return GetterUtil.getInteger((Object)indexer.searchCount(searchContext));
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceInventoryBookedQuantity updateCommerceInventoryBookedQuantity(long userId, long commerceInventoryBookedQuantityId, int quantity, Map<String, String> context, long mvccVersion) throws PortalException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.commerceInventoryBookedQuantityLocalService.getCommerceInventoryBookedQuantity(commerceInventoryBookedQuantityId);
        if (commerceInventoryBookedQuantity.getMvccVersion() != mvccVersion) {
            throw new MVCCException();
        }
        commerceInventoryBookedQuantity.setQuantity(quantity);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("update-booked-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), BigDecimal.valueOf(quantity), commerceInventoryBookedQuantity.getSku(), commerceInventoryBookedQuantity.getUnitOfMeasureKey());
        return this.commerceInventoryBookedQuantityLocalService.updateCommerceInventoryBookedQuantity(commerceInventoryBookedQuantity);
    }

    private SearchContext _buildSearchContext(long companyId, String keywords, String sku, int start, int end) {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setKeywords(keywords);
        if (Validator.isNotNull((String)sku)) {
            searchContext.setAttribute("sku", (Serializable)((Object)sku));
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private List<CommerceInventoryBookedQuantity> _getCommerceInventoryBookedQuantities(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceInventoryBookedQuantity> commerceInventoryBookedQuantities = new ArrayList<CommerceInventoryBookedQuantity>(documents.size());
        for (Document document : documents) {
            long commerceInventoryBookedQuantityId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchCommerceInventoryBookedQuantity(commerceInventoryBookedQuantityId);
            if (commerceInventoryBookedQuantity == null) {
                commerceInventoryBookedQuantities = null;
                Indexer indexer = this._indexerRegistry.getIndexer(CommerceInventoryBookedQuantity.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceInventoryBookedQuantities == null) continue;
            commerceInventoryBookedQuantities.add(commerceInventoryBookedQuantity);
        }
        return commerceInventoryBookedQuantities;
    }
}

