/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.exception.CommerceInventoryReplenishmentQuantityException;
import com.liferay.commerce.inventory.exception.CommerceInventoryReplenishmentSkuException;
import com.liferay.commerce.inventory.exception.DuplicateCommerceInventoryReplenishmentItemException;
import com.liferay.commerce.inventory.exception.MVCCException;
import com.liferay.commerce.inventory.model.CommerceInventoryReplenishmentItem;
import com.liferay.commerce.inventory.service.base.CommerceInventoryReplenishmentItemLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryReplenishmentItem"}, service={AopService.class})
public class CommerceInventoryReplenishmentItemLocalServiceImpl
extends CommerceInventoryReplenishmentItemLocalServiceBaseImpl {
    @Reference
    private UserLocalService _userLocalService;

    public CommerceInventoryReplenishmentItem addCommerceInventoryReplenishmentItem(String externalReferenceCode, long userId, long commerceInventoryWarehouseId, Date availabilityDate, BigDecimal quantity, String sku, String unitOfMeasureKey) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._validateExternalReferenceCode(0L, user.getCompanyId(), externalReferenceCode);
        this._validateQuantity(quantity);
        this._validateSku(sku);
        long commerceInventoryReplenishmentItemId = this.counterLocalService.increment();
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemPersistence.create(commerceInventoryReplenishmentItemId);
        commerceInventoryReplenishmentItem.setExternalReferenceCode(externalReferenceCode);
        commerceInventoryReplenishmentItem.setCompanyId(user.getCompanyId());
        commerceInventoryReplenishmentItem.setUserId(userId);
        commerceInventoryReplenishmentItem.setUserName(user.getFullName());
        commerceInventoryReplenishmentItem.setCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
        commerceInventoryReplenishmentItem.setAvailabilityDate(availabilityDate);
        commerceInventoryReplenishmentItem.setQuantity(quantity);
        commerceInventoryReplenishmentItem.setSku(sku);
        commerceInventoryReplenishmentItem.setUnitOfMeasureKey(unitOfMeasureKey);
        return (CommerceInventoryReplenishmentItem)this.commerceInventoryReplenishmentItemPersistence.update((BaseModel)commerceInventoryReplenishmentItem);
    }

    public void deleteCommerceInventoryReplenishmentItems(long commerceInventoryWarehouseId) {
        this.commerceInventoryReplenishmentItemPersistence.removeByCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
    }

    public void deleteCommerceInventoryReplenishmentItems(long companyId, String sku) {
        this.commerceInventoryReplenishmentItemPersistence.removeByC_S(companyId, sku);
    }

    public CommerceInventoryReplenishmentItem fetchCommerceInventoryReplenishmentItem(long companyId, String sku, OrderByComparator<CommerceInventoryReplenishmentItem> orderByComparator) {
        return this.commerceInventoryReplenishmentItemPersistence.fetchByC_S_First(companyId, sku, orderByComparator);
    }

    public List<CommerceInventoryReplenishmentItem> getCommerceInventoryReplenishmentItemsByCommerceInventoryWarehouseId(long commerceInventoryWarehouseId, int start, int end) {
        return this.commerceInventoryReplenishmentItemPersistence.findByCommerceInventoryWarehouseId(commerceInventoryWarehouseId, start, end);
    }

    public List<CommerceInventoryReplenishmentItem> getCommerceInventoryReplenishmentItemsByCompanyIdAndSku(long companyId, String sku, int start, int end) {
        return this.commerceInventoryReplenishmentItemPersistence.findByC_S(companyId, sku, start, end);
    }

    public BigDecimal getCommerceInventoryReplenishmentItemsCount(long commerceInventoryWarehouseId, String sku) {
        DynamicQuery dynamicQuery = this.commerceInventoryReplenishmentItemLocalService.dynamicQuery();
        dynamicQuery.setProjection(ProjectionFactoryUtil.sum((String)"quantity"));
        Property commerceInventoryWarehouseIdProperty = PropertyFactoryUtil.forName((String)"commerceInventoryWarehouseId");
        dynamicQuery.add(commerceInventoryWarehouseIdProperty.eq((Object)commerceInventoryWarehouseId));
        Property skuProperty = PropertyFactoryUtil.forName((String)"sku");
        dynamicQuery.add(skuProperty.eq((Object)sku));
        List results = this.commerceInventoryReplenishmentItemLocalService.dynamicQuery(dynamicQuery);
        if (results.get(0) == null) {
            return BigDecimal.ZERO;
        }
        return (BigDecimal)results.get(0);
    }

    public int getCommerceInventoryReplenishmentItemsCountByCommerceInventoryWarehouseId(long commerceInventoryWarehouseId) {
        return this.commerceInventoryReplenishmentItemPersistence.countByCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
    }

    public int getCommerceInventoryReplenishmentItemsCountByCompanyIdAndSku(long companyId, String sku) {
        return this.commerceInventoryReplenishmentItemPersistence.countByC_S(companyId, sku);
    }

    public CommerceInventoryReplenishmentItem updateCommerceInventoryReplenishmentItem(String externalReferenceCode, long commerceInventoryReplenishmentItemId, Date availabilityDate, BigDecimal quantity, long mvccVersion) throws PortalException {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemPersistence.findByPrimaryKey(commerceInventoryReplenishmentItemId);
        this._validateExternalReferenceCode(commerceInventoryReplenishmentItemId, commerceInventoryReplenishmentItem.getCompanyId(), externalReferenceCode);
        this._validateQuantity(quantity);
        if (commerceInventoryReplenishmentItem.getMvccVersion() != mvccVersion) {
            throw new MVCCException();
        }
        commerceInventoryReplenishmentItem.setExternalReferenceCode(externalReferenceCode);
        commerceInventoryReplenishmentItem.setAvailabilityDate(availabilityDate);
        commerceInventoryReplenishmentItem.setQuantity(quantity);
        return (CommerceInventoryReplenishmentItem)this.commerceInventoryReplenishmentItemPersistence.update((BaseModel)commerceInventoryReplenishmentItem);
    }

    private void _validateExternalReferenceCode(long commerceInventoryReplenishmentItemId, long companyId, String externalReferenceCode) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemPersistence.fetchByERC_C(externalReferenceCode, companyId);
        if (commerceInventoryReplenishmentItem == null) {
            return;
        }
        long oldCommerceInventoryReplenishmentItemId = commerceInventoryReplenishmentItem.getCommerceInventoryReplenishmentItemId();
        if (oldCommerceInventoryReplenishmentItemId != commerceInventoryReplenishmentItemId) {
            throw new DuplicateCommerceInventoryReplenishmentItemException("There is another commerce inventory replenishment item with external reference code " + externalReferenceCode);
        }
    }

    private void _validateQuantity(BigDecimal quantity) throws PortalException {
        if (quantity == null || quantity.compareTo(BigDecimal.ZERO) <= 0) {
            throw new CommerceInventoryReplenishmentQuantityException("Enter a quantity greater than or equal to 1");
        }
    }

    private void _validateSku(String sku) throws PortalException {
        if (Validator.isNull((String)sku)) {
            throw new CommerceInventoryReplenishmentSkuException("SKU code is null");
        }
    }
}

