/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.exception.CommerceInventoryWarehouseItemSkuException;
import com.liferay.commerce.inventory.exception.DuplicateCommerceInventoryWarehouseItemException;
import com.liferay.commerce.inventory.exception.MVCCException;
import com.liferay.commerce.inventory.model.CIWarehouseItem;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantityTable;
import com.liferay.commerce.inventory.model.CommerceInventoryReplenishmentItemTable;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItemTable;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseTable;
import com.liferay.commerce.inventory.service.CommerceInventoryAuditLocalService;
import com.liferay.commerce.inventory.service.base.CommerceInventoryWarehouseItemLocalServiceBaseImpl;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditType;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditTypeRegistry;
import com.liferay.commerce.product.exception.CPInstanceUnitOfMeasureKeyException;
import com.liferay.commerce.product.exception.NoSuchCPInstanceUnitOfMeasureException;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelRelTable;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.base.BaseTable;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.sql.dsl.spi.expression.Scalar;
import com.liferay.petra.sql.dsl.spi.query.QueryTable;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupTable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem"}, service={AopService.class})
public class CommerceInventoryWarehouseItemLocalServiceImpl
extends CommerceInventoryWarehouseItemLocalServiceBaseImpl {
    @Reference
    private CommerceInventoryAuditLocalService _commerceInventoryAuditLocalService;
    @Reference
    private CommerceInventoryAuditTypeRegistry _commerceInventoryAuditTypeRegistry;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private CPInstanceUnitOfMeasureLocalService _cpInstanceUnitOfMeasureLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceInventoryWarehouseItem addCommerceInventoryWarehouseItem(String externalReferenceCode, long userId, long commerceInventoryWarehouseId, BigDecimal quantity, String sku, String unitOfMeasureKey) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        this._validateSku(commerceInventoryWarehouseId, sku);
        this._validateUnitOfMeasureKey(user.getCompanyId(), sku, unitOfMeasureKey);
        long commerceInventoryWarehouseItemId = this.counterLocalService.increment();
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.create(commerceInventoryWarehouseItemId);
        commerceInventoryWarehouseItem.setExternalReferenceCode(externalReferenceCode);
        commerceInventoryWarehouseItem.setCompanyId(user.getCompanyId());
        commerceInventoryWarehouseItem.setUserId(user.getUserId());
        commerceInventoryWarehouseItem.setUserName(user.getFullName());
        commerceInventoryWarehouseItem.setCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
        commerceInventoryWarehouseItem.setQuantity(quantity);
        commerceInventoryWarehouseItem.setReservedQuantity(BigDecimal.ZERO);
        commerceInventoryWarehouseItem.setSku(sku);
        commerceInventoryWarehouseItem.setUnitOfMeasureKey(this._normalizeUnitOfMeasureKey(user.getCompanyId(), sku, unitOfMeasureKey));
        return (CommerceInventoryWarehouseItem)this.commerceInventoryWarehouseItemPersistence.update((BaseModel)commerceInventoryWarehouseItem);
    }

    public CommerceInventoryWarehouseItem addOrUpdateCommerceInventoryWarehouseItem(String externalReferenceCode, long companyId, long userId, long commerceInventoryWarehouseId, BigDecimal quantity, String sku, String unitOfMeasureKey) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = null;
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
            commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.fetchByC_S(commerceInventoryWarehouseId, sku);
        } else {
            commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.fetchByERC_C(externalReferenceCode, companyId);
        }
        if (commerceInventoryWarehouseItem != null) {
            return this.commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), commerceInventoryWarehouseItem.getMvccVersion(), quantity, unitOfMeasureKey);
        }
        return this.commerceInventoryWarehouseItemLocalService.addCommerceInventoryWarehouseItem(externalReferenceCode, userId, commerceInventoryWarehouseId, quantity, sku, unitOfMeasureKey);
    }

    public int countItemsByCompanyId(long companyId, String sku) {
        return this.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.sku).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and(() -> {
            if (Validator.isNull((String)sku)) {
                return null;
            }
            return DSLFunctionFactoryUtil.lower((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.sku).like("%" + StringUtil.toLowerCase((String)sku) + "%");
        })));
    }

    public void deleteCommerceInventoryWarehouseItems(long commerceInventoryWarehouseId) {
        this.commerceInventoryWarehouseItemPersistence.removeByCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
    }

    public void deleteCommerceInventoryWarehouseItems(long companyId, String sku) {
        this.commerceInventoryWarehouseItemPersistence.removeByCompanyId_Sku(companyId, sku);
    }

    public void deleteCommerceInventoryWarehouseItemsByCompanyId(long companyId) {
        this.commerceInventoryWarehouseItemPersistence.removeByCompanyId(companyId);
    }

    public CommerceInventoryWarehouseItem fetchCommerceInventoryWarehouseItem(long commerceInventoryWarehouseId, String sku) {
        return this.commerceInventoryWarehouseItemPersistence.fetchByC_S(commerceInventoryWarehouseId, sku);
    }

    public CommerceInventoryWarehouseItem getCommerceInventoryWarehouseItem(long commerceInventoryWarehouseId, String sku) throws PortalException {
        return this.commerceInventoryWarehouseItemPersistence.findByC_S(commerceInventoryWarehouseId, sku);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItems(long commerceInventoryWarehouseId, int start, int end) {
        return this.commerceInventoryWarehouseItemPersistence.findByCommerceInventoryWarehouseId(commerceInventoryWarehouseId, start, end);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsByCompanyId(long companyId, int start, int end) {
        return this.commerceInventoryWarehouseItemPersistence.findByCompanyId(companyId, start, end);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsByCompanyIdAndSku(long companyId, String sku, int start, int end) {
        return this.commerceInventoryWarehouseItemPersistence.findByCompanyId_Sku(companyId, sku, start, end);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsByModifiedDate(long companyId, Date startDate, Date endDate, int start, int end) {
        return (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)CommerceInventoryWarehouseItemTable.INSTANCE).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.modifiedDate.gte((Object)startDate)).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.modifiedDate.lt((Object)endDate))).orderBy(new OrderByExpression[]{CommerceInventoryWarehouseItemTable.INSTANCE.sku.ascending(), CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey.ascending()}));
    }

    public int getCommerceInventoryWarehouseItemsCount(long commerceInventoryWarehouseId) {
        return this.commerceInventoryWarehouseItemPersistence.countByCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
    }

    public int getCommerceInventoryWarehouseItemsCount(long companyId, long groupId, String sku) {
        return this.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseItemId).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).innerJoinON((Table)CommerceChannelRelTable.INSTANCE, CommerceChannelRelTable.INSTANCE.classNameId.eq((Object)this._portal.getClassNameId(CommerceInventoryWarehouse.class.getName())).and((Expression)CommerceChannelRelTable.INSTANCE.classPK.eq((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId))).innerJoinON((Table)GroupTable.INSTANCE, GroupTable.INSTANCE.classNameId.eq((Object)this._portal.getClassNameId(CommerceChannel.class.getName())).and((Expression)GroupTable.INSTANCE.classPK.eq((Expression)CommerceChannelRelTable.INSTANCE.commerceChannelId))).innerJoinON((Table)CommerceInventoryWarehouseTable.INSTANCE, CommerceInventoryWarehouseTable.INSTANCE.commerceInventoryWarehouseId.eq((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId)).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.sku.eq((Object)sku)).and((Expression)CommerceInventoryWarehouseTable.INSTANCE.active.eq((Object)true)).and((Expression)GroupTable.INSTANCE.groupId.eq((Object)groupId))));
    }

    public int getCommerceInventoryWarehouseItemsCount(long companyId, String sku) {
        return this.commerceInventoryWarehouseItemPersistence.countByCompanyId_Sku(companyId, sku);
    }

    public int getCommerceInventoryWarehouseItemsCountByCompanyId(long companyId) {
        return this.commerceInventoryWarehouseItemPersistence.countByCompanyId(companyId);
    }

    public int getCommerceInventoryWarehouseItemsCountByModifiedDate(long companyId, Date startDate, Date endDate) {
        return this.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseItemId).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.modifiedDate.gte((Object)startDate).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.modifiedDate.lt((Object)endDate)))));
    }

    public List<CIWarehouseItem> getItemsByCompanyId(long companyId, String sku, int start, int end) {
        List sumStocks = (List)this.dslQuery(DSLQueryFactoryUtil.select((Expression[])new Expression[]{CommerceInventoryWarehouseItemTable.INSTANCE.sku, DSLFunctionFactoryUtil.sum((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.quantity).as("SUM_STOCK"), DSLFunctionFactoryUtil.min(BookedQuantityTable.INSTANCE.sumBookedColumn).as(BookedQuantityTable.INSTANCE.sumBookedColumn.getName()), DSLFunctionFactoryUtil.min(ReplenishmentQuantityTable.INSTANCE.sumAwaitingColumn).as(ReplenishmentQuantityTable.INSTANCE.sumAwaitingColumn.getName())}).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).leftJoinOn((Table)BookedQuantityTable.INSTANCE.getQueryTable(companyId), CommerceInventoryWarehouseItemTable.INSTANCE.sku.eq(BookedQuantityTable.INSTANCE.skuColumn)).leftJoinOn((Table)ReplenishmentQuantityTable.INSTANCE.getQueryTable(companyId), CommerceInventoryWarehouseItemTable.INSTANCE.sku.eq(ReplenishmentQuantityTable.INSTANCE.skuColumn)).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and(() -> {
            if (Validator.isNull((String)sku)) {
                return null;
            }
            return DSLFunctionFactoryUtil.lower((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.sku).like("%" + StringUtil.toLowerCase((String)sku) + "%");
        })).groupBy(new Expression[]{CommerceInventoryWarehouseItemTable.INSTANCE.sku, CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey}).orderBy(new OrderByExpression[]{CommerceInventoryWarehouseItemTable.INSTANCE.sku.ascending(), CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey.ascending()}).limit(start, end));
        ArrayList<CIWarehouseItem> ciWarehouseItems = new ArrayList<CIWarehouseItem>();
        for (Object[] stock : sumStocks) {
            if (stock == null) continue;
            String skuCode = "";
            if (stock.length > 0 && stock[0] != null) {
                skuCode = (String)stock[0];
            }
            BigDecimal stockQuantity = BigDecimal.ZERO;
            if (stock.length > 1 && stock[1] != null) {
                stockQuantity = (BigDecimal)stock[1];
            }
            Integer bookedQuantity = 0;
            if (stock.length > 2 && stock[2] != null) {
                bookedQuantity = (Integer)stock[2];
            }
            Integer replenishmentQuantity = 0;
            if (stock.length > 3 && stock[3] != null) {
                replenishmentQuantity = (Integer)stock[3];
            }
            ciWarehouseItems.add(new CIWarehouseItem(skuCode, stockQuantity.intValue(), bookedQuantity.intValue(), replenishmentQuantity.intValue()));
        }
        return ciWarehouseItems;
    }

    public BigDecimal getStockQuantity(long companyId, long groupId, String sku) {
        Iterable iterable = (Iterable)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.sum((Expression)DSLFunctionFactoryUtil.subtract(this._getExpression(CommerceInventoryWarehouseItemTable.INSTANCE.quantity), this._getExpression(CommerceInventoryWarehouseItemTable.INSTANCE.reservedQuantity))).as("SUM_VALUE")}).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).innerJoinON((Table)CommerceChannelRelTable.INSTANCE, CommerceChannelRelTable.INSTANCE.classNameId.eq((Object)this._portal.getClassNameId(CommerceInventoryWarehouse.class.getName())).and((Expression)CommerceChannelRelTable.INSTANCE.classPK.eq((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId))).innerJoinON((Table)GroupTable.INSTANCE, GroupTable.INSTANCE.classNameId.eq((Object)this._portal.getClassNameId(CommerceChannel.class.getName())).and((Expression)GroupTable.INSTANCE.classPK.eq((Expression)CommerceChannelRelTable.INSTANCE.commerceChannelId))).innerJoinON((Table)CommerceInventoryWarehouseTable.INSTANCE, CommerceInventoryWarehouseTable.INSTANCE.commerceInventoryWarehouseId.eq((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId)).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.sku.eq((Object)sku)).and((Expression)CommerceInventoryWarehouseTable.INSTANCE.active.eq((Object)true)).and((Expression)GroupTable.INSTANCE.groupId.eq((Object)groupId))));
        Iterator iterator = iterable.iterator();
        BigDecimal stockQuantity = (BigDecimal)iterator.next();
        if (stockQuantity == null) {
            return BigDecimal.ZERO;
        }
        return stockQuantity;
    }

    public BigDecimal getStockQuantity(long companyId, String sku) {
        Iterable iterable = (Iterable)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.sum((Expression)DSLFunctionFactoryUtil.subtract(this._getExpression(CommerceInventoryWarehouseItemTable.INSTANCE.quantity), this._getExpression(CommerceInventoryWarehouseItemTable.INSTANCE.reservedQuantity))).as("SUM_VALUE")}).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).innerJoinON((Table)CommerceInventoryWarehouseTable.INSTANCE, CommerceInventoryWarehouseTable.INSTANCE.commerceInventoryWarehouseId.eq((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId)).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.sku.eq((Object)sku)).and((Expression)CommerceInventoryWarehouseTable.INSTANCE.active.eq((Object)true))));
        Iterator iterator = iterable.iterator();
        BigDecimal stockQuantity = (BigDecimal)iterator.next();
        if (stockQuantity == null) {
            return BigDecimal.ZERO;
        }
        return stockQuantity;
    }

    public CommerceInventoryWarehouseItem increaseCommerceInventoryWarehouseItemQuantity(long userId, long commerceInventoryWarehouseItemId, BigDecimal quantity) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByPrimaryKey(commerceInventoryWarehouseItemId);
        quantity = quantity.add(commerceInventoryWarehouseItem.getQuantity());
        commerceInventoryWarehouseItem.setQuantity(quantity);
        commerceInventoryWarehouseItem = (CommerceInventoryWarehouseItem)this.commerceInventoryWarehouseItemPersistence.update((BaseModel)commerceInventoryWarehouseItem);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("increase-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(null), quantity, commerceInventoryWarehouseItem.getSku(), commerceInventoryWarehouseItem.getUnitOfMeasureKey());
        return commerceInventoryWarehouseItem;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public void moveQuantitiesBetweenWarehouses(long userId, long fromCommerceInventoryWarehouseId, long toCommerceInventoryWarehouseId, BigDecimal quantity, String sku) throws PortalException {
        CommerceInventoryWarehouseItem fromWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByC_S(fromCommerceInventoryWarehouseId, sku);
        BigDecimal fromWarehouseItemQuantity = fromWarehouseItem.getQuantity();
        if (quantity.compareTo(fromWarehouseItemQuantity) == 1) {
            throw new PortalException("Quantity to transfer unavailable");
        }
        this.commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, fromWarehouseItem.getCommerceInventoryWarehouseItemId(), fromWarehouseItem.getMvccVersion(), fromWarehouseItemQuantity.subtract(quantity), fromWarehouseItem.getUnitOfMeasureKey());
        CommerceInventoryWarehouseItem toWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByC_S(toCommerceInventoryWarehouseId, sku);
        BigDecimal toWarehouseItemQuantity = toWarehouseItem.getQuantity();
        this.commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, toWarehouseItem.getCommerceInventoryWarehouseItemId(), toWarehouseItem.getMvccVersion(), toWarehouseItemQuantity.add(quantity), toWarehouseItem.getUnitOfMeasureKey());
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("move-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog((Map)HashMapBuilder.put((Object)"from", () -> {
            CommerceInventoryWarehouse fromCommerceInventoryWarehouse = fromWarehouseItem.getCommerceInventoryWarehouse();
            return String.valueOf(fromCommerceInventoryWarehouse.getName());
        }).put((Object)"to", () -> {
            CommerceInventoryWarehouse toCommerceInventoryWarehouse = toWarehouseItem.getCommerceInventoryWarehouse();
            return String.valueOf(toCommerceInventoryWarehouse.getName());
        }).build()), quantity, sku, "");
    }

    public CommerceInventoryWarehouseItem updateCommerceInventoryWarehouseItem(long userId, long commerceInventoryWarehouseItemId, BigDecimal quantity, BigDecimal reservedQuantity, long mvccVersion) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByPrimaryKey(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem.getMvccVersion() != mvccVersion) {
            throw new MVCCException();
        }
        commerceInventoryWarehouseItem.setQuantity(quantity);
        commerceInventoryWarehouseItem.setReservedQuantity(reservedQuantity);
        commerceInventoryWarehouseItem = (CommerceInventoryWarehouseItem)this.commerceInventoryWarehouseItemPersistence.update((BaseModel)commerceInventoryWarehouseItem);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("update-warehouse-item");
        CommerceInventoryWarehouse commerceInventoryWarehouse = commerceInventoryWarehouseItem.getCommerceInventoryWarehouse();
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog((Map)HashMapBuilder.put((Object)"reserved", (Object)String.valueOf(reservedQuantity)).put((Object)"warehouse", (Object)String.valueOf(commerceInventoryWarehouse.getName())).build()), quantity, commerceInventoryWarehouseItem.getSku(), commerceInventoryWarehouseItem.getUnitOfMeasureKey());
        return commerceInventoryWarehouseItem;
    }

    public CommerceInventoryWarehouseItem updateCommerceInventoryWarehouseItem(long userId, long commerceInventoryWarehouseItemId, long mvccVersion, BigDecimal quantity, String unitOfMeasureKey) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByPrimaryKey(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem.getMvccVersion() != mvccVersion) {
            throw new MVCCException();
        }
        this._validateUnitOfMeasureKey(commerceInventoryWarehouseItem.getCompanyId(), commerceInventoryWarehouseItem.getSku(), unitOfMeasureKey);
        commerceInventoryWarehouseItem.setQuantity(quantity);
        commerceInventoryWarehouseItem.setUnitOfMeasureKey(this._normalizeUnitOfMeasureKey(commerceInventoryWarehouseItem.getCompanyId(), commerceInventoryWarehouseItem.getSku(), unitOfMeasureKey));
        commerceInventoryWarehouseItem = (CommerceInventoryWarehouseItem)this.commerceInventoryWarehouseItemPersistence.update((BaseModel)commerceInventoryWarehouseItem);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("update-warehouse-item");
        CommerceInventoryWarehouse commerceInventoryWarehouse = commerceInventoryWarehouseItem.getCommerceInventoryWarehouse();
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog((Map)HashMapBuilder.put((Object)"warehouse", (Object)String.valueOf(commerceInventoryWarehouse.getName())).build()), quantity, commerceInventoryWarehouseItem.getSku(), commerceInventoryWarehouseItem.getUnitOfMeasureKey());
        return commerceInventoryWarehouseItem;
    }

    private BigDecimal _getBigDecimal(Comparable<?> comparable) {
        if (comparable == null) {
            return BigDecimal.ZERO;
        }
        if (comparable instanceof BigDecimal) {
            return (BigDecimal)comparable;
        }
        String value = comparable.toString();
        if (Validator.isNull((String)value)) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(value);
    }

    private Expression<?> _getExpression(Object object) {
        if (object instanceof BigDecimal) {
            object = this._getBigDecimal((Comparable)object);
        } else if (object instanceof Expression) {
            return (Expression)object;
        }
        return new Scalar(object);
    }

    private String _normalizeUnitOfMeasureKey(long companyId, String sku, String unitOfMeasureKey) throws PortalException {
        List cpInstanceUnitOfMeasures = this._cpInstanceUnitOfMeasureLocalService.getCPInstanceUnitOfMeasures(companyId, sku);
        if (Validator.isNull((String)unitOfMeasureKey) && cpInstanceUnitOfMeasures.size() == 1) {
            CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure = (CPInstanceUnitOfMeasure)cpInstanceUnitOfMeasures.get(0);
            return cpInstanceUnitOfMeasure.getKey();
        }
        return unitOfMeasureKey;
    }

    private void _validateSku(long commerceInventoryWarehouseId, String sku) throws PortalException {
        if (Validator.isNull((String)sku)) {
            throw new CommerceInventoryWarehouseItemSkuException();
        }
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.fetchByC_S(commerceInventoryWarehouseId, sku);
        if (commerceInventoryWarehouseItem != null) {
            throw new DuplicateCommerceInventoryWarehouseItemException();
        }
    }

    private void _validateUnitOfMeasureKey(long companyId, String sku, String unitOfMeasureKey) throws PortalException {
        int cpInstanceUnitOfMeasuresCount = this._cpInstanceUnitOfMeasureLocalService.getCPInstanceUnitOfMeasuresCount(companyId, sku);
        if (Validator.isNull((String)unitOfMeasureKey)) {
            if (cpInstanceUnitOfMeasuresCount == 1) {
                return;
            }
            if (cpInstanceUnitOfMeasuresCount > 0) {
                throw new CPInstanceUnitOfMeasureKeyException();
            }
        } else {
            if (cpInstanceUnitOfMeasuresCount == 0) {
                List cpInstances = this._cpInstanceLocalService.getCPInstances(companyId, sku);
                if (cpInstances.isEmpty()) {
                    return;
                }
                throw new NoSuchCPInstanceUnitOfMeasureException();
            }
            List cpInstanceUnitOfMeasures = this._cpInstanceUnitOfMeasureLocalService.getCPInstanceUnitOfMeasures(companyId, sku);
            for (CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure : cpInstanceUnitOfMeasures) {
                if (!unitOfMeasureKey.equals(cpInstanceUnitOfMeasure.getKey())) continue;
                return;
            }
            throw new NoSuchCPInstanceUnitOfMeasureException();
        }
    }

    private static class ReplenishmentQuantityTable
    extends BaseTable<ReplenishmentQuantityTable> {
        public static final ReplenishmentQuantityTable INSTANCE = new ReplenishmentQuantityTable();
        public final Column<ReplenishmentQuantityTable, String> skuColumn = this.createColumn("SKU", String.class, 12, 0);
        public final Column<ReplenishmentQuantityTable, Integer> sumAwaitingColumn = this.createColumn("SUM_AWAITING", Integer.class, 4, 0);

        public QueryTable getQueryTable(long companyId) {
            return new QueryTable(INSTANCE.getTableName(), (DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{CommerceInventoryReplenishmentItemTable.INSTANCE.sku.as(this.skuColumn.getName()), DSLFunctionFactoryUtil.sum((Expression)CommerceInventoryReplenishmentItemTable.INSTANCE.quantity).as(this.sumAwaitingColumn.getName())}).from((Table)CommerceInventoryReplenishmentItemTable.INSTANCE).where(CommerceInventoryReplenishmentItemTable.INSTANCE.companyId.eq((Object)companyId)).groupBy(new Expression[]{CommerceInventoryReplenishmentItemTable.INSTANCE.sku, CommerceInventoryReplenishmentItemTable.INSTANCE.unitOfMeasureKey}), Arrays.asList(this.skuColumn, this.sumAwaitingColumn));
        }

        private ReplenishmentQuantityTable() {
            super("ReplenishmentQuantityTable", ReplenishmentQuantityTable::new);
        }
    }

    private static class BookedQuantityTable
    extends BaseTable<BookedQuantityTable> {
        public static final BookedQuantityTable INSTANCE = new BookedQuantityTable();
        public final Column<BookedQuantityTable, String> skuColumn = this.createColumn("SKU", String.class, 12, 0);
        public final Column<BookedQuantityTable, Integer> sumBookedColumn = this.createColumn("SUM_BOOKED", Integer.class, 4, 0);

        public QueryTable getQueryTable(long companyId) {
            return new QueryTable(INSTANCE.getTableName(), (DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{CommerceInventoryBookedQuantityTable.INSTANCE.sku.as(this.skuColumn.getName()), DSLFunctionFactoryUtil.sum((Expression)CommerceInventoryBookedQuantityTable.INSTANCE.quantity).as(this.sumBookedColumn.getName())}).from((Table)CommerceInventoryBookedQuantityTable.INSTANCE).where(CommerceInventoryBookedQuantityTable.INSTANCE.companyId.eq((Object)companyId)).groupBy(new Expression[]{CommerceInventoryBookedQuantityTable.INSTANCE.sku, CommerceInventoryBookedQuantityTable.INSTANCE.unitOfMeasureKey}), Arrays.asList(this.skuColumn, this.sumBookedColumn));
        }

        private BookedQuantityTable() {
            super("BookedQuantityTable", BookedQuantityTable::new);
        }
    }
}

