/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.exception.CommerceInventoryWarehouseActiveException;
import com.liferay.commerce.inventory.exception.CommerceInventoryWarehouseNameException;
import com.liferay.commerce.inventory.exception.DuplicateCommerceInventoryWarehouseException;
import com.liferay.commerce.inventory.exception.MVCCException;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItemTable;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseTable;
import com.liferay.commerce.inventory.service.CommerceInventoryReplenishmentItemLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalService;
import com.liferay.commerce.inventory.service.base.CommerceInventoryWarehouseLocalServiceBaseImpl;
import com.liferay.commerce.product.model.CommerceChannelRelTable;
import com.liferay.commerce.product.model.CommerceChannelTable;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupTable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryWarehouse"}, service={AopService.class})
public class CommerceInventoryWarehouseLocalServiceImpl
extends CommerceInventoryWarehouseLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId"};
    @Reference
    private CommerceInventoryReplenishmentItemLocalService _commerceInventoryReplenishmentItemLocalService;
    @Reference
    private CommerceInventoryWarehouseItemLocalService _commerceInventoryWarehouseItemLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceInventoryWarehouse addCommerceInventoryWarehouse(String externalReferenceCode, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String street1, String street2, String street3, String city, String zip, String commerceRegionCode, String commerceCountryCode, double latitude, double longitude, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        this._validateExternalReferenceCode(0L, user.getCompanyId(), externalReferenceCode);
        this._validateNameMap(nameMap);
        this._validateActive(active, latitude, longitude);
        CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehousePersistence.create(this.counterLocalService.increment());
        commerceInventoryWarehouse.setExternalReferenceCode(externalReferenceCode);
        commerceInventoryWarehouse.setCompanyId(user.getCompanyId());
        commerceInventoryWarehouse.setUserId(user.getUserId());
        commerceInventoryWarehouse.setUserName(user.getFullName());
        commerceInventoryWarehouse.setNameMap(nameMap);
        commerceInventoryWarehouse.setDescriptionMap(descriptionMap);
        commerceInventoryWarehouse.setActive(active);
        commerceInventoryWarehouse.setStreet1(street1);
        commerceInventoryWarehouse.setStreet2(street2);
        commerceInventoryWarehouse.setStreet3(street3);
        commerceInventoryWarehouse.setCity(city);
        commerceInventoryWarehouse.setZip(zip);
        commerceInventoryWarehouse.setCommerceRegionCode(commerceRegionCode);
        commerceInventoryWarehouse.setCountryTwoLettersISOCode(commerceCountryCode);
        commerceInventoryWarehouse.setLatitude(latitude);
        commerceInventoryWarehouse.setLongitude(longitude);
        commerceInventoryWarehouse.setExpandoBridgeAttributes(serviceContext);
        commerceInventoryWarehouse = (CommerceInventoryWarehouse)this.commerceInventoryWarehousePersistence.update((BaseModel)commerceInventoryWarehouse);
        Company company = this._companyLocalService.getCompany(user.getCompanyId());
        this._resourceLocalService.addResources(user.getCompanyId(), company.getGroupId(), user.getUserId(), CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), false, true, true);
        return commerceInventoryWarehouse;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceInventoryWarehouse deleteCommerceInventoryWarehouse(CommerceInventoryWarehouse commerceInventoryWarehouse) throws PortalException {
        commerceInventoryWarehouse = (CommerceInventoryWarehouse)this.commerceInventoryWarehousePersistence.remove((BaseModel)commerceInventoryWarehouse);
        this._commerceInventoryWarehouseItemLocalService.deleteCommerceInventoryWarehouseItems(commerceInventoryWarehouse.getCommerceInventoryWarehouseId());
        this._commerceInventoryReplenishmentItemLocalService.deleteCommerceInventoryReplenishmentItems(commerceInventoryWarehouse.getCommerceInventoryWarehouseId());
        this._expandoRowLocalService.deleteRows(commerceInventoryWarehouse.getCommerceInventoryWarehouseId());
        this._resourceLocalService.deleteResource((AuditedModel)commerceInventoryWarehouse, 4);
        return commerceInventoryWarehouse;
    }

    @Override
    public CommerceInventoryWarehouse deleteCommerceInventoryWarehouse(long commerceInventoryWarehouseId) throws PortalException {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehousePersistence.findByPrimaryKey(commerceInventoryWarehouseId);
        return this.commerceInventoryWarehouseLocalService.deleteCommerceInventoryWarehouse(commerceInventoryWarehouse);
    }

    public CommerceInventoryWarehouse fetchCommerceInventoryWarehouseByReferenceCode(String externalReferenceCode, long companyId) {
        return this.commerceInventoryWarehousePersistence.fetchByERC_C(externalReferenceCode, companyId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceInventoryWarehouse geolocateCommerceInventoryWarehouse(long commerceInventoryWarehouseId, double latitude, double longitude) throws PortalException {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehousePersistence.findByPrimaryKey(commerceInventoryWarehouseId);
        commerceInventoryWarehouse.setLatitude(latitude);
        commerceInventoryWarehouse.setLongitude(longitude);
        return (CommerceInventoryWarehouse)this.commerceInventoryWarehousePersistence.update((BaseModel)commerceInventoryWarehouse);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long companyId) {
        return this.commerceInventoryWarehousePersistence.findByCompanyId(companyId);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long companyId, boolean active, int start, int end, OrderByComparator<CommerceInventoryWarehouse> orderByComparator) {
        return this.commerceInventoryWarehousePersistence.findByC_A(companyId, active, start, end, orderByComparator);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long companyId, boolean active, String commerceCountryCode, int start, int end, OrderByComparator<CommerceInventoryWarehouse> orderByComparator) {
        return this.commerceInventoryWarehousePersistence.findByC_A_C(companyId, active, commerceCountryCode, start, end, orderByComparator);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long companyId, int start, int end, OrderByComparator<CommerceInventoryWarehouse> orderByComparator) {
        return this.commerceInventoryWarehousePersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long companyId, long groupId, boolean active) {
        return (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)CommerceInventoryWarehouseTable.INSTANCE).from((Table)CommerceInventoryWarehouseTable.INSTANCE).innerJoinON((Table)CommerceChannelRelTable.INSTANCE, CommerceInventoryWarehouseTable.INSTANCE.commerceInventoryWarehouseId.eq((Expression)CommerceChannelRelTable.INSTANCE.classPK)).innerJoinON((Table)CommerceChannelTable.INSTANCE, CommerceChannelRelTable.INSTANCE.commerceChannelId.eq((Expression)CommerceChannelTable.INSTANCE.commerceChannelId)).innerJoinON((Table)GroupTable.INSTANCE, CommerceChannelTable.INSTANCE.commerceChannelId.eq((Expression)GroupTable.INSTANCE.classPK)).where(CommerceInventoryWarehouseTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)GroupTable.INSTANCE.groupId.eq((Object)groupId)).and((Expression)CommerceInventoryWarehouseTable.INSTANCE.active.eq((Object)active))));
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long groupId, String sku) {
        return (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)CommerceInventoryWarehouseTable.INSTANCE).from((Table)CommerceInventoryWarehouseTable.INSTANCE).innerJoinON((Table)CommerceChannelRelTable.INSTANCE, CommerceInventoryWarehouseTable.INSTANCE.commerceInventoryWarehouseId.eq((Expression)CommerceChannelRelTable.INSTANCE.classPK)).innerJoinON((Table)CommerceChannelTable.INSTANCE, CommerceChannelRelTable.INSTANCE.commerceChannelId.eq((Expression)CommerceChannelTable.INSTANCE.commerceChannelId)).innerJoinON((Table)GroupTable.INSTANCE, CommerceChannelTable.INSTANCE.commerceChannelId.eq((Expression)GroupTable.INSTANCE.classPK)).innerJoinON((Table)CommerceInventoryWarehouseItemTable.INSTANCE, CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId.eq((Expression)CommerceInventoryWarehouseTable.INSTANCE.commerceInventoryWarehouseId)).where(GroupTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.sku.eq((Object)sku)).and((Expression)CommerceInventoryWarehouseTable.INSTANCE.active.eq((Object)true))));
    }

    public int getCommerceInventoryWarehousesCount(long companyId) {
        return this.commerceInventoryWarehousePersistence.countByCompanyId(companyId);
    }

    public int getCommerceInventoryWarehousesCount(long companyId, boolean active) {
        return this.commerceInventoryWarehousePersistence.countByC_A(companyId, active);
    }

    public int getCommerceInventoryWarehousesCount(long companyId, boolean active, String commerceCountryCode) {
        if (Validator.isNotNull((String)commerceCountryCode)) {
            return this.commerceInventoryWarehousePersistence.countByC_A_C(companyId, active, commerceCountryCode);
        }
        return this.commerceInventoryWarehouseLocalService.getCommerceInventoryWarehousesCount(companyId, active);
    }

    public List<CommerceInventoryWarehouse> search(long companyId, Boolean active, String commerceCountryCode, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, active, commerceCountryCode, keywords, start, end, sort);
        searchContext.setKeywords(keywords);
        return this._search(searchContext);
    }

    public int searchCommerceInventoryWarehousesCount(long companyId, Boolean active, String commerceCountryCode, String keywords) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, active, commerceCountryCode, keywords, -1, -1, null);
        searchContext.setKeywords(keywords);
        return this._searchCommerceInventoryWarehousesCount(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceInventoryWarehouse setActive(long commerceInventoryWarehouseId, boolean active) throws PortalException {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehousePersistence.findByPrimaryKey(commerceInventoryWarehouseId);
        this._validateActive(active, commerceInventoryWarehouse.getLatitude(), commerceInventoryWarehouse.getLongitude());
        commerceInventoryWarehouse.setActive(active);
        return (CommerceInventoryWarehouse)this.commerceInventoryWarehousePersistence.update((BaseModel)commerceInventoryWarehouse);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceInventoryWarehouse updateCommerceInventoryWarehouse(long commerceInventoryWarehouseId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String street1, String street2, String street3, String city, String zip, String commerceRegionCode, String commerceCountryCode, double latitude, double longitude, long mvccVersion, ServiceContext serviceContext) throws PortalException {
        this._validateNameMap(nameMap);
        this._validateActive(active, latitude, longitude);
        CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehousePersistence.findByPrimaryKey(commerceInventoryWarehouseId);
        if (commerceInventoryWarehouse.getMvccVersion() != mvccVersion) {
            throw new MVCCException();
        }
        commerceInventoryWarehouse.setNameMap(nameMap);
        commerceInventoryWarehouse.setDescriptionMap(descriptionMap);
        commerceInventoryWarehouse.setActive(active);
        commerceInventoryWarehouse.setStreet1(street1);
        commerceInventoryWarehouse.setStreet2(street2);
        commerceInventoryWarehouse.setStreet3(street3);
        commerceInventoryWarehouse.setCity(city);
        commerceInventoryWarehouse.setZip(zip);
        commerceInventoryWarehouse.setCommerceRegionCode(commerceRegionCode);
        commerceInventoryWarehouse.setCountryTwoLettersISOCode(commerceCountryCode);
        commerceInventoryWarehouse.setLatitude(latitude);
        commerceInventoryWarehouse.setLongitude(longitude);
        commerceInventoryWarehouse.setExpandoBridgeAttributes(serviceContext);
        return (CommerceInventoryWarehouse)this.commerceInventoryWarehousePersistence.update((BaseModel)commerceInventoryWarehouse);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceInventoryWarehouse updateCommerceInventoryWarehouseExternalReferenceCode(String externalReferenceCode, long commerceInventoryWarehouseId) throws PortalException {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehousePersistence.findByPrimaryKey(commerceInventoryWarehouseId);
        commerceInventoryWarehouse.setExternalReferenceCode(externalReferenceCode);
        return (CommerceInventoryWarehouse)this.commerceInventoryWarehousePersistence.update((BaseModel)commerceInventoryWarehouse);
    }

    private SearchContext _buildSearchContext(long companyId, Boolean active, String commerceCountryCode, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"active", () -> active).put((Object)"city", (Object)keywords).put((Object)"countryTwoLettersISOCode", () -> {
            if (Validator.isNotNull((String)commerceCountryCode)) {
                return commerceCountryCode;
            }
            return null;
        }).put((Object)"street1", (Object)keywords).put((Object)"zip", (Object)keywords).put((Object)"description", (Object)keywords).put((Object)"entryClassPK", (Object)keywords).put((Object)"name", (Object)keywords).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        } else {
            searchContext.setSorts(SortFactoryUtil.getDefaultSorts());
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private List<CommerceInventoryWarehouse> _getCommerceInventoryWarehouses(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceInventoryWarehouse> commerceInventoryWarehouses = new ArrayList<CommerceInventoryWarehouse>(documents.size());
        for (Document document : documents) {
            long commerceInventoryWarehouseId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehouseLocalService.fetchCommerceInventoryWarehouse(commerceInventoryWarehouseId);
            if (commerceInventoryWarehouse == null) {
                commerceInventoryWarehouses = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceInventoryWarehouse.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceInventoryWarehouses == null) continue;
            commerceInventoryWarehouses.add(commerceInventoryWarehouse);
        }
        return commerceInventoryWarehouses;
    }

    private List<CommerceInventoryWarehouse> _search(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceInventoryWarehouse.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceInventoryWarehouse> commerceInventoryWarehouses = this._getCommerceInventoryWarehouses(hits);
            if (commerceInventoryWarehouses == null) continue;
            return commerceInventoryWarehouses;
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    private int _searchCommerceInventoryWarehousesCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceInventoryWarehouse.class);
        return GetterUtil.getInteger((Object)indexer.searchCount(searchContext));
    }

    private void _validateActive(boolean active, double latitude, double longitude) throws PortalException {
        if (active && latitude == 0.0 && longitude == 0.0) {
            throw new CommerceInventoryWarehouseActiveException();
        }
    }

    private void _validateExternalReferenceCode(long commerceInventoryWarehouseId, long companyId, String externalReferenceCode) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehousePersistence.fetchByERC_C(externalReferenceCode, companyId);
        if (commerceInventoryWarehouse == null) {
            return;
        }
        if (commerceInventoryWarehouse.getCommerceInventoryWarehouseId() != commerceInventoryWarehouseId) {
            throw new DuplicateCommerceInventoryWarehouseException("There is another commerce inventory with external reference code " + externalReferenceCode);
        }
    }

    private void _validateNameMap(Map<Locale, String> nameMap) throws PortalException {
        if (nameMap == null || nameMap.isEmpty()) {
            throw new CommerceInventoryWarehouseNameException();
        }
    }
}

