/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.engine;

import com.liferay.commerce.inventory.configuration.CommerceInventoryGroupConfiguration;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.inventory.method.CommerceInventoryMethod;
import com.liferay.commerce.inventory.method.CommerceInventoryMethodRegistry;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import java.math.BigDecimal;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceInventoryEngine.class})
public class CommerceInventoryEngineImpl
implements CommerceInventoryEngine {
    private static final Log _log = LogFactoryUtil.getLog(CommerceInventoryEngineImpl.class);
    @Reference
    private CommerceInventoryMethodRegistry _commerceInventoryMethodRegistry;
    @Reference
    private ConfigurationProvider _configurationProvider;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void consumeQuantity(long userId, long commerceInventoryBookedQuantityId, long commerceCatalogGroupId, long commerceInventoryWarehouseId, BigDecimal quantity, String sku, String unitOfMeasureKey, Map<String, String> context) throws PortalException {
        CommerceInventoryMethod commerceInventoryMethod = this._getCommerceInventoryMethod(commerceCatalogGroupId);
        if (commerceInventoryMethod == null) {
            return;
        }
        commerceInventoryMethod.consumeQuantity(userId, commerceInventoryBookedQuantityId, commerceInventoryWarehouseId, quantity, sku, unitOfMeasureKey, context);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void decreaseStockQuantity(long userId, long commerceCatalogGroupId, long commerceInventoryWarehouseId, BigDecimal quantity, String sku, String unitOfMeasureKey) throws PortalException {
        CommerceInventoryMethod commerceInventoryMethod = this._getCommerceInventoryMethod(commerceCatalogGroupId);
        commerceInventoryMethod.decreaseStockQuantity(userId, commerceInventoryWarehouseId, quantity, sku, unitOfMeasureKey);
    }

    public String getAvailabilityStatus(long companyId, long commerceCatalogGroupId, long commerceChannelGroupId, BigDecimal minStockQuantity, String sku, String unitOfMeasureKey) {
        CommerceInventoryMethod commerceInventoryMethod = this._getCommerceInventoryMethod(commerceCatalogGroupId);
        if (commerceInventoryMethod == null) {
            return null;
        }
        return commerceInventoryMethod.getAvailabilityStatus(companyId, commerceChannelGroupId, minStockQuantity, sku, unitOfMeasureKey);
    }

    public BigDecimal getStockQuantity(long companyId, long commerceCatalogGroupId, long commerceChannelGroupId, String sku, String unitOfMeasureKey) throws PortalException {
        CommerceInventoryMethod commerceInventoryMethod = this._getCommerceInventoryMethod(commerceCatalogGroupId);
        if (commerceInventoryMethod == null) {
            return BigDecimal.ZERO;
        }
        return commerceInventoryMethod.getStockQuantity(companyId, commerceChannelGroupId, sku, unitOfMeasureKey);
    }

    public BigDecimal getStockQuantity(long companyId, long commerceCatalogGroupId, String sku, String unitOfMeasureKey) throws PortalException {
        CommerceInventoryMethod commerceInventoryMethod = this._getCommerceInventoryMethod(commerceCatalogGroupId);
        if (commerceInventoryMethod == null) {
            return BigDecimal.ZERO;
        }
        return commerceInventoryMethod.getStockQuantity(companyId, sku, unitOfMeasureKey);
    }

    public boolean hasStockQuantity(long companyId, long commerceCatalogGroupId, BigDecimal quantity, String sku, String unitOfMeasureKey) {
        CommerceInventoryMethod commerceInventoryMethod = this._getCommerceInventoryMethod(commerceCatalogGroupId);
        if (commerceInventoryMethod == null) {
            return false;
        }
        return commerceInventoryMethod.hasStockQuantity(companyId, quantity, sku, unitOfMeasureKey);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void increaseStockQuantity(long userId, long commerceCatalogGroupId, long commerceInventoryWarehouseId, BigDecimal quantity, String sku, String unitOfMeasureKey) throws PortalException {
        CommerceInventoryMethod commerceInventoryMethod = this._getCommerceInventoryMethod(commerceCatalogGroupId);
        commerceInventoryMethod.increaseStockQuantity(userId, commerceInventoryWarehouseId, quantity, sku, unitOfMeasureKey);
    }

    private CommerceInventoryMethod _getCommerceInventoryMethod(long commerceCatalogGroupId) {
        try {
            CommerceInventoryGroupConfiguration commerceInventoryGroupConfiguration = (CommerceInventoryGroupConfiguration)this._configurationProvider.getGroupConfiguration(CommerceInventoryGroupConfiguration.class, commerceCatalogGroupId);
            CommerceInventoryMethod commerceInventoryMethod = this._commerceInventoryMethodRegistry.getCommerceInventoryMethod(commerceInventoryGroupConfiguration.inventoryMethodKey());
            if (commerceInventoryMethod == null) {
                return this._commerceInventoryMethodRegistry.getCommerceInventoryMethod("default");
            }
            return commerceInventoryMethod;
        }
        catch (ConfigurationException configurationException) {
            _log.error((Throwable)configurationException);
            return this._commerceInventoryMethodRegistry.getCommerceInventoryMethod("default");
        }
    }
}

