/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.model.listener;

import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.model.CommerceInventoryReplenishmentItem;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryReplenishmentItemLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseLocalService;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import java.math.BigDecimal;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class CPInstanceUnitOfMeasureModelListener
extends BaseModelListener<CPInstanceUnitOfMeasure> {
    private static final Log _log = LogFactoryUtil.getLog(CPInstanceUnitOfMeasureModelListener.class);
    @Reference
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @Reference
    private CommerceInventoryReplenishmentItemLocalService _commerceInventoryReplenishmentItemLocalService;
    @Reference
    private CommerceInventoryWarehouseItemLocalService _commerceInventoryWarehouseItemLocalService;
    @Reference
    private CommerceInventoryWarehouseLocalService _commerceInventoryWarehouseLocalService;
    @Reference
    private CPInstanceUnitOfMeasureLocalService _cpInstanceUnitOfMeasureLocalService;

    public void onAfterCreate(CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure) {
        List cpInstanceUnitOfMeasures = this._cpInstanceUnitOfMeasureLocalService.getCPInstanceUnitOfMeasures(cpInstanceUnitOfMeasure.getCPInstanceId(), 0, 2, null);
        if (cpInstanceUnitOfMeasures.size() == 1) {
            this._updateUnitOfMeasureKey(cpInstanceUnitOfMeasure.getCompanyId(), cpInstanceUnitOfMeasure.getKey(), "", cpInstanceUnitOfMeasure.getSku());
        } else {
            for (CommerceInventoryWarehouse commerceInventoryWarehouse : this._commerceInventoryWarehouseLocalService.getCommerceInventoryWarehouses(cpInstanceUnitOfMeasure.getCompanyId())) {
                try {
                    this._commerceInventoryWarehouseItemLocalService.addCommerceInventoryWarehouseItem(null, cpInstanceUnitOfMeasure.getUserId(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), BigDecimal.ZERO, cpInstanceUnitOfMeasure.getSku(), cpInstanceUnitOfMeasure.getKey());
                }
                catch (PortalException portalException) {
                    _log.error((Throwable)portalException);
                }
            }
        }
    }

    public void onAfterRemove(CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure) throws ModelListenerException {
        List cpInstanceUnitOfMeasures = this._cpInstanceUnitOfMeasureLocalService.getCPInstanceUnitOfMeasures(cpInstanceUnitOfMeasure.getCPInstanceId(), 0, 1, null);
        if (cpInstanceUnitOfMeasures.isEmpty()) {
            this._updateUnitOfMeasureKey(cpInstanceUnitOfMeasure.getCompanyId(), "", cpInstanceUnitOfMeasure.getKey(), cpInstanceUnitOfMeasure.getSku());
        } else {
            for (CommerceInventoryWarehouse commerceInventoryWarehouse : this._commerceInventoryWarehouseLocalService.getCommerceInventoryWarehouses(cpInstanceUnitOfMeasure.getCompanyId())) {
                this._commerceInventoryWarehouseItemLocalService.deleteCommerceInventoryWarehouseItems(commerceInventoryWarehouse.getCompanyId(), cpInstanceUnitOfMeasure.getSku(), cpInstanceUnitOfMeasure.getKey());
            }
        }
    }

    public void onAfterUpdate(CPInstanceUnitOfMeasure originalCPInstanceUnitOfMeasure, CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure) throws ModelListenerException {
        String key = cpInstanceUnitOfMeasure.getKey();
        if (key.equals(originalCPInstanceUnitOfMeasure.getKey())) {
            return;
        }
        this._updateUnitOfMeasureKey(originalCPInstanceUnitOfMeasure.getCompanyId(), cpInstanceUnitOfMeasure.getKey(), originalCPInstanceUnitOfMeasure.getKey(), originalCPInstanceUnitOfMeasure.getSku());
    }

    private void _updateUnitOfMeasureKey(long companyId, String key, String originalKey, String sku) {
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : this._commerceInventoryBookedQuantityLocalService.getCommerceInventoryBookedQuantities(companyId, sku, originalKey, -1, -1)) {
            commerceInventoryBookedQuantity.setUnitOfMeasureKey(key);
            this._commerceInventoryBookedQuantityLocalService.updateCommerceInventoryBookedQuantity(commerceInventoryBookedQuantity);
        }
        for (CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem : this._commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItemsByCompanyIdSkuAndUnitOfMeasureKey(companyId, sku, originalKey, -1, -1)) {
            commerceInventoryReplenishmentItem.setUnitOfMeasureKey(key);
            this._commerceInventoryReplenishmentItemLocalService.updateCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItem);
        }
        for (CommerceInventoryWarehouseItem commerceInventoryWarehouseItem : this._commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsByCompanyIdSkuAndUnitOfMeasureKey(companyId, sku, originalKey, -1, -1)) {
            commerceInventoryWarehouseItem.setUnitOfMeasureKey(key);
            this._commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(commerceInventoryWarehouseItem);
        }
    }
}

