/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.upgrade.registry;

import com.liferay.commerce.inventory.internal.upgrade.v2_0_0.CommerceInventoryAuditUpgradeProcess;
import com.liferay.commerce.inventory.internal.upgrade.v2_1_0.MVCCUpgradeProcess;
import com.liferay.commerce.inventory.internal.upgrade.v2_5_0.CommerceInventoryWarehouseUpgradeProcess;
import com.liferay.commerce.inventory.internal.upgrade.v2_5_1.CommerceInventoryReplenishmentItemUpgradeProcess;
import com.liferay.commerce.inventory.internal.upgrade.v2_6_0.util.CommerceInventoryWarehouseRelTable;
import com.liferay.commerce.inventory.internal.upgrade.v2_6_1.CommercePermissionUpgradeProcess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.BaseExternalReferenceCodeUpgradeProcess;
import com.liferay.portal.kernel.upgrade.BaseUuidUpgradeProcess;
import com.liferay.portal.kernel.upgrade.DummyUpgradeProcess;
import com.liferay.portal.kernel.upgrade.DummyUpgradeStep;
import com.liferay.portal.kernel.upgrade.MVCCVersionUpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UpgradeStepRegistrator.class})
public class CommerceInventoryServiceUpgradeStepRegistrator
implements UpgradeStepRegistrator {
    private static final Log _log = LogFactoryUtil.getLog(CommerceInventoryServiceUpgradeStepRegistrator.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    public void register(UpgradeStepRegistrator.Registry registry) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce inventory upgrade step registrator started");
        }
        registry.register("1.0.0", "1.1.0", new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"CIWarehouseItem", (String[])new String[]{"externalReferenceCode VARCHAR(75)"})});
        registry.register("1.1.0", "1.2.0", new UpgradeStep[]{new DummyUpgradeProcess()});
        registry.register("1.2.0", "2.0.0", new UpgradeStep[]{new CommerceInventoryAuditUpgradeProcess()});
        registry.register("2.0.0", "2.1.0", new UpgradeStep[]{new MVCCUpgradeProcess()});
        registry.register("2.1.0", "2.2.0", new UpgradeStep[]{new MVCCVersionUpgradeProcess(){

            protected String[] getTableNames() {
                return new String[]{"CIAudit", "CIBookedQuantity", "CIReplenishmentItem", "CIWarehouse", "CIWarehouseGroupRel", "CIWarehouseItem"};
            }
        }});
        registry.register("2.2.0", "2.3.0", new UpgradeStep[]{new BaseUuidUpgradeProcess(){

            protected String[][] getTableAndPrimaryKeyColumnNames() {
                return new String[][]{{"CIWarehouse", "CIWarehouseId"}, {"CIWarehouseItem", "CIWarehouseItemId"}};
            }
        }});
        registry.register("2.3.0", "2.3.1", new UpgradeStep[]{new BaseExternalReferenceCodeUpgradeProcess(){

            protected String[][] getTableAndPrimaryKeyColumnNames() {
                return new String[][]{{"CIWarehouse", "CIWarehouseId"}, {"CIWarehouseItem", "CIWarehouseItemId"}};
            }
        }});
        registry.register("2.3.1", "2.4.0", new UpgradeStep[]{new BaseUuidUpgradeProcess(){

            protected String[][] getTableAndPrimaryKeyColumnNames() {
                return new String[][]{{"CIReplenishmentItem", "CIReplenishmentItemId"}};
            }
        }});
        registry.register("2.4.0", "2.4.1", new UpgradeStep[]{new BaseExternalReferenceCodeUpgradeProcess(){

            protected String[][] getTableAndPrimaryKeyColumnNames() {
                return new String[][]{{"CIReplenishmentItem", "CIReplenishmentItemId"}};
            }
        }});
        registry.register("2.4.1", "2.5.0", new UpgradeStep[]{new CommerceInventoryWarehouseUpgradeProcess(this._resourceActionLocalService)});
        registry.register("2.5.0", "2.5.1", new UpgradeStep[]{new CommerceInventoryReplenishmentItemUpgradeProcess()});
        registry.register("2.5.1", "2.6.0", new UpgradeStep[]{CommerceInventoryWarehouseRelTable.create(), new com.liferay.commerce.inventory.internal.upgrade.v2_6_0.CommerceInventoryWarehouseUpgradeProcess()});
        registry.register("2.6.0", "2.6.1", new UpgradeStep[]{new CommercePermissionUpgradeProcess(this._resourcePermissionLocalService, this._roleLocalService)});
        registry.register("2.6.1", "2.7.0", new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"CIAudit", (String[])new String[]{"unitOfMeasureKey VARCHAR(75) null"}), UpgradeProcessFactory.addColumns((String)"CIBookedQuantity", (String[])new String[]{"unitOfMeasureKey VARCHAR(75) null"}), UpgradeProcessFactory.addColumns((String)"CIReplenishmentItem", (String[])new String[]{"unitOfMeasureKey VARCHAR(75) null"}), UpgradeProcessFactory.addColumns((String)"CIWarehouseItem", (String[])new String[]{"unitOfMeasureKey VARCHAR(75) null"})});
        registry.register("2.7.0", "2.8.0", new UpgradeStep[]{UpgradeProcessFactory.alterColumnType((String)"CIAudit", (String)"quantity", (String)"BIGDECIMAL null")});
        registry.register("2.8.0", "2.9.0", new UpgradeStep[]{UpgradeProcessFactory.alterColumnType((String)"CIWarehouseItem", (String)"quantity", (String)"BIGDECIMAL null"), UpgradeProcessFactory.alterColumnType((String)"CIWarehouseItem", (String)"reservedQuantity", (String)"BIGDECIMAL null")});
        registry.register("2.9.0", "2.10.0", new UpgradeStep[]{UpgradeProcessFactory.alterColumnType((String)"CIReplenishmentItem", (String)"quantity", (String)"BIGDECIMAL null")});
        registry.register("2.10.0", "2.11.0", new UpgradeStep[]{UpgradeProcessFactory.alterColumnType((String)"CIBookedQuantity", (String)"quantity", (String)"BIGDECIMAL null")});
        registry.register("2.11.0", "2.11.1", new UpgradeStep[]{new DummyUpgradeStep()});
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce inventory upgrade step registrator finished");
        }
    }
}

