/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.base.CommerceInventoryWarehouseItemServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceInventoryWarehouseItem"}, service={AopService.class})
public class CommerceInventoryWarehouseItemServiceImpl
extends CommerceInventoryWarehouseItemServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryWarehouse)")
    private ModelResourcePermission<CommerceInventoryWarehouse> _commerceInventoryWarehouseModelResourcePermission;

    public CommerceInventoryWarehouseItem addCommerceInventoryWarehouseItem(String externalReferenceCode, long commerceInventoryWarehouseId, BigDecimal quantity, String sku, String unitOfMeasureKey) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.commerceInventoryWarehouseItemLocalService.addCommerceInventoryWarehouseItem(externalReferenceCode, this.getUserId(), commerceInventoryWarehouseId, quantity, sku, unitOfMeasureKey);
    }

    public CommerceInventoryWarehouseItem addOrUpdateCommerceInventoryWarehouseItem(String externalReferenceCode, long companyId, long commerceInventoryWarehouseId, BigDecimal quantity, String sku, String unitOfMeasureKey) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.commerceInventoryWarehouseItemLocalService.addOrUpdateCommerceInventoryWarehouseItem(externalReferenceCode, companyId, this.getUserId(), commerceInventoryWarehouseId, quantity, sku, unitOfMeasureKey);
    }

    public void deleteCommerceInventoryWarehouseItem(long commerceInventoryWarehouseItemId) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem != null) {
            this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseItem.getCommerceInventoryWarehouseId(), "UPDATE");
        }
        this.commerceInventoryWarehouseItemLocalService.deleteCommerceInventoryWarehouseItem(commerceInventoryWarehouseItemId);
    }

    public void deleteCommerceInventoryWarehouseItems(long companyId, String sku, String unitOfMeasureKey) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        this.commerceInventoryWarehouseItemLocalService.deleteCommerceInventoryWarehouseItems(companyId, sku, unitOfMeasureKey);
    }

    public CommerceInventoryWarehouseItem fetchCommerceInventoryWarehouseItem(long commerceInventoryWarehouseId, String sku, String unitOfMeasureKey) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "VIEW");
        return this.commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseId, sku, unitOfMeasureKey);
    }

    public CommerceInventoryWarehouseItem fetchCommerceInventoryWarehouseItemByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItemByExternalReferenceCode(externalReferenceCode, companyId);
        if (commerceInventoryWarehouseItem != null) {
            this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseItem.getCommerceInventoryWarehouseId(), "VIEW");
        }
        return commerceInventoryWarehouseItem;
    }

    public CommerceInventoryWarehouseItem getCommerceInventoryWarehouseItem(long commerceInventoryWarehouseItemId) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItem(commerceInventoryWarehouseItemId);
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseItem.getCommerceInventoryWarehouseId(), "VIEW");
        return commerceInventoryWarehouseItem;
    }

    public CommerceInventoryWarehouseItem getCommerceInventoryWarehouseItem(long commerceInventoryWarehouseId, String sku, String unitOfMeasureKey) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "VIEW");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItem(commerceInventoryWarehouseId, sku, unitOfMeasureKey);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItems(long commerceInventoryWarehouseId, int start, int end) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "VIEW");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItems(commerceInventoryWarehouseId, start, end);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsByCompanyId(long companyId, int start, int end) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsByCompanyId(companyId, start, end);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsByCompanyIdSkuAndUnitOfMeasureKey(long companyId, String sku, String unitOfMeasureKey, int start, int end) throws PrincipalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsByCompanyIdSkuAndUnitOfMeasureKey(companyId, sku, unitOfMeasureKey, start, end);
    }

    public int getCommerceInventoryWarehouseItemsCount(long commerceInventoryWarehouseId) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "VIEW");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsCount(commerceInventoryWarehouseId);
    }

    public int getCommerceInventoryWarehouseItemsCount(long companyId, long groupId, String sku, String unitOfMeasureKey) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsCount(companyId, groupId, sku, unitOfMeasureKey);
    }

    public int getCommerceInventoryWarehouseItemsCount(long companyId, String sku, String unitOfMeasureKey) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsCount(companyId, sku, unitOfMeasureKey);
    }

    public int getCommerceInventoryWarehouseItemsCountByCompanyId(long companyId) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsCountByCompanyId(companyId);
    }

    public int getCommerceInventoryWarehouseItemsCountByModifiedDate(long companyId, Date startDate, Date endDate) throws PrincipalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsCountByModifiedDate(companyId, startDate, endDate);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsCountByModifiedDate(long companyId, Date startDate, Date endDate, int start, int end) throws PrincipalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsByModifiedDate(companyId, startDate, endDate, start, end);
    }

    public BigDecimal getStockQuantity(long companyId, long groupId, String sku, String unitOfMeasureKey) {
        return this.commerceInventoryWarehouseItemLocalService.getStockQuantity(companyId, groupId, sku, unitOfMeasureKey);
    }

    public BigDecimal getStockQuantity(long companyId, String sku, String unitOfMeasureKey) {
        return this.commerceInventoryWarehouseItemLocalService.getStockQuantity(companyId, sku, unitOfMeasureKey);
    }

    public CommerceInventoryWarehouseItem increaseCommerceInventoryWarehouseItemQuantity(long commerceInventoryWarehouseItemId, BigDecimal quantity) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem != null) {
            this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseItem.getCommerceInventoryWarehouseId(), "UPDATE");
        }
        return this.commerceInventoryWarehouseItemLocalService.increaseCommerceInventoryWarehouseItemQuantity(this.getUserId(), commerceInventoryWarehouseItemId, quantity);
    }

    public void moveQuantitiesBetweenWarehouses(long fromCommerceInventoryWarehouseId, long toCommerceInventoryWarehouseId, BigDecimal quantity, String sku, String unitOfMeasureKey) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), fromCommerceInventoryWarehouseId, "UPDATE");
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), toCommerceInventoryWarehouseId, "UPDATE");
        this.commerceInventoryWarehouseItemLocalService.moveQuantitiesBetweenWarehouses(this.getUserId(), fromCommerceInventoryWarehouseId, toCommerceInventoryWarehouseId, quantity, sku, unitOfMeasureKey);
    }

    public CommerceInventoryWarehouseItem updateCommerceInventoryWarehouseItem(long commerceInventoryWarehouseItemId, BigDecimal quantity, BigDecimal reservedQuantity, long mvccVersion) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem != null) {
            this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseItem.getCommerceInventoryWarehouseId(), "UPDATE");
        }
        return this.commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(this.getUserId(), commerceInventoryWarehouseItemId, quantity, reservedQuantity, mvccVersion);
    }

    public CommerceInventoryWarehouseItem updateCommerceInventoryWarehouseItem(long commerceInventoryWarehouseItemId, long mvccVersion, BigDecimal quantity, String unitOfMeasureKey) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem != null) {
            this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseItem.getCommerceInventoryWarehouseId(), "UPDATE");
        }
        return this.commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(this.getUserId(), commerceInventoryWarehouseItemId, mvccVersion, quantity, unitOfMeasureKey);
    }
}

