/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.exception.DuplicateCommerceInventoryWarehouseRelException;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseRel;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseRelTable;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseTable;
import com.liferay.commerce.inventory.service.base.CommerceInventoryWarehouseRelLocalServiceBaseImpl;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.model.CommerceOrderTypeTable;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryWarehouseRel"}, service={AopService.class})
public class CommerceInventoryWarehouseRelLocalServiceImpl
extends CommerceInventoryWarehouseRelLocalServiceBaseImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceInventoryWarehouseRel addCommerceInventoryWarehouseRel(long userId, String className, long classPK, long commerceInventoryWarehouseId) throws PortalException {
        long classNameId = this._classNameLocalService.getClassNameId(className);
        this._validate(classNameId, classPK, commerceInventoryWarehouseId);
        CommerceInventoryWarehouseRel commerceInventoryWarehouseRel = this.commerceInventoryWarehouseRelPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        commerceInventoryWarehouseRel.setCompanyId(user.getCompanyId());
        commerceInventoryWarehouseRel.setUserId(user.getUserId());
        commerceInventoryWarehouseRel.setUserName(user.getFullName());
        commerceInventoryWarehouseRel.setClassNameId(classNameId);
        commerceInventoryWarehouseRel.setClassPK(classPK);
        commerceInventoryWarehouseRel.setCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
        commerceInventoryWarehouseRel = (CommerceInventoryWarehouseRel)this.commerceInventoryWarehouseRelPersistence.update((BaseModel)commerceInventoryWarehouseRel);
        this._reindexCommerceInventoryWarehouse(commerceInventoryWarehouseId);
        return commerceInventoryWarehouseRel;
    }

    @Override
    @SystemEvent(type=1)
    public CommerceInventoryWarehouseRel deleteCommerceInventoryWarehouseRel(CommerceInventoryWarehouseRel commerceInventoryWarehouseRel) throws PortalException {
        this.commerceInventoryWarehouseRelPersistence.remove((BaseModel)commerceInventoryWarehouseRel);
        this._reindexCommerceInventoryWarehouse(commerceInventoryWarehouseRel.getCommerceInventoryWarehouseId());
        return commerceInventoryWarehouseRel;
    }

    @Override
    public CommerceInventoryWarehouseRel deleteCommerceInventoryWarehouseRel(long commerceInventoryWarehouseRelId) throws PortalException {
        CommerceInventoryWarehouseRel commerceInventoryWarehouseRel = this.commerceInventoryWarehouseRelPersistence.findByPrimaryKey(commerceInventoryWarehouseRelId);
        return this.commerceInventoryWarehouseRelLocalService.deleteCommerceInventoryWarehouseRel(commerceInventoryWarehouseRel);
    }

    public void deleteCommerceInventoryWarehouseRels(long commerceInventoryWarehouseId) throws PortalException {
        List commerceInventoryWarehouseRels = this.commerceInventoryWarehouseRelPersistence.findByCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
        for (CommerceInventoryWarehouseRel commerceInventoryWarehouseRel : commerceInventoryWarehouseRels) {
            this.commerceInventoryWarehouseRelLocalService.deleteCommerceInventoryWarehouseRel(commerceInventoryWarehouseRel);
        }
    }

    public void deleteCommerceInventoryWarehouseRels(String className, long commerceInventoryWarehouseId) throws PortalException {
        List commerceInventoryWarehouseRels = this.commerceInventoryWarehouseRelPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), commerceInventoryWarehouseId);
        for (CommerceInventoryWarehouseRel commerceInventoryWarehouseRel : commerceInventoryWarehouseRels) {
            this.commerceInventoryWarehouseRelLocalService.deleteCommerceInventoryWarehouseRel(commerceInventoryWarehouseRel);
        }
    }

    public CommerceInventoryWarehouseRel fetchCommerceInventoryWarehouseRel(String className, long classPK, long commerceInventoryWarehouseId) {
        return this.commerceInventoryWarehouseRelPersistence.fetchByC_C_CIWI(this._classNameLocalService.getClassNameId(className), classPK, commerceInventoryWarehouseId);
    }

    public List<CommerceInventoryWarehouseRel> getCommerceInventoryWarehouseRels(long commerceInventoryWarehouseId) {
        return this.commerceInventoryWarehouseRelPersistence.findByCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
    }

    public List<CommerceInventoryWarehouseRel> getCommerceInventoryWarehouseRels(long commerceInventoryWarehouseId, int start, int end, OrderByComparator<CommerceInventoryWarehouseRel> orderByComparator) {
        return this.commerceInventoryWarehouseRelPersistence.findByCommerceInventoryWarehouseId(commerceInventoryWarehouseId, start, end, orderByComparator);
    }

    public int getCommerceInventoryWarehouseRelsCount(long commerceInventoryWarehouseId) {
        return this.commerceInventoryWarehouseRelPersistence.countByCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
    }

    public List<CommerceInventoryWarehouseRel> getCommerceOrderTypeCommerceInventoryWarehouseRels(long commerceInventoryWarehouseId, String keywords, int start, int end) {
        return (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceInventoryWarehouseRelTable.INSTANCE), (Table)CommerceOrderTypeTable.INSTANCE, CommerceOrderTypeTable.INSTANCE.commerceOrderTypeId.eq((Expression)CommerceInventoryWarehouseRelTable.INSTANCE.classPK), commerceInventoryWarehouseId, CommerceOrderType.class.getName(), keywords, (Expression<String>)CommerceOrderTypeTable.INSTANCE.name).limit(start, end));
    }

    public int getCommerceOrderTypeCommerceInventoryWarehouseRelsCount(long commerceInventoryWarehouseId, String keywords) {
        return this.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)CommerceInventoryWarehouseRelTable.INSTANCE.commerceInventoryWarehouseRelId), (Table)CommerceOrderTypeTable.INSTANCE, CommerceOrderTypeTable.INSTANCE.commerceOrderTypeId.eq((Expression)CommerceInventoryWarehouseRelTable.INSTANCE.classPK), commerceInventoryWarehouseId, CommerceOrderType.class.getName(), keywords, (Expression<String>)CommerceOrderTypeTable.INSTANCE.name));
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, Table innerJoinTable, Predicate innerJoinPredicate, Long commerceInventoryWarehouseId, String className, String keywords, Expression<String> keywordsPredicateExpression) {
        JoinStep joinStep = fromStep.from((Table)CommerceInventoryWarehouseRelTable.INSTANCE).innerJoinON((Table)CommerceInventoryWarehouseTable.INSTANCE, CommerceInventoryWarehouseTable.INSTANCE.commerceInventoryWarehouseId.eq((Expression)CommerceInventoryWarehouseRelTable.INSTANCE.commerceInventoryWarehouseId)).innerJoinON(innerJoinTable, innerJoinPredicate);
        return joinStep.where(() -> CommerceInventoryWarehouseRelTable.INSTANCE.commerceInventoryWarehouseId.eq((Object)commerceInventoryWarehouseId).and((Expression)CommerceInventoryWarehouseRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(className))).and(() -> {
            if (Validator.isNotNull((String)keywords)) {
                return Predicate.withParentheses((Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)keywordsPredicateExpression), this._customSQL.keywords(keywords, true)));
            }
            return null;
        }));
    }

    private void _reindexCommerceInventoryWarehouse(long commerceInventoryWarehouseId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceInventoryWarehouse.class);
        indexer.reindex(CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouseId);
    }

    private void _validate(long classNameId, long classPK, long commerceInventoryWarehouseId) throws PortalException {
        CommerceInventoryWarehouseRel commerceInventoryWarehouseRel = this.commerceInventoryWarehouseRelPersistence.fetchByC_C_CIWI(classNameId, classPK, commerceInventoryWarehouseId);
        if (commerceInventoryWarehouseRel != null) {
            throw new DuplicateCommerceInventoryWarehouseRelException();
        }
    }
}

