/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.inventory.model.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceInventoryWarehouse service. Represents a row in the &quot;CIWarehouse&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceInventoryWarehouseImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceInventoryWarehouseImpl
 * @see CommerceInventoryWarehouse
 * @generated
 */
public abstract class CommerceInventoryWarehouseBaseImpl
	extends CommerceInventoryWarehouseModelImpl
	implements CommerceInventoryWarehouse {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce inventory warehouse model instance should use the <code>CommerceInventoryWarehouse</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceInventoryWarehouseLocalServiceUtil.
				addCommerceInventoryWarehouse(this);
		}
		else {
			CommerceInventoryWarehouseLocalServiceUtil.
				updateCommerceInventoryWarehouse(this);
		}
	}

}