/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.inventory.model.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseRel;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseRelModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceInventoryWarehouseRel service. Represents a row in the &quot;CIWarehouseRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceInventoryWarehouseRelModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceInventoryWarehouseRelImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceInventoryWarehouseRelImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceInventoryWarehouseRelModelImpl
	extends BaseModelImpl<CommerceInventoryWarehouseRel>
	implements CommerceInventoryWarehouseRelModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce inventory warehouse rel model instance should use the <code>CommerceInventoryWarehouseRel</code> interface instead.
	 */
	public static final String TABLE_NAME = "CIWarehouseRel";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"CIWarehouseRelId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"classNameId", Types.BIGINT},
		{"classPK", Types.BIGINT}, {"CIWarehouseId", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CIWarehouseRelId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CIWarehouseId", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CIWarehouseRel (mvccVersion LONG default 0 not null,CIWarehouseRelId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,CIWarehouseId LONG)";

	public static final String TABLE_SQL_DROP = "drop table CIWarehouseRel";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceInventoryWarehouseRel.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CIWarehouseRel.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCEINVENTORYWAREHOUSEID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CommerceInventoryWarehouseRelModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceInventoryWarehouseRelId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceInventoryWarehouseRelId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceInventoryWarehouseRelId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceInventoryWarehouseRel.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceInventoryWarehouseRel.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceInventoryWarehouseRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceInventoryWarehouseRel, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceInventoryWarehouseRel, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(CommerceInventoryWarehouseRel)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceInventoryWarehouseRel, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceInventoryWarehouseRel, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceInventoryWarehouseRel)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceInventoryWarehouseRel, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceInventoryWarehouseRel, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map
			<String, Function<CommerceInventoryWarehouseRel, Object>>
				_attributeGetterFunctions;

		static {
			Map<String, Function<CommerceInventoryWarehouseRel, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String,
						 Function<CommerceInventoryWarehouseRel, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", CommerceInventoryWarehouseRel::getMvccVersion);
			attributeGetterFunctions.put(
				"commerceInventoryWarehouseRelId",
				CommerceInventoryWarehouseRel::
					getCommerceInventoryWarehouseRelId);
			attributeGetterFunctions.put(
				"companyId", CommerceInventoryWarehouseRel::getCompanyId);
			attributeGetterFunctions.put(
				"userId", CommerceInventoryWarehouseRel::getUserId);
			attributeGetterFunctions.put(
				"userName", CommerceInventoryWarehouseRel::getUserName);
			attributeGetterFunctions.put(
				"createDate", CommerceInventoryWarehouseRel::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", CommerceInventoryWarehouseRel::getModifiedDate);
			attributeGetterFunctions.put(
				"classNameId", CommerceInventoryWarehouseRel::getClassNameId);
			attributeGetterFunctions.put(
				"classPK", CommerceInventoryWarehouseRel::getClassPK);
			attributeGetterFunctions.put(
				"commerceInventoryWarehouseId",
				CommerceInventoryWarehouseRel::getCommerceInventoryWarehouseId);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<CommerceInventoryWarehouseRel, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<CommerceInventoryWarehouseRel, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String,
						 BiConsumer<CommerceInventoryWarehouseRel, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<CommerceInventoryWarehouseRel, Long>)
					CommerceInventoryWarehouseRel::setMvccVersion);
			attributeSetterBiConsumers.put(
				"commerceInventoryWarehouseRelId",
				(BiConsumer<CommerceInventoryWarehouseRel, Long>)
					CommerceInventoryWarehouseRel::
						setCommerceInventoryWarehouseRelId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<CommerceInventoryWarehouseRel, Long>)
					CommerceInventoryWarehouseRel::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<CommerceInventoryWarehouseRel, Long>)
					CommerceInventoryWarehouseRel::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<CommerceInventoryWarehouseRel, String>)
					CommerceInventoryWarehouseRel::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<CommerceInventoryWarehouseRel, Date>)
					CommerceInventoryWarehouseRel::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<CommerceInventoryWarehouseRel, Date>)
					CommerceInventoryWarehouseRel::setModifiedDate);
			attributeSetterBiConsumers.put(
				"classNameId",
				(BiConsumer<CommerceInventoryWarehouseRel, Long>)
					CommerceInventoryWarehouseRel::setClassNameId);
			attributeSetterBiConsumers.put(
				"classPK",
				(BiConsumer<CommerceInventoryWarehouseRel, Long>)
					CommerceInventoryWarehouseRel::setClassPK);
			attributeSetterBiConsumers.put(
				"commerceInventoryWarehouseId",
				(BiConsumer<CommerceInventoryWarehouseRel, Long>)
					CommerceInventoryWarehouseRel::
						setCommerceInventoryWarehouseId);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCommerceInventoryWarehouseRelId() {
		return _commerceInventoryWarehouseRelId;
	}

	@Override
	public void setCommerceInventoryWarehouseRelId(
		long commerceInventoryWarehouseRelId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceInventoryWarehouseRelId = commerceInventoryWarehouseRelId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@JSON
	@Override
	public long getCommerceInventoryWarehouseId() {
		return _commerceInventoryWarehouseId;
	}

	@Override
	public void setCommerceInventoryWarehouseId(
		long commerceInventoryWarehouseId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceInventoryWarehouseId = commerceInventoryWarehouseId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommerceInventoryWarehouseId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("CIWarehouseId"));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceInventoryWarehouseRel.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceInventoryWarehouseRel toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceInventoryWarehouseRel>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceInventoryWarehouseRelImpl commerceInventoryWarehouseRelImpl =
			new CommerceInventoryWarehouseRelImpl();

		commerceInventoryWarehouseRelImpl.setMvccVersion(getMvccVersion());
		commerceInventoryWarehouseRelImpl.setCommerceInventoryWarehouseRelId(
			getCommerceInventoryWarehouseRelId());
		commerceInventoryWarehouseRelImpl.setCompanyId(getCompanyId());
		commerceInventoryWarehouseRelImpl.setUserId(getUserId());
		commerceInventoryWarehouseRelImpl.setUserName(getUserName());
		commerceInventoryWarehouseRelImpl.setCreateDate(getCreateDate());
		commerceInventoryWarehouseRelImpl.setModifiedDate(getModifiedDate());
		commerceInventoryWarehouseRelImpl.setClassNameId(getClassNameId());
		commerceInventoryWarehouseRelImpl.setClassPK(getClassPK());
		commerceInventoryWarehouseRelImpl.setCommerceInventoryWarehouseId(
			getCommerceInventoryWarehouseId());

		commerceInventoryWarehouseRelImpl.resetOriginalValues();

		return commerceInventoryWarehouseRelImpl;
	}

	@Override
	public CommerceInventoryWarehouseRel cloneWithOriginalValues() {
		CommerceInventoryWarehouseRelImpl commerceInventoryWarehouseRelImpl =
			new CommerceInventoryWarehouseRelImpl();

		commerceInventoryWarehouseRelImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		commerceInventoryWarehouseRelImpl.setCommerceInventoryWarehouseRelId(
			this.<Long>getColumnOriginalValue("CIWarehouseRelId"));
		commerceInventoryWarehouseRelImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		commerceInventoryWarehouseRelImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		commerceInventoryWarehouseRelImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		commerceInventoryWarehouseRelImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		commerceInventoryWarehouseRelImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		commerceInventoryWarehouseRelImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		commerceInventoryWarehouseRelImpl.setClassPK(
			this.<Long>getColumnOriginalValue("classPK"));
		commerceInventoryWarehouseRelImpl.setCommerceInventoryWarehouseId(
			this.<Long>getColumnOriginalValue("CIWarehouseId"));

		return commerceInventoryWarehouseRelImpl;
	}

	@Override
	public int compareTo(
		CommerceInventoryWarehouseRel commerceInventoryWarehouseRel) {

		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commerceInventoryWarehouseRel.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceInventoryWarehouseRel)) {
			return false;
		}

		CommerceInventoryWarehouseRel commerceInventoryWarehouseRel =
			(CommerceInventoryWarehouseRel)object;

		long primaryKey = commerceInventoryWarehouseRel.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceInventoryWarehouseRel> toCacheModel() {
		CommerceInventoryWarehouseRelCacheModel
			commerceInventoryWarehouseRelCacheModel =
				new CommerceInventoryWarehouseRelCacheModel();

		commerceInventoryWarehouseRelCacheModel.mvccVersion = getMvccVersion();

		commerceInventoryWarehouseRelCacheModel.
			commerceInventoryWarehouseRelId =
				getCommerceInventoryWarehouseRelId();

		commerceInventoryWarehouseRelCacheModel.companyId = getCompanyId();

		commerceInventoryWarehouseRelCacheModel.userId = getUserId();

		commerceInventoryWarehouseRelCacheModel.userName = getUserName();

		String userName = commerceInventoryWarehouseRelCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceInventoryWarehouseRelCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceInventoryWarehouseRelCacheModel.createDate =
				createDate.getTime();
		}
		else {
			commerceInventoryWarehouseRelCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceInventoryWarehouseRelCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commerceInventoryWarehouseRelCacheModel.modifiedDate =
				Long.MIN_VALUE;
		}

		commerceInventoryWarehouseRelCacheModel.classNameId = getClassNameId();

		commerceInventoryWarehouseRelCacheModel.classPK = getClassPK();

		commerceInventoryWarehouseRelCacheModel.commerceInventoryWarehouseId =
			getCommerceInventoryWarehouseId();

		return commerceInventoryWarehouseRelCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceInventoryWarehouseRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceInventoryWarehouseRel, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceInventoryWarehouseRel, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceInventoryWarehouseRel)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, CommerceInventoryWarehouseRel>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						CommerceInventoryWarehouseRel.class,
						ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _commerceInventoryWarehouseRelId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _classPK;
	private long _commerceInventoryWarehouseId;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceInventoryWarehouseRel, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceInventoryWarehouseRel)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put(
			"CIWarehouseRelId", _commerceInventoryWarehouseRelId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put(
			"CIWarehouseId", _commerceInventoryWarehouseId);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put(
			"CIWarehouseRelId", "commerceInventoryWarehouseRelId");
		attributeNames.put("CIWarehouseId", "commerceInventoryWarehouseId");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("CIWarehouseRelId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("classNameId", 128L);

		columnBitmasks.put("classPK", 256L);

		columnBitmasks.put("CIWarehouseId", 512L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceInventoryWarehouseRel _escapedModel;

}