/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.permission;

import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.permission.CommerceInventoryWarehousePermission;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseLocalService;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelRel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.service.CommerceChannelRelLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceInventoryWarehousePermission.class})
public class CommerceInventoryWarehousePermissionImpl
implements CommerceInventoryWarehousePermission {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceChannelRelLocalService _commerceChannelRelLocalService;
    @Reference
    private CommerceInventoryWarehouseLocalService _commerceInventoryWarehouseLocalService;
    @Reference(target="(resource.name=com.liferay.commerce.inventory)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;

    public void check(PermissionChecker permissionChecker, CommerceInventoryWarehouse commerceInventoryWarehouse, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceInventoryWarehouse, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long commerceInventoryWarehouseId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceInventoryWarehouseId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouseId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CommerceInventoryWarehouse commerceInventoryWarehouse, String actionId) throws PortalException {
        return this.contains(permissionChecker, commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long commerceInventoryWarehouseId, String actionId) throws PortalException {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseLocalService.getCommerceInventoryWarehouse(commerceInventoryWarehouseId);
        if (commerceInventoryWarehouse == null) {
            return false;
        }
        return this._contains(permissionChecker, commerceInventoryWarehouse, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] commerceAccountIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])commerceAccountIds)) {
            return false;
        }
        for (long commerceInventoryWarehouseId : commerceAccountIds) {
            if (this.contains(permissionChecker, commerceInventoryWarehouseId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CommerceInventoryWarehouse commerceInventoryWarehouse, String actionId) throws PortalException {
        if (permissionChecker.isCompanyAdmin(commerceInventoryWarehouse.getCompanyId()) || permissionChecker.isOmniadmin() || permissionChecker.hasOwnerPermission(commerceInventoryWarehouse.getCompanyId(), CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), commerceInventoryWarehouse.getUserId(), actionId) || this._portletResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), null, "MANAGE_INVENTORY")) {
            return true;
        }
        if ((actionId.equals("UPDATE") || actionId.equals("VIEW")) && this._hasRoleAccountSupplier(permissionChecker, commerceInventoryWarehouse)) {
            return true;
        }
        return permissionChecker.hasPermission(null, CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), actionId);
    }

    private boolean _hasRoleAccountSupplier(PermissionChecker permissionChecker, CommerceInventoryWarehouse commerceInventoryWarehouse) throws PortalException {
        List accountEntryCommerceChannels = TransformUtil.transform((Collection)this._accountEntryLocalService.getUserAccountEntries(permissionChecker.getUserId(), Long.valueOf(0L), "", new String[]{"supplier"}, -1, -1), accountEntry -> {
            List commerceChannels;
            if (this._userGroupRoleLocalService.hasUserGroupRole(permissionChecker.getUserId(), accountEntry.getAccountEntryGroupId(), "Account Supplier") && ListUtil.isNotEmpty((List)(commerceChannels = this._commerceChannelLocalService.getCommerceChannelsByAccountEntryId(accountEntry.getAccountEntryId())))) {
                return (CommerceChannel)commerceChannels.get(0);
            }
            return null;
        });
        if (ListUtil.isEmpty((List)accountEntryCommerceChannels)) {
            return false;
        }
        int commerceChannelRelsCount = this._commerceChannelRelLocalService.getCommerceChannelRelsCount(CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId());
        if (commerceChannelRelsCount == 0) {
            return false;
        }
        for (CommerceChannel commerceChannel : accountEntryCommerceChannels) {
            CommerceChannelRel commerceChannelRel = this._commerceChannelRelLocalService.fetchCommerceChannelRel(CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), commerceChannel.getCommerceChannelId());
            if (commerceChannelRel == null) continue;
            return true;
        }
        return false;
    }
}

