/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.upgrade.v2_6_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;

public class CommerceInventoryWarehouseUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update CIWarehouse set description = ?, name = ? where CIWarehouseId = ?");
             Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select CIWarehouseId, companyId, description, name from CIWarehouse");){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                String defaultLanguageId = UpgradeProcessUtil.getDefaultLanguageId((long)companyId);
                String descriptionXML = "";
                String description = resultSet.getString("description");
                if (description != null) {
                    descriptionXML = LocalizationUtil.getXml((Map)HashMapBuilder.put((Object)defaultLanguageId, (Object)description).build(), (String)defaultLanguageId, (String)"description");
                }
                preparedStatement.setString(1, descriptionXML);
                String nameXML = "";
                String name = resultSet.getString("name");
                if (name != null) {
                    nameXML = LocalizationUtil.getXml((Map)HashMapBuilder.put((Object)defaultLanguageId, (Object)name).build(), (String)defaultLanguageId, (String)"name");
                }
                preparedStatement.setString(2, nameXML);
                preparedStatement.setLong(3, resultSet.getLong("CIWarehouseId"));
                preparedStatement.execute();
            }
        }
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.alterColumnType((String)"CIWarehouse", (String)"description", (String)"STRING null"), UpgradeProcessFactory.alterColumnType((String)"CIWarehouse", (String)"name", (String)"STRING null")};
    }
}

