/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryReplenishmentItem;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.base.CommerceInventoryReplenishmentItemServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceInventoryReplenishmentItem"}, service={AopService.class})
public class CommerceInventoryReplenishmentItemServiceImpl
extends CommerceInventoryReplenishmentItemServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryWarehouse)")
    private ModelResourcePermission<CommerceInventoryWarehouse> _commerceInventoryWarehouseModelResourcePermission;

    public CommerceInventoryReplenishmentItem addCommerceInventoryReplenishmentItem(String externalReferenceCode, long commerceInventoryWarehouseId, Date availabilityDate, BigDecimal quantity, String sku, String unitOfMeasureKey) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.commerceInventoryReplenishmentItemLocalService.addCommerceInventoryReplenishmentItem(externalReferenceCode, this.getUserId(), commerceInventoryWarehouseId, availabilityDate, quantity, sku, unitOfMeasureKey);
    }

    public void deleteCommerceInventoryReplenishmentItem(long commerceInventoryReplenishmentItemId) throws PortalException {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemLocalService.fetchCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItemId);
        if (commerceInventoryReplenishmentItem != null) {
            this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryReplenishmentItem.getCommerceInventoryWarehouseId(), "DELETE");
        }
        this.commerceInventoryReplenishmentItemLocalService.deleteCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItemId);
    }

    public void deleteCommerceInventoryReplenishmentItems(long companyId, String sku, String unitOfMeasureKey) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        this.commerceInventoryReplenishmentItemLocalService.deleteCommerceInventoryReplenishmentItems(companyId, sku, unitOfMeasureKey);
    }

    public CommerceInventoryReplenishmentItem fetchCommerceInventoryReplenishmentItemByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemLocalService.fetchCommerceInventoryReplenishmentItemByExternalReferenceCode(externalReferenceCode, companyId);
        if (commerceInventoryReplenishmentItem != null) {
            this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryReplenishmentItem.getCommerceInventoryWarehouseId(), "VIEW");
        }
        return commerceInventoryReplenishmentItem;
    }

    public CommerceInventoryReplenishmentItem getCommerceInventoryReplenishmentItem(long commerceInventoryReplenishmentItemId) throws PortalException {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItemId);
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryReplenishmentItem.getCommerceInventoryWarehouseId(), "VIEW");
        return commerceInventoryReplenishmentItem;
    }

    public List<CommerceInventoryReplenishmentItem> getCommerceInventoryReplenishmentItemsByCommerceInventoryWarehouseId(long commerceInventoryWarehouseId, int start, int end) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "VIEW");
        return this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItemsByCommerceInventoryWarehouseId(commerceInventoryWarehouseId, start, end);
    }

    public List<CommerceInventoryReplenishmentItem> getCommerceInventoryReplenishmentItemsByCompanyIdSkuAndUnitOfMeasureKey(long companyId, String sku, String unitOfMeasureKey, int start, int end) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        boolean replacePermissionCheck = !portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItemsByCompanyIdSkuAndUnitOfMeasureKey(companyId, sku, unitOfMeasureKey, start, end, replacePermissionCheck);
    }

    public BigDecimal getCommerceInventoryReplenishmentItemsCount(long commerceInventoryWarehouseId, String sku, String unitOfMeasureKey) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "VIEW");
        return this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItemsCount(commerceInventoryWarehouseId, sku, unitOfMeasureKey);
    }

    public int getCommerceInventoryReplenishmentItemsCountByCommerceInventoryWarehouseId(long commerceInventoryWarehouseId) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "VIEW");
        return this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItemsCountByCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
    }

    public int getCommerceInventoryReplenishmentItemsCountByCompanyIdSkuAndUnitOfMeasureKey(long companyId, String sku, String unitOfMeasureKey) throws PortalException {
        return this.commerceInventoryReplenishmentItemLocalService.getCommerceInventoryReplenishmentItemsCountByCompanyIdSkuAndUnitOfMeasureKey(companyId, sku, unitOfMeasureKey);
    }

    public CommerceInventoryReplenishmentItem updateCommerceInventoryReplenishmentItem(String externalReferenceCode, long commerceInventoryReplenishmentItemId, Date availabilityDate, BigDecimal quantity, long mvccVersion) throws PortalException {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemLocalService.fetchCommerceInventoryReplenishmentItem(commerceInventoryReplenishmentItemId);
        if (commerceInventoryReplenishmentItem != null) {
            this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryReplenishmentItem.getCommerceInventoryWarehouseId(), "UPDATE");
        }
        return this.commerceInventoryReplenishmentItemLocalService.updateCommerceInventoryReplenishmentItem(externalReferenceCode, commerceInventoryReplenishmentItemId, availabilityDate, quantity, mvccVersion);
    }
}

