/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.exception.CommerceInventoryWarehouseItemSkuException;
import com.liferay.commerce.inventory.exception.DuplicateCommerceInventoryWarehouseItemException;
import com.liferay.commerce.inventory.exception.MVCCException;
import com.liferay.commerce.inventory.model.CIWarehouseItem;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantityTable;
import com.liferay.commerce.inventory.model.CommerceInventoryReplenishmentItemTable;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItemTable;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseTable;
import com.liferay.commerce.inventory.service.CommerceInventoryAuditLocalService;
import com.liferay.commerce.inventory.service.base.CommerceInventoryWarehouseItemLocalServiceBaseImpl;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditType;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditTypeRegistry;
import com.liferay.commerce.product.exception.CPInstanceUnitOfMeasureKeyException;
import com.liferay.commerce.product.exception.NoSuchCPInstanceUnitOfMeasureException;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelRelTable;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.base.BaseTable;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.sql.dsl.spi.expression.Scalar;
import com.liferay.petra.sql.dsl.spi.query.QueryTable;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupTable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem"}, service={AopService.class})
public class CommerceInventoryWarehouseItemLocalServiceImpl
extends CommerceInventoryWarehouseItemLocalServiceBaseImpl {
    @Reference
    private CommerceInventoryAuditLocalService _commerceInventoryAuditLocalService;
    @Reference
    private CommerceInventoryAuditTypeRegistry _commerceInventoryAuditTypeRegistry;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private CPInstanceUnitOfMeasureLocalService _cpInstanceUnitOfMeasureLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceInventoryWarehouseItem addCommerceInventoryWarehouseItem(String externalReferenceCode, long userId, long commerceInventoryWarehouseId, BigDecimal quantity, String sku, String unitOfMeasureKey) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        this._validateSku(commerceInventoryWarehouseId, sku, unitOfMeasureKey);
        this._validateUnitOfMeasureKey(user.getCompanyId(), sku, unitOfMeasureKey);
        long commerceInventoryWarehouseItemId = this.counterLocalService.increment();
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.create(commerceInventoryWarehouseItemId);
        commerceInventoryWarehouseItem.setExternalReferenceCode(externalReferenceCode);
        commerceInventoryWarehouseItem.setCompanyId(user.getCompanyId());
        commerceInventoryWarehouseItem.setUserId(user.getUserId());
        commerceInventoryWarehouseItem.setUserName(user.getFullName());
        commerceInventoryWarehouseItem.setCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
        commerceInventoryWarehouseItem.setQuantity(quantity);
        commerceInventoryWarehouseItem.setReservedQuantity(BigDecimal.ZERO);
        commerceInventoryWarehouseItem.setSku(sku);
        commerceInventoryWarehouseItem.setUnitOfMeasureKey(this._normalizeUnitOfMeasureKey(user.getCompanyId(), sku, unitOfMeasureKey));
        return (CommerceInventoryWarehouseItem)this.commerceInventoryWarehouseItemPersistence.update((BaseModel)commerceInventoryWarehouseItem);
    }

    public CommerceInventoryWarehouseItem addOrUpdateCommerceInventoryWarehouseItem(String externalReferenceCode, long companyId, long userId, long commerceInventoryWarehouseId, BigDecimal quantity, String sku, String unitOfMeasureKey) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = null;
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
            commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.fetchByCIWI_S_U(commerceInventoryWarehouseId, sku, unitOfMeasureKey);
        } else {
            commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.fetchByERC_C(externalReferenceCode, companyId);
        }
        if (commerceInventoryWarehouseItem != null) {
            return this.commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), commerceInventoryWarehouseItem.getMvccVersion(), quantity, unitOfMeasureKey);
        }
        return this.commerceInventoryWarehouseItemLocalService.addCommerceInventoryWarehouseItem(externalReferenceCode, userId, commerceInventoryWarehouseId, quantity, sku, unitOfMeasureKey);
    }

    public int countItemsByCompanyId(long companyId, String sku, boolean replacePermissionCheck) {
        GroupByStep dslQuery = DSLQueryFactoryUtil.select((Expression[])new Expression[]{CommerceInventoryWarehouseItemTable.INSTANCE.sku, CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey}).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).leftJoinOn((Table)CommerceInventoryWarehouseTable.INSTANCE, CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId.eq((Expression)CommerceInventoryWarehouseTable.INSTANCE.commerceInventoryWarehouseId)).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and(() -> {
            if (Validator.isNull((String)sku)) {
                return null;
            }
            return DSLFunctionFactoryUtil.lower((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.sku).like("%" + StringUtil.toLowerCase((String)sku) + "%");
        }));
        if (replacePermissionCheck) {
            Column commerceInventoryWarehouseIdColumn = CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId;
            dslQuery = InlineSQLHelperUtil.replacePermissionCheck((DSLQuery)dslQuery, CommerceInventoryWarehouse.class, (Column)commerceInventoryWarehouseIdColumn, (long[])new long[]{0L});
        }
        Table tempCIWarehouseItemTable = dslQuery.as("tempCIWarehouseItem", (Table)CommerceInventoryWarehouseItemTable.INSTANCE);
        return this.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from(DSLQueryFactoryUtil.select((Expression[])new Expression[]{tempCIWarehouseItemTable.getColumn("sku", String.class), tempCIWarehouseItemTable.getColumn("unitOfMeasureKey", String.class)}).from(tempCIWarehouseItemTable).groupBy(new Expression[]{tempCIWarehouseItemTable.getColumn("sku", String.class), tempCIWarehouseItemTable.getColumn("unitOfMeasureKey", String.class)}).as("count_sku_uom")));
    }

    public void deleteCommerceInventoryWarehouseItems(long commerceInventoryWarehouseId) {
        this.commerceInventoryWarehouseItemPersistence.removeByCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
    }

    public void deleteCommerceInventoryWarehouseItems(long companyId, String sku, String unitOfMeasureKey) {
        this.commerceInventoryWarehouseItemPersistence.removeByC_S_U(companyId, sku, unitOfMeasureKey);
    }

    public void deleteCommerceInventoryWarehouseItemsByCompanyId(long companyId) {
        this.commerceInventoryWarehouseItemPersistence.removeByCompanyId(companyId);
    }

    public CommerceInventoryWarehouseItem fetchCommerceInventoryWarehouseItem(long commerceInventoryWarehouseId, String sku, String unitOfMeasureKey) {
        return this.commerceInventoryWarehouseItemPersistence.fetchByCIWI_S_U(commerceInventoryWarehouseId, sku, unitOfMeasureKey);
    }

    public CommerceInventoryWarehouseItem getCommerceInventoryWarehouseItem(long commerceInventoryWarehouseId, String sku, String unitOfMeasureKey) throws PortalException {
        return this.commerceInventoryWarehouseItemPersistence.findByCIWI_S_U(commerceInventoryWarehouseId, sku, unitOfMeasureKey);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItems(long commerceInventoryWarehouseId, int start, int end) {
        return this.commerceInventoryWarehouseItemPersistence.findByCommerceInventoryWarehouseId(commerceInventoryWarehouseId, start, end);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsByCompanyId(long companyId, int start, int end) {
        return this.commerceInventoryWarehouseItemPersistence.findByCompanyId(companyId, start, end);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsByCompanyIdSkuAndUnitOfMeasureKey(long companyId, String sku, String unitOfMeasureKey, int start, int end, boolean replacePermissionCheck) {
        DSLQuery dslQuery = DSLQueryFactoryUtil.select((Table)CommerceInventoryWarehouseItemTable.INSTANCE).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).leftJoinOn((Table)CommerceInventoryWarehouseTable.INSTANCE, CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId.eq((Expression)CommerceInventoryWarehouseTable.INSTANCE.commerceInventoryWarehouseId)).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.sku.eq((Object)sku)).and(() -> {
            if (Validator.isNull((String)unitOfMeasureKey)) {
                return null;
            }
            return CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey.eq((Object)unitOfMeasureKey);
        })).limit(start, end);
        if (replacePermissionCheck) {
            Column commerceInventoryWarehouseIdColumn = CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId;
            dslQuery = InlineSQLHelperUtil.replacePermissionCheck((DSLQuery)dslQuery, CommerceInventoryWarehouse.class, (Column)commerceInventoryWarehouseIdColumn, (long[])new long[]{0L});
        }
        return (List)this.dslQuery(dslQuery);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsByModifiedDate(long companyId, Date startDate, Date endDate, int start, int end) {
        return (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)CommerceInventoryWarehouseItemTable.INSTANCE).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.modifiedDate.gte((Object)startDate)).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.modifiedDate.lt((Object)endDate))).orderBy(new OrderByExpression[]{CommerceInventoryWarehouseItemTable.INSTANCE.sku.ascending(), CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey.ascending()}));
    }

    public int getCommerceInventoryWarehouseItemsCount(long commerceInventoryWarehouseId) {
        return this.commerceInventoryWarehouseItemPersistence.countByCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
    }

    public int getCommerceInventoryWarehouseItemsCount(long companyId, long groupId, String sku, String unitOfMeasureKey) {
        return this.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseItemId).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).innerJoinON((Table)CommerceChannelRelTable.INSTANCE, CommerceChannelRelTable.INSTANCE.classNameId.eq((Object)this._portal.getClassNameId(CommerceInventoryWarehouse.class.getName())).and((Expression)CommerceChannelRelTable.INSTANCE.classPK.eq((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId))).innerJoinON((Table)GroupTable.INSTANCE, GroupTable.INSTANCE.classNameId.eq((Object)this._portal.getClassNameId(CommerceChannel.class.getName())).and((Expression)GroupTable.INSTANCE.classPK.eq((Expression)CommerceChannelRelTable.INSTANCE.commerceChannelId))).innerJoinON((Table)CommerceInventoryWarehouseTable.INSTANCE, CommerceInventoryWarehouseTable.INSTANCE.commerceInventoryWarehouseId.eq((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId)).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.sku.eq((Object)sku)).and(() -> {
            if (Validator.isNull((String)unitOfMeasureKey)) {
                return null;
            }
            return CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey.eq((Object)unitOfMeasureKey);
        }).and((Expression)CommerceInventoryWarehouseTable.INSTANCE.active.eq((Object)true)).and((Expression)GroupTable.INSTANCE.groupId.eq((Object)groupId))));
    }

    public int getCommerceInventoryWarehouseItemsCount(long companyId, String sku, String unitOfMeasureKey, boolean replacePermissionCheck) {
        GroupByStep dslQuery = DSLQueryFactoryUtil.countDistinct((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseItemId).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).leftJoinOn((Table)CommerceInventoryWarehouseTable.INSTANCE, CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId.eq((Expression)CommerceInventoryWarehouseTable.INSTANCE.commerceInventoryWarehouseId)).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and(() -> {
            if (Validator.isNull((String)sku)) {
                return null;
            }
            return DSLFunctionFactoryUtil.lower((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.sku).like("%" + StringUtil.toLowerCase((String)sku) + "%");
        }).and(() -> {
            if (Validator.isNull((String)unitOfMeasureKey)) {
                return null;
            }
            return DSLFunctionFactoryUtil.lower((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey).like("%" + StringUtil.toLowerCase((String)unitOfMeasureKey) + "%");
        }));
        if (replacePermissionCheck) {
            Column commerceInventoryWarehouseIdColumn = CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId;
            dslQuery = InlineSQLHelperUtil.replacePermissionCheck((DSLQuery)dslQuery, CommerceInventoryWarehouse.class, (Column)commerceInventoryWarehouseIdColumn, (long[])new long[]{0L});
        }
        return this.dslQueryCount((DSLQuery)dslQuery);
    }

    public int getCommerceInventoryWarehouseItemsCountByCompanyId(long companyId) {
        return this.commerceInventoryWarehouseItemPersistence.countByCompanyId(companyId);
    }

    public int getCommerceInventoryWarehouseItemsCountByModifiedDate(long companyId, Date startDate, Date endDate) {
        return this.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseItemId).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.modifiedDate.gte((Object)startDate).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.modifiedDate.lt((Object)endDate)))));
    }

    public List<CIWarehouseItem> getItemsByCompanyId(long companyId, String sku, int start, int end, boolean replacePermissionCheck) {
        DSLQuery dslQuery = DSLQueryFactoryUtil.select((Expression[])new Expression[]{CommerceInventoryWarehouseItemTable.INSTANCE.sku, CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey, DSLFunctionFactoryUtil.sum((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.quantity).as("SUM_STOCK"), DSLFunctionFactoryUtil.min(BookedQuantityTable.INSTANCE.sumBookedColumn).as(BookedQuantityTable.INSTANCE.sumBookedColumn.getName()), DSLFunctionFactoryUtil.min(ReplenishmentQuantityTable.INSTANCE.sumAwaitingColumn).as(ReplenishmentQuantityTable.INSTANCE.sumAwaitingColumn.getName())}).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).leftJoinOn((Table)CommerceInventoryWarehouseTable.INSTANCE, CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId.eq((Expression)CommerceInventoryWarehouseTable.INSTANCE.commerceInventoryWarehouseId)).leftJoinOn((Table)BookedQuantityTable.INSTANCE.getQueryTable(companyId), CommerceInventoryWarehouseItemTable.INSTANCE.sku.eq(BookedQuantityTable.INSTANCE.skuColumn).and((Expression)Predicate.withParentheses((Predicate)CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey.eq(BookedQuantityTable.INSTANCE.unitOfMeasureKeyColumn).or((Expression)Predicate.withParentheses((Predicate)CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey.isNull().and((Expression)BookedQuantityTable.INSTANCE.unitOfMeasureKeyColumn.isNull())))))).leftJoinOn((Table)ReplenishmentQuantityTable.INSTANCE.getQueryTable(companyId), CommerceInventoryWarehouseItemTable.INSTANCE.sku.eq(ReplenishmentQuantityTable.INSTANCE.skuColumn).and((Expression)Predicate.withParentheses((Predicate)CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey.eq(ReplenishmentQuantityTable.INSTANCE.unitOfMeasureKeyColumn).or((Expression)Predicate.withParentheses((Predicate)CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey.isNull().and((Expression)ReplenishmentQuantityTable.INSTANCE.unitOfMeasureKeyColumn.isNull())))))).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and(() -> {
            if (Validator.isNull((String)sku)) {
                return null;
            }
            return DSLFunctionFactoryUtil.lower((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.sku).like("%" + StringUtil.toLowerCase((String)sku) + "%");
        })).groupBy(new Expression[]{CommerceInventoryWarehouseItemTable.INSTANCE.sku, CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey}).orderBy(new OrderByExpression[]{CommerceInventoryWarehouseItemTable.INSTANCE.sku.ascending(), CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey.ascending()}).limit(start, end);
        if (replacePermissionCheck) {
            Column commerceInventoryWarehouseIdColumn = CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId;
            dslQuery = InlineSQLHelperUtil.replacePermissionCheck((DSLQuery)dslQuery, CommerceInventoryWarehouse.class, (Column)commerceInventoryWarehouseIdColumn, (long[])new long[]{0L});
        }
        List sumStocks = (List)this.dslQuery(dslQuery);
        ArrayList<CIWarehouseItem> ciWarehouseItems = new ArrayList<CIWarehouseItem>();
        for (Object[] stock : sumStocks) {
            if (stock == null) continue;
            String skuCode = "";
            if (stock.length > 0 && stock[0] != null) {
                skuCode = (String)stock[0];
            }
            String unitOfMeasureKey = "";
            if (stock.length > 1 && stock[1] != null) {
                unitOfMeasureKey = (String)stock[1];
            }
            BigDecimal stockQuantity = BigDecimal.ZERO;
            if (stock.length > 2 && stock[2] != null) {
                stockQuantity = (BigDecimal)stock[2];
            }
            BigDecimal bookedQuantity = BigDecimal.ZERO;
            if (stock.length > 3 && stock[3] != null) {
                bookedQuantity = BigDecimalUtil.get((Object)stock[3], (BigDecimal)BigDecimal.ZERO);
            }
            BigDecimal replenishmentQuantity = BigDecimal.ZERO;
            if (stock.length > 4 && stock[4] != null) {
                replenishmentQuantity = BigDecimalUtil.get((Object)stock[4], (BigDecimal)BigDecimal.ZERO);
            }
            ciWarehouseItems.add(new CIWarehouseItem(skuCode, unitOfMeasureKey, bookedQuantity, replenishmentQuantity, stockQuantity));
        }
        return ciWarehouseItems;
    }

    public BigDecimal getStockQuantity(long companyId, long groupId, String sku, String unitOfMeasureKey) {
        Iterable iterable = (Iterable)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.sum((Expression)DSLFunctionFactoryUtil.subtract(this._getExpression(CommerceInventoryWarehouseItemTable.INSTANCE.quantity), this._getExpression(CommerceInventoryWarehouseItemTable.INSTANCE.reservedQuantity))).as("SUM_VALUE")}).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).innerJoinON((Table)CommerceChannelRelTable.INSTANCE, CommerceChannelRelTable.INSTANCE.classNameId.eq((Object)this._portal.getClassNameId(CommerceInventoryWarehouse.class.getName())).and((Expression)CommerceChannelRelTable.INSTANCE.classPK.eq((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId))).innerJoinON((Table)GroupTable.INSTANCE, GroupTable.INSTANCE.classNameId.eq((Object)this._portal.getClassNameId(CommerceChannel.class.getName())).and((Expression)GroupTable.INSTANCE.classPK.eq((Expression)CommerceChannelRelTable.INSTANCE.commerceChannelId))).innerJoinON((Table)CommerceInventoryWarehouseTable.INSTANCE, CommerceInventoryWarehouseTable.INSTANCE.commerceInventoryWarehouseId.eq((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId)).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.sku.eq((Object)sku)).and(() -> {
            if (Validator.isNull((String)unitOfMeasureKey)) {
                return null;
            }
            return CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey.eq((Object)unitOfMeasureKey);
        }).and((Expression)CommerceInventoryWarehouseTable.INSTANCE.active.eq((Object)true)).and((Expression)GroupTable.INSTANCE.groupId.eq((Object)groupId))));
        Iterator iterator = iterable.iterator();
        BigDecimal stockQuantity = (BigDecimal)iterator.next();
        if (stockQuantity == null) {
            return BigDecimal.ZERO;
        }
        return stockQuantity;
    }

    public BigDecimal getStockQuantity(long companyId, String sku, String unitOfMeasureKey) {
        Iterable iterable = (Iterable)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.sum((Expression)DSLFunctionFactoryUtil.subtract(this._getExpression(CommerceInventoryWarehouseItemTable.INSTANCE.quantity), this._getExpression(CommerceInventoryWarehouseItemTable.INSTANCE.reservedQuantity))).as("SUM_VALUE")}).from((Table)CommerceInventoryWarehouseItemTable.INSTANCE).innerJoinON((Table)CommerceInventoryWarehouseTable.INSTANCE, CommerceInventoryWarehouseTable.INSTANCE.commerceInventoryWarehouseId.eq((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.commerceInventoryWarehouseId)).where(CommerceInventoryWarehouseItemTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceInventoryWarehouseItemTable.INSTANCE.sku.eq((Object)sku)).and(() -> {
            if (Validator.isNull((String)unitOfMeasureKey)) {
                return null;
            }
            return CommerceInventoryWarehouseItemTable.INSTANCE.unitOfMeasureKey.eq((Object)unitOfMeasureKey);
        }).and((Expression)CommerceInventoryWarehouseTable.INSTANCE.active.eq((Object)true))));
        Iterator iterator = iterable.iterator();
        BigDecimal stockQuantity = (BigDecimal)iterator.next();
        if (stockQuantity == null) {
            return BigDecimal.ZERO;
        }
        return stockQuantity;
    }

    public CommerceInventoryWarehouseItem increaseCommerceInventoryWarehouseItemQuantity(long userId, long commerceInventoryWarehouseItemId, BigDecimal quantity) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByPrimaryKey(commerceInventoryWarehouseItemId);
        quantity = quantity.add(commerceInventoryWarehouseItem.getQuantity());
        commerceInventoryWarehouseItem.setQuantity(quantity);
        commerceInventoryWarehouseItem = (CommerceInventoryWarehouseItem)this.commerceInventoryWarehouseItemPersistence.update((BaseModel)commerceInventoryWarehouseItem);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("increase-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(null), quantity, commerceInventoryWarehouseItem.getSku(), commerceInventoryWarehouseItem.getUnitOfMeasureKey());
        return commerceInventoryWarehouseItem;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public void moveQuantitiesBetweenWarehouses(long userId, long fromCommerceInventoryWarehouseId, long toCommerceInventoryWarehouseId, BigDecimal quantity, String sku, String unitOfMeasureKey) throws PortalException {
        CommerceInventoryWarehouseItem fromWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByCIWI_S_U(fromCommerceInventoryWarehouseId, sku, unitOfMeasureKey);
        BigDecimal fromWarehouseItemQuantity = fromWarehouseItem.getQuantity();
        if (quantity.compareTo(fromWarehouseItemQuantity) == 1) {
            throw new PortalException("Quantity to transfer unavailable");
        }
        this.commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, fromWarehouseItem.getCommerceInventoryWarehouseItemId(), fromWarehouseItem.getMvccVersion(), fromWarehouseItemQuantity.subtract(quantity), fromWarehouseItem.getUnitOfMeasureKey());
        CommerceInventoryWarehouseItem toWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByCIWI_S_U(toCommerceInventoryWarehouseId, sku, unitOfMeasureKey);
        BigDecimal toWarehouseItemQuantity = toWarehouseItem.getQuantity();
        this.commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, toWarehouseItem.getCommerceInventoryWarehouseItemId(), toWarehouseItem.getMvccVersion(), toWarehouseItemQuantity.add(quantity), toWarehouseItem.getUnitOfMeasureKey());
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("move-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog((Map)HashMapBuilder.put((Object)"from", () -> {
            CommerceInventoryWarehouse fromCommerceInventoryWarehouse = fromWarehouseItem.getCommerceInventoryWarehouse();
            return String.valueOf(fromCommerceInventoryWarehouse.getName());
        }).put((Object)"to", () -> {
            CommerceInventoryWarehouse toCommerceInventoryWarehouse = toWarehouseItem.getCommerceInventoryWarehouse();
            return String.valueOf(toCommerceInventoryWarehouse.getName());
        }).build()), quantity, sku, unitOfMeasureKey);
    }

    public CommerceInventoryWarehouseItem updateCommerceInventoryWarehouseItem(long userId, long commerceInventoryWarehouseItemId, BigDecimal quantity, BigDecimal reservedQuantity, long mvccVersion) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByPrimaryKey(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem.getMvccVersion() != mvccVersion) {
            throw new MVCCException();
        }
        commerceInventoryWarehouseItem.setQuantity(quantity);
        commerceInventoryWarehouseItem.setReservedQuantity(reservedQuantity);
        commerceInventoryWarehouseItem = (CommerceInventoryWarehouseItem)this.commerceInventoryWarehouseItemPersistence.update((BaseModel)commerceInventoryWarehouseItem);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("update-warehouse-item");
        CommerceInventoryWarehouse commerceInventoryWarehouse = commerceInventoryWarehouseItem.getCommerceInventoryWarehouse();
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog((Map)HashMapBuilder.put((Object)"reserved", (Object)String.valueOf(reservedQuantity)).put((Object)"warehouse", (Object)String.valueOf(commerceInventoryWarehouse.getName())).build()), quantity, commerceInventoryWarehouseItem.getSku(), commerceInventoryWarehouseItem.getUnitOfMeasureKey());
        return commerceInventoryWarehouseItem;
    }

    public CommerceInventoryWarehouseItem updateCommerceInventoryWarehouseItem(long userId, long commerceInventoryWarehouseItemId, long mvccVersion, BigDecimal quantity, String unitOfMeasureKey) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByPrimaryKey(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem.getMvccVersion() != mvccVersion) {
            throw new MVCCException();
        }
        this._validateUnitOfMeasureKey(commerceInventoryWarehouseItem.getCompanyId(), commerceInventoryWarehouseItem.getSku(), unitOfMeasureKey);
        commerceInventoryWarehouseItem.setQuantity(quantity);
        commerceInventoryWarehouseItem.setUnitOfMeasureKey(this._normalizeUnitOfMeasureKey(commerceInventoryWarehouseItem.getCompanyId(), commerceInventoryWarehouseItem.getSku(), unitOfMeasureKey));
        commerceInventoryWarehouseItem = (CommerceInventoryWarehouseItem)this.commerceInventoryWarehouseItemPersistence.update((BaseModel)commerceInventoryWarehouseItem);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("update-warehouse-item");
        CommerceInventoryWarehouse commerceInventoryWarehouse = commerceInventoryWarehouseItem.getCommerceInventoryWarehouse();
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog((Map)HashMapBuilder.put((Object)"warehouse", (Object)String.valueOf(commerceInventoryWarehouse.getName())).build()), quantity, commerceInventoryWarehouseItem.getSku(), commerceInventoryWarehouseItem.getUnitOfMeasureKey());
        return commerceInventoryWarehouseItem;
    }

    private BigDecimal _getBigDecimal(Comparable<?> comparable) {
        if (comparable == null) {
            return BigDecimal.ZERO;
        }
        if (comparable instanceof BigDecimal) {
            return (BigDecimal)comparable;
        }
        String value = comparable.toString();
        if (Validator.isNull((String)value)) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(value);
    }

    private Expression<?> _getExpression(Object object) {
        if (object instanceof BigDecimal) {
            object = this._getBigDecimal((Comparable)object);
        } else if (object instanceof Expression) {
            return (Expression)object;
        }
        return new Scalar(object);
    }

    private String _normalizeUnitOfMeasureKey(long companyId, String sku, String unitOfMeasureKey) throws PortalException {
        List cpInstanceUnitOfMeasures = this._cpInstanceUnitOfMeasureLocalService.getCPInstanceUnitOfMeasures(companyId, sku);
        if (Validator.isNull((String)unitOfMeasureKey) && cpInstanceUnitOfMeasures.size() == 1) {
            CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure = (CPInstanceUnitOfMeasure)cpInstanceUnitOfMeasures.get(0);
            return cpInstanceUnitOfMeasure.getKey();
        }
        return unitOfMeasureKey;
    }

    private void _validateSku(long commerceInventoryWarehouseId, String sku, String unitOfMeasureKey) throws PortalException {
        if (Validator.isNull((String)sku)) {
            throw new CommerceInventoryWarehouseItemSkuException();
        }
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.fetchByCIWI_S_U(commerceInventoryWarehouseId, sku, unitOfMeasureKey);
        if (commerceInventoryWarehouseItem != null) {
            throw new DuplicateCommerceInventoryWarehouseItemException();
        }
    }

    private void _validateUnitOfMeasureKey(long companyId, String sku, String unitOfMeasureKey) throws PortalException {
        int cpInstanceUnitOfMeasuresCount = this._cpInstanceUnitOfMeasureLocalService.getCPInstanceUnitOfMeasuresCount(companyId, sku);
        if (Validator.isNull((String)unitOfMeasureKey)) {
            if (cpInstanceUnitOfMeasuresCount == 1) {
                return;
            }
            if (cpInstanceUnitOfMeasuresCount > 0) {
                throw new CPInstanceUnitOfMeasureKeyException();
            }
        } else {
            if (cpInstanceUnitOfMeasuresCount == 0) {
                List cpInstances = this._cpInstanceLocalService.getCPInstances(companyId, sku);
                if (cpInstances.isEmpty()) {
                    return;
                }
                throw new NoSuchCPInstanceUnitOfMeasureException();
            }
            List cpInstanceUnitOfMeasures = this._cpInstanceUnitOfMeasureLocalService.getCPInstanceUnitOfMeasures(companyId, sku);
            for (CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure : cpInstanceUnitOfMeasures) {
                if (!unitOfMeasureKey.equals(cpInstanceUnitOfMeasure.getKey())) continue;
                return;
            }
            throw new NoSuchCPInstanceUnitOfMeasureException();
        }
    }

    private static class ReplenishmentQuantityTable
    extends BaseTable<ReplenishmentQuantityTable> {
        public static final ReplenishmentQuantityTable INSTANCE = new ReplenishmentQuantityTable();
        public final Column<ReplenishmentQuantityTable, String> skuColumn = this.createColumn("SKU", String.class, 12, 0);
        public final Column<ReplenishmentQuantityTable, BigDecimal> sumAwaitingColumn = this.createColumn("SUM_AWAITING", BigDecimal.class, 3, 0);
        public final Column<ReplenishmentQuantityTable, String> unitOfMeasureKeyColumn = this.createColumn("UNIT_OF_MEASURE_KEY", String.class, 12, 0);

        public QueryTable getQueryTable(long companyId) {
            return new QueryTable(INSTANCE.getTableName(), (DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{CommerceInventoryReplenishmentItemTable.INSTANCE.sku.as(this.skuColumn.getName()), CommerceInventoryReplenishmentItemTable.INSTANCE.unitOfMeasureKey.as(this.unitOfMeasureKeyColumn.getName()), DSLFunctionFactoryUtil.sum((Expression)CommerceInventoryReplenishmentItemTable.INSTANCE.quantity).as(this.sumAwaitingColumn.getName())}).from((Table)CommerceInventoryReplenishmentItemTable.INSTANCE).where(CommerceInventoryReplenishmentItemTable.INSTANCE.companyId.eq((Object)companyId)).groupBy(new Expression[]{CommerceInventoryReplenishmentItemTable.INSTANCE.sku, CommerceInventoryReplenishmentItemTable.INSTANCE.unitOfMeasureKey}), Arrays.asList(this.skuColumn, this.unitOfMeasureKeyColumn, this.sumAwaitingColumn));
        }

        private ReplenishmentQuantityTable() {
            super("ReplenishmentQuantityTable", ReplenishmentQuantityTable::new);
        }
    }

    private static class BookedQuantityTable
    extends BaseTable<BookedQuantityTable> {
        public static final BookedQuantityTable INSTANCE = new BookedQuantityTable();
        public final Column<BookedQuantityTable, String> skuColumn = this.createColumn("SKU", String.class, 12, 0);
        public final Column<BookedQuantityTable, BigDecimal> sumBookedColumn = this.createColumn("SUM_BOOKED", BigDecimal.class, 3, 0);
        public final Column<BookedQuantityTable, String> unitOfMeasureKeyColumn = this.createColumn("UNIT_OF_MEASURE_KEY", String.class, 12, 0);

        public QueryTable getQueryTable(long companyId) {
            return new QueryTable(INSTANCE.getTableName(), (DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{CommerceInventoryBookedQuantityTable.INSTANCE.sku.as(this.skuColumn.getName()), CommerceInventoryBookedQuantityTable.INSTANCE.unitOfMeasureKey.as(this.unitOfMeasureKeyColumn.getName()), DSLFunctionFactoryUtil.sum((Expression)CommerceInventoryBookedQuantityTable.INSTANCE.quantity).as(this.sumBookedColumn.getName())}).from((Table)CommerceInventoryBookedQuantityTable.INSTANCE).where(CommerceInventoryBookedQuantityTable.INSTANCE.companyId.eq((Object)companyId)).groupBy(new Expression[]{CommerceInventoryBookedQuantityTable.INSTANCE.sku, CommerceInventoryBookedQuantityTable.INSTANCE.unitOfMeasureKey}), Arrays.asList(this.skuColumn, this.unitOfMeasureKeyColumn, this.sumBookedColumn));
        }

        private BookedQuantityTable() {
            super("BookedQuantityTable", BookedQuantityTable::new);
        }
    }
}

