/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.media.internal;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPAttachmentFileEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceMediaResolver.class})
public class DefaultCommerceMediaResolver
implements CommerceMediaResolver {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private CommerceProductViewPermission _commerceProductViewPermission;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CPAttachmentFileEntryLocalService _cpAttachmentFileEntryLocalService;
    @Reference
    private Portal _portal;

    public String getDefaultURL(long groupId) {
        StringBundler sb = new StringBundler(5);
        sb.append(this._portal.getPathModule());
        sb.append("/");
        sb.append("commerce-media");
        sb.append("/default/?groupId=");
        sb.append(groupId);
        return sb.toString();
    }

    public String getDownloadURL(long commerceAccountId, long cpAttachmentFileEntryId) throws PortalException {
        return this.getURL(commerceAccountId, cpAttachmentFileEntryId, true, false);
    }

    public String getThumbnailURL(long commerceAccountId, long cpAttachmentFileEntryId) throws PortalException {
        return this.getURL(commerceAccountId, cpAttachmentFileEntryId, false, true);
    }

    public String getURL(long commerceAccountId, long cpAttachmentFileEntryId) throws PortalException {
        return this.getURL(commerceAccountId, cpAttachmentFileEntryId, false, false);
    }

    public String getURL(long commerceAccountId, long cpAttachmentFileEntryId, boolean download, boolean thumbnail) throws PortalException {
        return this.getURL(commerceAccountId, cpAttachmentFileEntryId, download, thumbnail, true);
    }

    public String getURL(long commerceAccountId, long cpAttachmentFileEntryId, boolean download, boolean thumbnail, boolean secure) throws PortalException {
        StringBundler sb = new StringBundler(9);
        sb.append(this._portal.getPathModule());
        sb.append("/");
        sb.append("commerce-media");
        CPAttachmentFileEntry cpAttachmentFileEntry = this._cpAttachmentFileEntryLocalService.fetchCPAttachmentFileEntry(cpAttachmentFileEntryId);
        if (cpAttachmentFileEntry == null) {
            HttpSession httpSession = PortalSessionThreadLocal.getHttpSession();
            if (httpSession == null) {
                return sb.toString();
            }
            long companyId = GetterUtil.getLong((Object)httpSession.getAttribute("COMPANY_ID"));
            Company company = this._companyLocalService.getCompany(companyId);
            return this.getDefaultURL(company.getGroupId());
        }
        if (secure) {
            String className = cpAttachmentFileEntry.getClassName();
            if (className.equals(AssetCategory.class.getName())) {
                AssetCategory assetCategory = this._assetCategoryLocalService.fetchCategory(cpAttachmentFileEntry.getClassPK());
                AssetCategoryPermission.check((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (AssetCategory)assetCategory, (String)"VIEW");
            } else if (className.equals(CPDefinition.class.getName())) {
                this._commerceProductViewPermission.check(PermissionThreadLocal.getPermissionChecker(), commerceAccountId, cpAttachmentFileEntry.getClassPK());
            }
        }
        sb.append("/accounts/");
        sb.append(commerceAccountId);
        if (cpAttachmentFileEntry.getType() == 0) {
            sb.append("/images/");
        } else if (cpAttachmentFileEntry.getType() == 1) {
            sb.append("/attachments/");
        }
        sb.append(cpAttachmentFileEntry.getCPAttachmentFileEntryId());
        sb.append("?download=");
        sb.append(download);
        return sb.toString();
    }
}

