/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.order.web.internal.constants;

import com.liferay.commerce.constants.CommercePortletKeys;

/**
 * @author Marco Leo
 * @author Alessio Antonio Rendina
 */
public class CommerceOrderFDSNames {

	public static final String ALL_ORDERS =
		CommercePortletKeys.COMMERCE_ORDER + "-allOrders";

	public static final String BILLING_ADDRESSES =
		CommercePortletKeys.COMMERCE_ORDER + "-billingAddresses";

	public static final String COMPLETED_ORDERS =
		CommercePortletKeys.COMMERCE_ORDER + "-completedOrders";

	public static final String NOTIFICATIONS =
		CommercePortletKeys.COMMERCE_ORDER + "-notifications";

	public static final String OPEN_ORDERS =
		CommercePortletKeys.COMMERCE_ORDER + "-openOrders";

	public static final String ORDER_ITEMS =
		CommercePortletKeys.COMMERCE_ORDER + "-orderItems";

	public static final String ORDER_TYPE_QUALIFIER_CHANNELS =
		CommercePortletKeys.COMMERCE_ORDER_TYPE + "-orderTypeQualifierChannels";

	public static final String ORDER_TYPES =
		CommercePortletKeys.COMMERCE_ORDER_TYPE + "-orderTypes";

	public static final String PAYMENT_METHODS =
		CommercePortletKeys.COMMERCE_ORDER + "-paymentMethods";

	public static final String PAYMENTS =
		CommercePortletKeys.COMMERCE_ORDER + "-payments";

	public static final String PENDING_ORDERS =
		CommercePortletKeys.COMMERCE_ORDER + "-pendingOrders";

	public static final String PROCESSING_ORDERS =
		CommercePortletKeys.COMMERCE_ORDER + "-processingOrders";

	public static final String SHIPPING_ADDRESSES =
		CommercePortletKeys.COMMERCE_ORDER + "-shippingAddresses";

}