/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.price.list.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CommercePriceListChannelRel service. Represents a row in the &quot;CommercePriceListChannelRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.price.list.model.impl.CommercePriceListChannelRelModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.price.list.model.impl.CommercePriceListChannelRelImpl</code>.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommercePriceListChannelRel
 * @generated
 */
@ProviderType
public interface CommercePriceListChannelRelModel
	extends BaseModel<CommercePriceListChannelRel>,
			CTModel<CommercePriceListChannelRel>, MVCCModel, ShardedModel,
			StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce price list channel rel model instance should use the {@link CommercePriceListChannelRel} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce price list channel rel.
	 *
	 * @return the primary key of this commerce price list channel rel
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce price list channel rel.
	 *
	 * @param primaryKey the primary key of this commerce price list channel rel
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this commerce price list channel rel.
	 *
	 * @return the mvcc version of this commerce price list channel rel
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this commerce price list channel rel.
	 *
	 * @param mvccVersion the mvcc version of this commerce price list channel rel
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this commerce price list channel rel.
	 *
	 * @return the ct collection ID of this commerce price list channel rel
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this commerce price list channel rel.
	 *
	 * @param ctCollectionId the ct collection ID of this commerce price list channel rel
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the uuid of this commerce price list channel rel.
	 *
	 * @return the uuid of this commerce price list channel rel
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this commerce price list channel rel.
	 *
	 * @param uuid the uuid of this commerce price list channel rel
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the commerce price list channel rel ID of this commerce price list channel rel.
	 *
	 * @return the commerce price list channel rel ID of this commerce price list channel rel
	 */
	public long getCommercePriceListChannelRelId();

	/**
	 * Sets the commerce price list channel rel ID of this commerce price list channel rel.
	 *
	 * @param CommercePriceListChannelRelId the commerce price list channel rel ID of this commerce price list channel rel
	 */
	public void setCommercePriceListChannelRelId(
		long CommercePriceListChannelRelId);

	/**
	 * Returns the company ID of this commerce price list channel rel.
	 *
	 * @return the company ID of this commerce price list channel rel
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce price list channel rel.
	 *
	 * @param companyId the company ID of this commerce price list channel rel
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce price list channel rel.
	 *
	 * @return the user ID of this commerce price list channel rel
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce price list channel rel.
	 *
	 * @param userId the user ID of this commerce price list channel rel
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce price list channel rel.
	 *
	 * @return the user uuid of this commerce price list channel rel
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce price list channel rel.
	 *
	 * @param userUuid the user uuid of this commerce price list channel rel
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce price list channel rel.
	 *
	 * @return the user name of this commerce price list channel rel
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce price list channel rel.
	 *
	 * @param userName the user name of this commerce price list channel rel
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce price list channel rel.
	 *
	 * @return the create date of this commerce price list channel rel
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce price list channel rel.
	 *
	 * @param createDate the create date of this commerce price list channel rel
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce price list channel rel.
	 *
	 * @return the modified date of this commerce price list channel rel
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce price list channel rel.
	 *
	 * @param modifiedDate the modified date of this commerce price list channel rel
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the commerce channel ID of this commerce price list channel rel.
	 *
	 * @return the commerce channel ID of this commerce price list channel rel
	 */
	public long getCommerceChannelId();

	/**
	 * Sets the commerce channel ID of this commerce price list channel rel.
	 *
	 * @param commerceChannelId the commerce channel ID of this commerce price list channel rel
	 */
	public void setCommerceChannelId(long commerceChannelId);

	/**
	 * Returns the commerce price list ID of this commerce price list channel rel.
	 *
	 * @return the commerce price list ID of this commerce price list channel rel
	 */
	public long getCommercePriceListId();

	/**
	 * Sets the commerce price list ID of this commerce price list channel rel.
	 *
	 * @param commercePriceListId the commerce price list ID of this commerce price list channel rel
	 */
	public void setCommercePriceListId(long commercePriceListId);

	/**
	 * Returns the order of this commerce price list channel rel.
	 *
	 * @return the order of this commerce price list channel rel
	 */
	public int getOrder();

	/**
	 * Sets the order of this commerce price list channel rel.
	 *
	 * @param order the order of this commerce price list channel rel
	 */
	public void setOrder(int order);

	/**
	 * Returns the last publish date of this commerce price list channel rel.
	 *
	 * @return the last publish date of this commerce price list channel rel
	 */
	public Date getLastPublishDate();

	/**
	 * Sets the last publish date of this commerce price list channel rel.
	 *
	 * @param lastPublishDate the last publish date of this commerce price list channel rel
	 */
	public void setLastPublishDate(Date lastPublishDate);

	@Override
	public CommercePriceListChannelRel cloneWithOriginalValues();

}