/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.display.context;

import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.portlet.action.CommercePriceListActionHelper;
import com.liferay.commerce.product.display.context.helper.CPRequestHelper;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseCommercePriceListDisplayContext<T> {
    protected final CommercePriceListActionHelper commercePriceListActionHelper;
    protected final ModelResourcePermission<CommercePriceList> commercePriceListModelResourcePermission;
    protected final HttpServletRequest httpServletRequest;
    protected final LiferayPortletRequest liferayPortletRequest;
    protected final LiferayPortletResponse liferayPortletResponse;
    protected SearchContainer<T> searchContainer;
    private CommercePriceList _commercePriceList;
    private final CPRequestHelper _cpRequestHelper;
    private String _defaultOrderByCol;
    private String _defaultOrderByType;
    private String _keywords;
    private RowChecker _rowChecker;

    public BaseCommercePriceListDisplayContext(CommercePriceListActionHelper commercePriceListActionHelper, ModelResourcePermission<CommercePriceList> commercePriceListModelResourcePermission, HttpServletRequest httpServletRequest) {
        this.commercePriceListActionHelper = commercePriceListActionHelper;
        this.commercePriceListModelResourcePermission = commercePriceListModelResourcePermission;
        this.httpServletRequest = httpServletRequest;
        this._cpRequestHelper = new CPRequestHelper(httpServletRequest);
        this.liferayPortletRequest = this._cpRequestHelper.getLiferayPortletRequest();
        this.liferayPortletResponse = this._cpRequestHelper.getLiferayPortletResponse();
        this._defaultOrderByCol = "create-date";
        this._defaultOrderByType = "desc";
    }

    public CommercePriceList getCommercePriceList() throws PortalException {
        if (this._commercePriceList != null) {
            return this._commercePriceList;
        }
        this._commercePriceList = this.commercePriceListActionHelper.getCommercePriceList((PortletRequest)this.liferayPortletRequest);
        return this._commercePriceList;
    }

    public long getCommercePriceListId() throws PortalException {
        CommercePriceList commercePriceList = this.getCommercePriceList();
        if (commercePriceList == null) {
            return 0L;
        }
        return commercePriceList.getCommercePriceListId();
    }

    public String getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"keywords");
        return this._keywords;
    }

    public String getOrderByCol() {
        return ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"orderByCol", (String)this._defaultOrderByCol);
    }

    public String getOrderByType() {
        return ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"orderByType", (String)this._defaultOrderByType);
    }

    public PortletURL getPortletURL() throws PortalException {
        String redirect;
        String orderByType;
        String orderByCol;
        String keywords;
        String deltaEntry;
        String delta;
        PortletURL portletURL = this.liferayPortletResponse.createRenderURL();
        CommercePriceList commercePriceList = this.getCommercePriceList();
        if (commercePriceList != null) {
            portletURL.setParameter("mvcRenderCommandName", "/commerce_price_list/edit_commerce_price_list");
            portletURL.setParameter("commercePriceListId", String.valueOf(this.getCommercePriceListId()));
        }
        if (Validator.isNotNull((String)(delta = ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"delta")))) {
            portletURL.setParameter("delta", delta);
        }
        if (Validator.isNotNull((String)(deltaEntry = ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"deltaEntry")))) {
            portletURL.setParameter("deltaEntry", deltaEntry);
        }
        if (Validator.isNotNull((String)(keywords = ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"keywords")))) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        if (Validator.isNotNull((String)(redirect = ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"redirect")))) {
            portletURL.setParameter("redirect", redirect);
        }
        return portletURL;
    }

    public RowChecker getRowChecker() {
        if (this._rowChecker == null) {
            this._rowChecker = new EmptyOnClickRowChecker((PortletResponse)this.liferayPortletResponse);
        }
        return this._rowChecker;
    }

    public String getScreenNavigationCategoryKey() {
        return "details";
    }

    public abstract SearchContainer<T> getSearchContainer() throws PortalException;

    public boolean hasPermission(long commercePriceListId, String actionId) throws PortalException {
        return this.commercePriceListModelResourcePermission.contains(this._cpRequestHelper.getPermissionChecker(), commercePriceListId, actionId);
    }

    public boolean hasPermission(String actionId) {
        PortletResourcePermission portletResourcePermission = this.commercePriceListModelResourcePermission.getPortletResourcePermission();
        return portletResourcePermission.contains(this._cpRequestHelper.getPermissionChecker(), null, actionId);
    }

    public boolean isSearch() {
        return Validator.isNotNull((String)this.getKeywords());
    }

    public boolean isShowInfoPanel() {
        return !this.isSearch();
    }

    public void setDefaultOrderByCol(String defaultOrderByCol) {
        this._defaultOrderByCol = defaultOrderByCol;
    }

    public void setDefaultOrderByType(String defaultOrderByType) {
        this._defaultOrderByType = defaultOrderByType;
    }

    protected String getNavigation() {
        return ParamUtil.getString((HttpServletRequest)this.httpServletRequest, (String)"navigation");
    }
}

