/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.price.list.model.impl;

import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceEntryModel;
import com.liferay.commerce.price.list.model.CommercePriceEntrySoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommercePriceEntry service. Represents a row in the &quot;CommercePriceEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommercePriceEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommercePriceEntryImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommercePriceEntryImpl
 * @generated
 */
@JSON(strict = true)
public class CommercePriceEntryModelImpl
	extends BaseModelImpl<CommercePriceEntry>
	implements CommercePriceEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce price entry model instance should use the <code>CommercePriceEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommercePriceEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"uuid_", Types.VARCHAR}, {"externalReferenceCode", Types.VARCHAR},
		{"commercePriceEntryId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"commercePriceListId", Types.BIGINT},
		{"CPInstanceUuid", Types.VARCHAR}, {"CProductId", Types.BIGINT},
		{"price", Types.DECIMAL}, {"promoPrice", Types.DECIMAL},
		{"discountDiscovery", Types.BOOLEAN}, {"discountLevel1", Types.DECIMAL},
		{"discountLevel2", Types.DECIMAL}, {"discountLevel3", Types.DECIMAL},
		{"discountLevel4", Types.DECIMAL}, {"hasTierPrice", Types.BOOLEAN},
		{"bulkPricing", Types.BOOLEAN}, {"displayDate", Types.TIMESTAMP},
		{"expirationDate", Types.TIMESTAMP},
		{"lastPublishDate", Types.TIMESTAMP}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commercePriceEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commercePriceListId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CPInstanceUuid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("CProductId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("price", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("promoPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountDiscovery", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("discountLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("hasTierPrice", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("bulkPricing", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("displayDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommercePriceEntry (uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,commercePriceEntryId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commercePriceListId LONG,CPInstanceUuid VARCHAR(75) null,CProductId LONG,price DECIMAL(30, 16) null,promoPrice DECIMAL(30, 16) null,discountDiscovery BOOLEAN,discountLevel1 DECIMAL(30, 16) null,discountLevel2 DECIMAL(30, 16) null,discountLevel3 DECIMAL(30, 16) null,discountLevel4 DECIMAL(30, 16) null,hasTierPrice BOOLEAN,bulkPricing BOOLEAN,displayDate DATE null,expirationDate DATE null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table CommercePriceEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commercePriceEntry.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommercePriceEntry.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CPINSTANCEUUID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCEPRICELISTID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DISPLAYDATE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXPIRATIONDATE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 256L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static CommercePriceEntry toModel(CommercePriceEntrySoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommercePriceEntry model = new CommercePriceEntryImpl();

		model.setUuid(soapModel.getUuid());
		model.setExternalReferenceCode(soapModel.getExternalReferenceCode());
		model.setCommercePriceEntryId(soapModel.getCommercePriceEntryId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCommercePriceListId(soapModel.getCommercePriceListId());
		model.setCPInstanceUuid(soapModel.getCPInstanceUuid());
		model.setCProductId(soapModel.getCProductId());
		model.setPrice(soapModel.getPrice());
		model.setPromoPrice(soapModel.getPromoPrice());
		model.setDiscountDiscovery(soapModel.isDiscountDiscovery());
		model.setDiscountLevel1(soapModel.getDiscountLevel1());
		model.setDiscountLevel2(soapModel.getDiscountLevel2());
		model.setDiscountLevel3(soapModel.getDiscountLevel3());
		model.setDiscountLevel4(soapModel.getDiscountLevel4());
		model.setHasTierPrice(soapModel.isHasTierPrice());
		model.setBulkPricing(soapModel.isBulkPricing());
		model.setDisplayDate(soapModel.getDisplayDate());
		model.setExpirationDate(soapModel.getExpirationDate());
		model.setLastPublishDate(soapModel.getLastPublishDate());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<CommercePriceEntry> toModels(
		CommercePriceEntrySoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommercePriceEntry> models = new ArrayList<CommercePriceEntry>(
			soapModels.length);

		for (CommercePriceEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.price.list.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.price.list.model.CommercePriceEntry"));

	public CommercePriceEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commercePriceEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommercePriceEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commercePriceEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommercePriceEntry.class;
	}

	@Override
	public String getModelClassName() {
		return CommercePriceEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommercePriceEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommercePriceEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommercePriceEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommercePriceEntry)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommercePriceEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommercePriceEntry, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommercePriceEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommercePriceEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommercePriceEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, CommercePriceEntry>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			CommercePriceEntry.class.getClassLoader(), CommercePriceEntry.class,
			ModelWrapper.class);

		try {
			Constructor<CommercePriceEntry> constructor =
				(Constructor<CommercePriceEntry>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<CommercePriceEntry, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<CommercePriceEntry, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommercePriceEntry, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<CommercePriceEntry, Object>>();
		Map<String, BiConsumer<CommercePriceEntry, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<CommercePriceEntry, ?>>();

		attributeGetterFunctions.put("uuid", CommercePriceEntry::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<CommercePriceEntry, String>)
				CommercePriceEntry::setUuid);
		attributeGetterFunctions.put(
			"externalReferenceCode",
			CommercePriceEntry::getExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<CommercePriceEntry, String>)
				CommercePriceEntry::setExternalReferenceCode);
		attributeGetterFunctions.put(
			"commercePriceEntryId",
			CommercePriceEntry::getCommercePriceEntryId);
		attributeSetterBiConsumers.put(
			"commercePriceEntryId",
			(BiConsumer<CommercePriceEntry, Long>)
				CommercePriceEntry::setCommercePriceEntryId);
		attributeGetterFunctions.put(
			"companyId", CommercePriceEntry::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommercePriceEntry, Long>)
				CommercePriceEntry::setCompanyId);
		attributeGetterFunctions.put("userId", CommercePriceEntry::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommercePriceEntry, Long>)
				CommercePriceEntry::setUserId);
		attributeGetterFunctions.put(
			"userName", CommercePriceEntry::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommercePriceEntry, String>)
				CommercePriceEntry::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommercePriceEntry::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommercePriceEntry, Date>)
				CommercePriceEntry::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommercePriceEntry::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommercePriceEntry, Date>)
				CommercePriceEntry::setModifiedDate);
		attributeGetterFunctions.put(
			"commercePriceListId", CommercePriceEntry::getCommercePriceListId);
		attributeSetterBiConsumers.put(
			"commercePriceListId",
			(BiConsumer<CommercePriceEntry, Long>)
				CommercePriceEntry::setCommercePriceListId);
		attributeGetterFunctions.put(
			"CPInstanceUuid", CommercePriceEntry::getCPInstanceUuid);
		attributeSetterBiConsumers.put(
			"CPInstanceUuid",
			(BiConsumer<CommercePriceEntry, String>)
				CommercePriceEntry::setCPInstanceUuid);
		attributeGetterFunctions.put(
			"CProductId", CommercePriceEntry::getCProductId);
		attributeSetterBiConsumers.put(
			"CProductId",
			(BiConsumer<CommercePriceEntry, Long>)
				CommercePriceEntry::setCProductId);
		attributeGetterFunctions.put("price", CommercePriceEntry::getPrice);
		attributeSetterBiConsumers.put(
			"price",
			(BiConsumer<CommercePriceEntry, BigDecimal>)
				CommercePriceEntry::setPrice);
		attributeGetterFunctions.put(
			"promoPrice", CommercePriceEntry::getPromoPrice);
		attributeSetterBiConsumers.put(
			"promoPrice",
			(BiConsumer<CommercePriceEntry, BigDecimal>)
				CommercePriceEntry::setPromoPrice);
		attributeGetterFunctions.put(
			"discountDiscovery", CommercePriceEntry::getDiscountDiscovery);
		attributeSetterBiConsumers.put(
			"discountDiscovery",
			(BiConsumer<CommercePriceEntry, Boolean>)
				CommercePriceEntry::setDiscountDiscovery);
		attributeGetterFunctions.put(
			"discountLevel1", CommercePriceEntry::getDiscountLevel1);
		attributeSetterBiConsumers.put(
			"discountLevel1",
			(BiConsumer<CommercePriceEntry, BigDecimal>)
				CommercePriceEntry::setDiscountLevel1);
		attributeGetterFunctions.put(
			"discountLevel2", CommercePriceEntry::getDiscountLevel2);
		attributeSetterBiConsumers.put(
			"discountLevel2",
			(BiConsumer<CommercePriceEntry, BigDecimal>)
				CommercePriceEntry::setDiscountLevel2);
		attributeGetterFunctions.put(
			"discountLevel3", CommercePriceEntry::getDiscountLevel3);
		attributeSetterBiConsumers.put(
			"discountLevel3",
			(BiConsumer<CommercePriceEntry, BigDecimal>)
				CommercePriceEntry::setDiscountLevel3);
		attributeGetterFunctions.put(
			"discountLevel4", CommercePriceEntry::getDiscountLevel4);
		attributeSetterBiConsumers.put(
			"discountLevel4",
			(BiConsumer<CommercePriceEntry, BigDecimal>)
				CommercePriceEntry::setDiscountLevel4);
		attributeGetterFunctions.put(
			"hasTierPrice", CommercePriceEntry::getHasTierPrice);
		attributeSetterBiConsumers.put(
			"hasTierPrice",
			(BiConsumer<CommercePriceEntry, Boolean>)
				CommercePriceEntry::setHasTierPrice);
		attributeGetterFunctions.put(
			"bulkPricing", CommercePriceEntry::getBulkPricing);
		attributeSetterBiConsumers.put(
			"bulkPricing",
			(BiConsumer<CommercePriceEntry, Boolean>)
				CommercePriceEntry::setBulkPricing);
		attributeGetterFunctions.put(
			"displayDate", CommercePriceEntry::getDisplayDate);
		attributeSetterBiConsumers.put(
			"displayDate",
			(BiConsumer<CommercePriceEntry, Date>)
				CommercePriceEntry::setDisplayDate);
		attributeGetterFunctions.put(
			"expirationDate", CommercePriceEntry::getExpirationDate);
		attributeSetterBiConsumers.put(
			"expirationDate",
			(BiConsumer<CommercePriceEntry, Date>)
				CommercePriceEntry::setExpirationDate);
		attributeGetterFunctions.put(
			"lastPublishDate", CommercePriceEntry::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<CommercePriceEntry, Date>)
				CommercePriceEntry::setLastPublishDate);
		attributeGetterFunctions.put("status", CommercePriceEntry::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<CommercePriceEntry, Integer>)
				CommercePriceEntry::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", CommercePriceEntry::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<CommercePriceEntry, Long>)
				CommercePriceEntry::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", CommercePriceEntry::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<CommercePriceEntry, String>)
				CommercePriceEntry::setStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", CommercePriceEntry::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<CommercePriceEntry, Date>)
				CommercePriceEntry::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getCommercePriceEntryId() {
		return _commercePriceEntryId;
	}

	@Override
	public void setCommercePriceEntryId(long commercePriceEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commercePriceEntryId = commercePriceEntryId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommercePriceListId() {
		return _commercePriceListId;
	}

	@Override
	public void setCommercePriceListId(long commercePriceListId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commercePriceListId = commercePriceListId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommercePriceListId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commercePriceListId"));
	}

	@JSON
	@Override
	public String getCPInstanceUuid() {
		if (_CPInstanceUuid == null) {
			return "";
		}
		else {
			return _CPInstanceUuid;
		}
	}

	@Override
	public void setCPInstanceUuid(String CPInstanceUuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_CPInstanceUuid = CPInstanceUuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalCPInstanceUuid() {
		return getColumnOriginalValue("CPInstanceUuid");
	}

	@JSON
	@Override
	public long getCProductId() {
		return _CProductId;
	}

	@Override
	public void setCProductId(long CProductId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_CProductId = CProductId;
	}

	@JSON
	@Override
	public BigDecimal getPrice() {
		return _price;
	}

	@Override
	public void setPrice(BigDecimal price) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_price = price;
	}

	@JSON
	@Override
	public BigDecimal getPromoPrice() {
		return _promoPrice;
	}

	@Override
	public void setPromoPrice(BigDecimal promoPrice) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_promoPrice = promoPrice;
	}

	@JSON
	@Override
	public boolean getDiscountDiscovery() {
		return _discountDiscovery;
	}

	@JSON
	@Override
	public boolean isDiscountDiscovery() {
		return _discountDiscovery;
	}

	@Override
	public void setDiscountDiscovery(boolean discountDiscovery) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountDiscovery = discountDiscovery;
	}

	@JSON
	@Override
	public BigDecimal getDiscountLevel1() {
		return _discountLevel1;
	}

	@Override
	public void setDiscountLevel1(BigDecimal discountLevel1) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountLevel1 = discountLevel1;
	}

	@JSON
	@Override
	public BigDecimal getDiscountLevel2() {
		return _discountLevel2;
	}

	@Override
	public void setDiscountLevel2(BigDecimal discountLevel2) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountLevel2 = discountLevel2;
	}

	@JSON
	@Override
	public BigDecimal getDiscountLevel3() {
		return _discountLevel3;
	}

	@Override
	public void setDiscountLevel3(BigDecimal discountLevel3) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountLevel3 = discountLevel3;
	}

	@JSON
	@Override
	public BigDecimal getDiscountLevel4() {
		return _discountLevel4;
	}

	@Override
	public void setDiscountLevel4(BigDecimal discountLevel4) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountLevel4 = discountLevel4;
	}

	@JSON
	@Override
	public boolean getHasTierPrice() {
		return _hasTierPrice;
	}

	@JSON
	@Override
	public boolean isHasTierPrice() {
		return _hasTierPrice;
	}

	@Override
	public void setHasTierPrice(boolean hasTierPrice) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_hasTierPrice = hasTierPrice;
	}

	@JSON
	@Override
	public boolean getBulkPricing() {
		return _bulkPricing;
	}

	@JSON
	@Override
	public boolean isBulkPricing() {
		return _bulkPricing;
	}

	@Override
	public void setBulkPricing(boolean bulkPricing) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_bulkPricing = bulkPricing;
	}

	@JSON
	@Override
	public Date getDisplayDate() {
		return _displayDate;
	}

	@Override
	public void setDisplayDate(Date displayDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_displayDate = displayDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalDisplayDate() {
		return getColumnOriginalValue("displayDate");
	}

	@JSON
	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expirationDate = expirationDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalExpirationDate() {
		return getColumnOriginalValue("expirationDate");
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(CommercePriceEntry.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommercePriceEntry.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommercePriceEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommercePriceEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommercePriceEntryImpl commercePriceEntryImpl =
			new CommercePriceEntryImpl();

		commercePriceEntryImpl.setUuid(getUuid());
		commercePriceEntryImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		commercePriceEntryImpl.setCommercePriceEntryId(
			getCommercePriceEntryId());
		commercePriceEntryImpl.setCompanyId(getCompanyId());
		commercePriceEntryImpl.setUserId(getUserId());
		commercePriceEntryImpl.setUserName(getUserName());
		commercePriceEntryImpl.setCreateDate(getCreateDate());
		commercePriceEntryImpl.setModifiedDate(getModifiedDate());
		commercePriceEntryImpl.setCommercePriceListId(getCommercePriceListId());
		commercePriceEntryImpl.setCPInstanceUuid(getCPInstanceUuid());
		commercePriceEntryImpl.setCProductId(getCProductId());
		commercePriceEntryImpl.setPrice(getPrice());
		commercePriceEntryImpl.setPromoPrice(getPromoPrice());
		commercePriceEntryImpl.setDiscountDiscovery(isDiscountDiscovery());
		commercePriceEntryImpl.setDiscountLevel1(getDiscountLevel1());
		commercePriceEntryImpl.setDiscountLevel2(getDiscountLevel2());
		commercePriceEntryImpl.setDiscountLevel3(getDiscountLevel3());
		commercePriceEntryImpl.setDiscountLevel4(getDiscountLevel4());
		commercePriceEntryImpl.setHasTierPrice(isHasTierPrice());
		commercePriceEntryImpl.setBulkPricing(isBulkPricing());
		commercePriceEntryImpl.setDisplayDate(getDisplayDate());
		commercePriceEntryImpl.setExpirationDate(getExpirationDate());
		commercePriceEntryImpl.setLastPublishDate(getLastPublishDate());
		commercePriceEntryImpl.setStatus(getStatus());
		commercePriceEntryImpl.setStatusByUserId(getStatusByUserId());
		commercePriceEntryImpl.setStatusByUserName(getStatusByUserName());
		commercePriceEntryImpl.setStatusDate(getStatusDate());

		commercePriceEntryImpl.resetOriginalValues();

		return commercePriceEntryImpl;
	}

	@Override
	public int compareTo(CommercePriceEntry commercePriceEntry) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commercePriceEntry.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommercePriceEntry)) {
			return false;
		}

		CommercePriceEntry commercePriceEntry = (CommercePriceEntry)object;

		long primaryKey = commercePriceEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommercePriceEntry> toCacheModel() {
		CommercePriceEntryCacheModel commercePriceEntryCacheModel =
			new CommercePriceEntryCacheModel();

		commercePriceEntryCacheModel.uuid = getUuid();

		String uuid = commercePriceEntryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commercePriceEntryCacheModel.uuid = null;
		}

		commercePriceEntryCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commercePriceEntryCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commercePriceEntryCacheModel.externalReferenceCode = null;
		}

		commercePriceEntryCacheModel.commercePriceEntryId =
			getCommercePriceEntryId();

		commercePriceEntryCacheModel.companyId = getCompanyId();

		commercePriceEntryCacheModel.userId = getUserId();

		commercePriceEntryCacheModel.userName = getUserName();

		String userName = commercePriceEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commercePriceEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commercePriceEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			commercePriceEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commercePriceEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commercePriceEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commercePriceEntryCacheModel.commercePriceListId =
			getCommercePriceListId();

		commercePriceEntryCacheModel.CPInstanceUuid = getCPInstanceUuid();

		String CPInstanceUuid = commercePriceEntryCacheModel.CPInstanceUuid;

		if ((CPInstanceUuid != null) && (CPInstanceUuid.length() == 0)) {
			commercePriceEntryCacheModel.CPInstanceUuid = null;
		}

		commercePriceEntryCacheModel.CProductId = getCProductId();

		commercePriceEntryCacheModel.price = getPrice();

		commercePriceEntryCacheModel.promoPrice = getPromoPrice();

		commercePriceEntryCacheModel.discountDiscovery = isDiscountDiscovery();

		commercePriceEntryCacheModel.discountLevel1 = getDiscountLevel1();

		commercePriceEntryCacheModel.discountLevel2 = getDiscountLevel2();

		commercePriceEntryCacheModel.discountLevel3 = getDiscountLevel3();

		commercePriceEntryCacheModel.discountLevel4 = getDiscountLevel4();

		commercePriceEntryCacheModel.hasTierPrice = isHasTierPrice();

		commercePriceEntryCacheModel.bulkPricing = isBulkPricing();

		Date displayDate = getDisplayDate();

		if (displayDate != null) {
			commercePriceEntryCacheModel.displayDate = displayDate.getTime();
		}
		else {
			commercePriceEntryCacheModel.displayDate = Long.MIN_VALUE;
		}

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			commercePriceEntryCacheModel.expirationDate =
				expirationDate.getTime();
		}
		else {
			commercePriceEntryCacheModel.expirationDate = Long.MIN_VALUE;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			commercePriceEntryCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			commercePriceEntryCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		commercePriceEntryCacheModel.status = getStatus();

		commercePriceEntryCacheModel.statusByUserId = getStatusByUserId();

		commercePriceEntryCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = commercePriceEntryCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			commercePriceEntryCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			commercePriceEntryCacheModel.statusDate = statusDate.getTime();
		}
		else {
			commercePriceEntryCacheModel.statusDate = Long.MIN_VALUE;
		}

		return commercePriceEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommercePriceEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommercePriceEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommercePriceEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommercePriceEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommercePriceEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommercePriceEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommercePriceEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((CommercePriceEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommercePriceEntry>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private String _uuid;
	private String _externalReferenceCode;
	private long _commercePriceEntryId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commercePriceListId;
	private String _CPInstanceUuid;
	private long _CProductId;
	private BigDecimal _price;
	private BigDecimal _promoPrice;
	private boolean _discountDiscovery;
	private BigDecimal _discountLevel1;
	private BigDecimal _discountLevel2;
	private BigDecimal _discountLevel3;
	private BigDecimal _discountLevel4;
	private boolean _hasTierPrice;
	private boolean _bulkPricing;
	private Date _displayDate;
	private Date _expirationDate;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommercePriceEntry, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommercePriceEntry)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put(
			"commercePriceEntryId", _commercePriceEntryId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("commercePriceListId", _commercePriceListId);
		_columnOriginalValues.put("CPInstanceUuid", _CPInstanceUuid);
		_columnOriginalValues.put("CProductId", _CProductId);
		_columnOriginalValues.put("price", _price);
		_columnOriginalValues.put("promoPrice", _promoPrice);
		_columnOriginalValues.put("discountDiscovery", _discountDiscovery);
		_columnOriginalValues.put("discountLevel1", _discountLevel1);
		_columnOriginalValues.put("discountLevel2", _discountLevel2);
		_columnOriginalValues.put("discountLevel3", _discountLevel3);
		_columnOriginalValues.put("discountLevel4", _discountLevel4);
		_columnOriginalValues.put("hasTierPrice", _hasTierPrice);
		_columnOriginalValues.put("bulkPricing", _bulkPricing);
		_columnOriginalValues.put("displayDate", _displayDate);
		_columnOriginalValues.put("expirationDate", _expirationDate);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("uuid_", 1L);

		columnBitmasks.put("externalReferenceCode", 2L);

		columnBitmasks.put("commercePriceEntryId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("commercePriceListId", 256L);

		columnBitmasks.put("CPInstanceUuid", 512L);

		columnBitmasks.put("CProductId", 1024L);

		columnBitmasks.put("price", 2048L);

		columnBitmasks.put("promoPrice", 4096L);

		columnBitmasks.put("discountDiscovery", 8192L);

		columnBitmasks.put("discountLevel1", 16384L);

		columnBitmasks.put("discountLevel2", 32768L);

		columnBitmasks.put("discountLevel3", 65536L);

		columnBitmasks.put("discountLevel4", 131072L);

		columnBitmasks.put("hasTierPrice", 262144L);

		columnBitmasks.put("bulkPricing", 524288L);

		columnBitmasks.put("displayDate", 1048576L);

		columnBitmasks.put("expirationDate", 2097152L);

		columnBitmasks.put("lastPublishDate", 4194304L);

		columnBitmasks.put("status", 8388608L);

		columnBitmasks.put("statusByUserId", 16777216L);

		columnBitmasks.put("statusByUserName", 33554432L);

		columnBitmasks.put("statusDate", 67108864L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommercePriceEntry _escapedModel;

}