/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.internal.helper;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.pricing.configuration.CommercePricingConfiguration;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SystemSettingsLocator;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Locale;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceBasePriceListHelper.class})
public class CommerceBasePriceListHelper {
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;

    public void addCatalogBaseCommercePriceList(CommerceCatalog commerceCatalog) throws PortalException {
        CommercePricingConfiguration commercePricingConfiguration = (CommercePricingConfiguration)this._configurationProvider.getConfiguration(CommercePricingConfiguration.class, (SettingsLocator)new SystemSettingsLocator("com.liferay.commerce.pricing.service.name"));
        if (!Objects.equals(commercePricingConfiguration.commercePricingCalculationKey(), "v2.0")) {
            return;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(commerceCatalog.getCompanyId());
        serviceContext.setScopeGroupId(commerceCatalog.getGroupId());
        serviceContext.setUserId(commerceCatalog.getUserId());
        this._addCatalogBaseCommercePriceList(commerceCatalog, "price-list", LanguageUtil.format((Locale)LocaleUtil.fromLanguageId((String)commerceCatalog.getCatalogDefaultLanguageId()), (String)"x-base-price-list", (Object)commerceCatalog.getName(), (boolean)false), serviceContext);
        this._addCatalogBaseCommercePriceList(commerceCatalog, "promotion", LanguageUtil.format((Locale)LocaleUtil.fromLanguageId((String)commerceCatalog.getCatalogDefaultLanguageId()), (String)"x-base-promotion", (Object)commerceCatalog.getName(), (boolean)false), serviceContext);
    }

    public void deleteCatalogBaseCommercePriceList(CommerceCatalog commerceCatalog) throws PortalException {
        this._deleteCatalogBaseCommercePriceList(commerceCatalog, "price-list");
        this._deleteCatalogBaseCommercePriceList(commerceCatalog, "promotion");
    }

    private void _addCatalogBaseCommercePriceList(CommerceCatalog commerceCatalog, String type, String name, ServiceContext serviceContext) throws PortalException {
        CommercePriceList catalogBaseCommercePriceList = this._commercePriceListLocalService.fetchCatalogBaseCommercePriceListByType(commerceCatalog.getGroupId(), type);
        if (catalogBaseCommercePriceList == null) {
            CommerceCurrency commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(serviceContext.getCompanyId(), commerceCatalog.getCommerceCurrencyCode());
            this._commercePriceListLocalService.addCatalogBaseCommercePriceList(commerceCatalog.getGroupId(), serviceContext.getUserId(), commerceCurrency.getCommerceCurrencyId(), type, name, serviceContext);
        }
    }

    private void _deleteCatalogBaseCommercePriceList(CommerceCatalog commerceCatalog, String type) throws PortalException {
        CommercePriceList catalogBaseCommercePriceList = this._commercePriceListLocalService.fetchCatalogBaseCommercePriceListByType(commerceCatalog.getGroupId(), type);
        if (catalogBaseCommercePriceList != null) {
            this._commercePriceListLocalService.deleteCommercePriceList(catalogBaseCommercePriceList);
        }
    }
}

