/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.internal.permission;

import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.permission.CommercePriceListPermission;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommercePriceListPermission.class})
public class CommercePriceListPermissionImpl
implements CommercePriceListPermission {
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;

    public void check(PermissionChecker permissionChecker, CommercePriceList commercePriceList, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commercePriceList, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommercePriceList.class.getName(), commercePriceList.getCommercePriceListId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long commercePriceListId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commercePriceListId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommercePriceList.class.getName(), commercePriceListId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CommercePriceList commercePriceList, String actionId) throws PortalException {
        return this.contains(permissionChecker, commercePriceList.getCommercePriceListId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long commercePriceListId, String actionId) throws PortalException {
        CommercePriceList commercePriceList = this._commercePriceListLocalService.fetchCommercePriceList(commercePriceListId);
        if (commercePriceList == null) {
            return false;
        }
        return this._contains(permissionChecker, commercePriceList, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] commercePriceListIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])commercePriceListIds)) {
            return false;
        }
        for (long commercePriceListId : commercePriceListIds) {
            if (this.contains(permissionChecker, commercePriceListId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CommercePriceList commercePriceList, String actionId) throws PortalException {
        if (permissionChecker.isCompanyAdmin(commercePriceList.getCompanyId()) || permissionChecker.isOmniadmin()) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), CommercePriceList.class.getName(), commercePriceList.getCommercePriceListId(), permissionChecker.getUserId(), actionId) && commercePriceList.getUserId() == permissionChecker.getUserId()) {
            return true;
        }
        return permissionChecker.hasPermission(commercePriceList.getGroupId(), CommercePriceList.class.getName(), commercePriceList.getCommercePriceListId(), actionId);
    }
}

