/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.internal.search;

import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListAccountRelModel;
import com.liferay.commerce.price.list.model.CommercePriceListChannelRelModel;
import com.liferay.commerce.price.list.model.CommercePriceListCommerceAccountGroupRelModel;
import com.liferay.commerce.price.list.service.CommercePriceListAccountRelLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListChannelRelLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListCommerceAccountGroupRelLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.MissingFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.filter.FilterBuilders;
import com.liferay.portal.search.filter.TermsSetFilterBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CommercePriceListIndexer
extends BaseIndexer<CommercePriceList> {
    public static final String CLASS_NAME = CommercePriceList.class.getName();
    public static final String FIELD_EXTERNAL_REFERENCE_CODE = "externalReferenceCode";
    private static final Log _log = LogFactoryUtil.getLog(CommercePriceListIndexer.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CommercePriceListAccountRelLocalService _commercePriceListAccountRelLocalService;
    @Reference
    private CommercePriceListChannelRelLocalService _commercePriceListChannelRelLocalService;
    @Reference
    private CommercePriceListCommerceAccountGroupRelLocalService _commercePriceListCommerceAccountGroupRelLocalService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private FilterBuilders _filterBuilders;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CommercePriceListIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "groupId", "modified", "name", "scopeGroupId", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long commerceAccountId;
        int[] statuses = GetterUtil.getIntegerValues((Object)searchContext.getAttribute("status"), null);
        if (ArrayUtil.isEmpty((int[])statuses)) {
            int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
            statuses = new int[]{status};
        }
        if (!ArrayUtil.contains((int[])statuses, (int)-1)) {
            TermsFilter statusesTermsFilter = new TermsFilter("status");
            statusesTermsFilter.addValues(ArrayUtil.toStringArray((int[])statuses));
            contextBooleanFilter.add((Filter)statusesTermsFilter, BooleanClauseOccur.MUST);
        } else {
            contextBooleanFilter.addTerm("status", String.valueOf(8), BooleanClauseOccur.MUST_NOT);
        }
        long[] commerceAccountGroupIds = GetterUtil.getLongValues((Object)searchContext.getAttribute("commerceAccountGroupIds"), null);
        if (ArrayUtil.isNotEmpty((long[])commerceAccountGroupIds)) {
            TermsSetFilterBuilder termsSetFilterBuilder = this._filterBuilders.termsSetFilterBuilder();
            termsSetFilterBuilder.setFieldName("commerceAccountGroupIds");
            termsSetFilterBuilder.setMinimumShouldMatchField("commerceAccountGroupIds_required_matches");
            ArrayList<String> values = new ArrayList<String>(commerceAccountGroupIds.length);
            for (long commerceAccountGroupId : commerceAccountGroupIds) {
                values.add(String.valueOf(commerceAccountGroupId));
            }
            termsSetFilterBuilder.setValues(values);
            TermFilter termFilter = new TermFilter("commerceAccountGroupIds_required_matches", "0");
            BooleanFilter fieldBooleanFilter = new BooleanFilter();
            fieldBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.SHOULD);
            fieldBooleanFilter.add((Filter)termsSetFilterBuilder.build(), BooleanClauseOccur.SHOULD);
            contextBooleanFilter.add((Filter)fieldBooleanFilter, BooleanClauseOccur.MUST);
        }
        if ((commerceAccountId = GetterUtil.getLong((Object)searchContext.getAttribute("commerceAccountId"))) > 0L) {
            BooleanFilter commerceAccountBooleanFilter = new BooleanFilter();
            commerceAccountBooleanFilter.add((Filter)new MissingFilter("commerceAccountId"), BooleanClauseOccur.SHOULD);
            commerceAccountBooleanFilter.addTerm("commerceAccountId", String.valueOf(commerceAccountId), BooleanClauseOccur.SHOULD);
            contextBooleanFilter.add((Filter)commerceAccountBooleanFilter, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_EXTERNAL_REFERENCE_CODE, false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(CommercePriceList commercePriceList) throws Exception {
        this.deleteDocument(commercePriceList.getCompanyId(), commercePriceList.getCommercePriceListId());
    }

    protected Document doGetDocument(CommercePriceList commercePriceList) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing price list " + commercePriceList));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commercePriceList);
        document.addKeyword(FIELD_EXTERNAL_REFERENCE_CODE, commercePriceList.getExternalReferenceCode());
        document.addNumber("entryClassPK", commercePriceList.getCommercePriceListId());
        document.addText("name", commercePriceList.getName());
        document.addText("userName", commercePriceList.getUserName());
        document.addNumberSortable("priority", Double.valueOf(commercePriceList.getPriority()));
        document.addNumber("catalogId", this._getCatalogId(commercePriceList));
        document.addKeyword("catalogBasePriceList", commercePriceList.isCatalogBasePriceList());
        document.addText("type", commercePriceList.getType());
        List commercePriceListAccountRels = this._commercePriceListAccountRelLocalService.getCommercePriceListAccountRels(commercePriceList.getCommercePriceListId());
        Stream commercePriceListAccountRelsStream = commercePriceListAccountRels.stream();
        long[] commerceAccountIds = commercePriceListAccountRelsStream.mapToLong(CommercePriceListAccountRelModel::getCommerceAccountId).toArray();
        document.addNumber("commerceAccountId", commerceAccountIds);
        List commercePriceListChannelRels = this._commercePriceListChannelRelLocalService.getCommercePriceListChannelRels(commercePriceList.getCommercePriceListId());
        Stream commercePriceListChannelRelsStream = commercePriceListChannelRels.stream();
        long[] commerceChannelIds = commercePriceListChannelRelsStream.mapToLong(CommercePriceListChannelRelModel::getCommerceChannelId).toArray();
        document.addNumber("commerceChannelId", commerceChannelIds);
        List commercePriceListCommerceAccountGroupRels = this._commercePriceListCommerceAccountGroupRelLocalService.getCommercePriceListCommerceAccountGroupRels(commercePriceList.getCommercePriceListId());
        Stream commercePriceListCommerceAccountGroupRelsStream = commercePriceListCommerceAccountGroupRels.stream();
        long[] commerceAccountGroupIds = commercePriceListCommerceAccountGroupRelsStream.mapToLong(CommercePriceListCommerceAccountGroupRelModel::getCommerceAccountGroupId).toArray();
        document.addNumber("commerceAccountGroupIds", commerceAccountGroupIds);
        document.addNumber("commerceAccountGroupIds_required_matches", commerceAccountGroupIds.length);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commercePriceList + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "entryClassPK", "name");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CommercePriceList commercePriceList) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commercePriceList.getCompanyId(), this.getDocument(commercePriceList), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commercePriceListLocalService.getCommercePriceList(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCommercePriceLists(companyId);
    }

    protected void reindexCommercePriceLists(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commercePriceListLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commercePriceList -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commercePriceList)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce price list " + commercePriceList.getCommercePriceListId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    private long _getCatalogId(CommercePriceList commercePriceList) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogLocalService.fetchCommerceCatalogByGroupId(commercePriceList.getGroupId());
        if (commerceCatalog == null) {
            return 0L;
        }
        return commerceCatalog.getCommerceCatalogId();
    }
}

