/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.internal.upgrade.v1_1_0;

import com.liferay.commerce.price.list.internal.upgrade.base.BaseCommercePriceListUpgradeProcess;
import com.liferay.commerce.price.list.model.impl.CommercePriceEntryModelImpl;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;

public class CommercePriceEntryUpgradeProcess
extends BaseCommercePriceListUpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CommercePriceEntryUpgradeProcess.class);
    private final CPDefinitionLocalService _cpDefinitionLocalService;
    private final CPInstanceLocalService _cpInstanceLocalService;

    public CommercePriceEntryUpgradeProcess(CPDefinitionLocalService cpDefinitionLocalService, CPInstanceLocalService cpInstanceLocalService) {
        this._cpDefinitionLocalService = cpDefinitionLocalService;
        this._cpInstanceLocalService = cpInstanceLocalService;
    }

    @Override
    protected void doUpgrade() throws Exception {
        this.addColumn(CommercePriceEntryModelImpl.class, "CommercePriceEntry", "CPInstanceUuid", "VARCHAR(75)");
        this.addColumn(CommercePriceEntryModelImpl.class, "CommercePriceEntry", "CProductId", "LONG");
        this._addIndexes("CommercePriceEntry");
        try (PreparedStatement ps = this.connection.prepareStatement("update CommercePriceEntry set CProductId = ?,CPInstanceUuid = ? where CPInstanceId = ?");
             Statement s = this.connection.createStatement();
             ResultSet rs = s.executeQuery("select distinct CPInstanceId from CommercePriceEntry");){
            while (rs.next()) {
                long cpInstanceId = rs.getLong("CPInstanceId");
                CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
                CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
                ps.setLong(1, cpDefinition.getCProductId());
                ps.setString(2, cpInstance.getCPInstanceUuid());
                ps.setLong(3, cpInstanceId);
                ps.execute();
            }
        }
        if (this.hasIndex("CommercePriceEntry", "IX_2083879C")) {
            this.runSQL("drop index IX_2083879C on CommercePriceEntry");
        }
        this.runSQL("alter table CommercePriceEntry drop column CPInstanceId");
    }

    private void _addIndexes(String tableName) throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        List indexesSQL = this.getIndexesSQL(clazz.getClassLoader(), tableName);
        for (ObjectValuePair indexSQL : indexesSQL) {
            IndexMetadata indexMetadata = (IndexMetadata)indexSQL.getValue();
            if (_log.isInfoEnabled()) {
                _log.info((Object)String.format("Adding index %s to table %s", indexMetadata.getIndexName(), tableName));
            }
            if (!this.hasIndex(tableName, indexMetadata.getIndexName())) {
                this.runSQL(indexMetadata.getCreateSQL(null));
                continue;
            }
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)String.format("Index %s already exists on table %s", indexMetadata.getIndexName(), tableName));
        }
    }
}

