/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.internal.upgrade.v2_1_2;

import com.liferay.commerce.price.list.internal.upgrade.base.BaseCommercePriceListUpgradeProcess;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;

public class CommercePriceListUpgradeProcess
extends BaseCommercePriceListUpgradeProcess {
    private static final String[] _OWNER_PERMISSIONS = new String[]{"DELETE", "PERMISSIONS", "UPDATE", "VIEW"};
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourceLocalService _resourceLocalService;

    public CommercePriceListUpgradeProcess(ResourceActionLocalService resourceActionLocalService, ResourceLocalService resourceLocalService) {
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourceLocalService = resourceLocalService;
    }

    @Override
    public void doUpgrade() throws Exception {
        this._resourceActionLocalService.checkResourceActions(CommercePriceList.class.getName(), Arrays.asList(_OWNER_PERMISSIONS));
        ModelPermissions modelPermissions = ModelPermissionsFactory.create((String[])new String[0], (String[])new String[0]);
        modelPermissions.addRolePermissions("Owner", _OWNER_PERMISSIONS);
        String selectCommercePriceListSQL = "select companyId, groupId, userId, commercePriceListId from CommercePriceList";
        try (Statement s = this.connection.createStatement();
             ResultSet rs = s.executeQuery(selectCommercePriceListSQL);){
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                long groupId = rs.getLong("groupId");
                long userId = rs.getLong("userId");
                long commercePriceListId = rs.getLong("commercePriceListId");
                this._resourceLocalService.addModelResources(companyId, groupId, userId, CommercePriceList.class.getName(), commercePriceListId, modelPermissions);
            }
        }
    }
}

