/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.impl;

import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommerceTierPriceEntry;
import com.liferay.commerce.price.list.service.base.CommerceTierPriceEntryServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.List;

public class CommerceTierPriceEntryServiceImpl
extends CommerceTierPriceEntryServiceBaseImpl {
    private static volatile ModelResourcePermission<CommercePriceList> _commercePriceListModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceTierPriceEntryServiceImpl.class, (String)"_commercePriceListModelResourcePermission", CommercePriceList.class);

    public CommerceTierPriceEntry addCommerceTierPriceEntry(long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, int minQuantity, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceTierPriceEntry(commercePriceEntryId, null, price, promoPrice, minQuantity, serviceContext);
    }

    public CommerceTierPriceEntry addCommerceTierPriceEntry(long commercePriceEntryId, String externalReferenceCode, BigDecimal price, BigDecimal promoPrice, int minQuantity, ServiceContext serviceContext) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        if (commercePriceEntry != null) {
            _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        }
        return this.commerceTierPriceEntryLocalService.addCommerceTierPriceEntry(commercePriceEntryId, externalReferenceCode, price, promoPrice, minQuantity, serviceContext);
    }

    public CommerceTierPriceEntry addCommerceTierPriceEntry(long commercePriceEntryId, String externalReferenceCode, BigDecimal price, int minQuantity, boolean bulkPricing, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        return this.commerceTierPriceEntryLocalService.addCommerceTierPriceEntry(commercePriceEntryId, externalReferenceCode, price, minQuantity, bulkPricing, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public void deleteCommerceTierPriceEntry(long commerceTierPriceEntryId) throws PortalException {
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntry(commerceTierPriceEntryId);
        CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        this.commerceTierPriceEntryLocalService.deleteCommerceTierPriceEntry(commerceTierPriceEntryId);
    }

    public CommerceTierPriceEntry fetchByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryLocalService.fetchByExternalReferenceCode(companyId, externalReferenceCode);
        if (commerceTierPriceEntry != null) {
            CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
            _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        }
        return commerceTierPriceEntry;
    }

    @Deprecated
    public List<CommerceTierPriceEntry> fetchCommerceTierPriceEntries(long companyId, int start, int end) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public CommerceTierPriceEntry fetchCommerceTierPriceEntry(long commerceTierPriceEntryId) throws PortalException {
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryLocalService.fetchCommerceTierPriceEntry(commerceTierPriceEntryId);
        if (commerceTierPriceEntry != null) {
            CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
            _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        }
        return commerceTierPriceEntry;
    }

    public List<CommerceTierPriceEntry> getCommerceTierPriceEntries(long commercePriceEntryId, int start, int end) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        return this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntries(commercePriceEntryId, start, end);
    }

    public List<CommerceTierPriceEntry> getCommerceTierPriceEntries(long commercePriceEntryId, int start, int end, OrderByComparator<CommerceTierPriceEntry> orderByComparator) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        return this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntries(commercePriceEntryId, start, end, orderByComparator);
    }

    public int getCommerceTierPriceEntriesCount(long commercePriceEntryId) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        return this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntriesCount(commercePriceEntryId);
    }

    @Deprecated
    public int getCommerceTierPriceEntriesCountByCompanyId(long companyId) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public CommerceTierPriceEntry getCommerceTierPriceEntry(long commerceTierPriceEntryId) throws PortalException {
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntry(commerceTierPriceEntryId);
        CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        return commerceTierPriceEntry;
    }

    public BaseModelSearchResult<CommerceTierPriceEntry> searchCommerceTierPriceEntries(long companyId, long commercePriceEntryId, String keywords, int start, int end, Sort sort) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceEntryId);
        if (commercePriceEntry != null) {
            _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        }
        return this.commerceTierPriceEntryLocalService.searchCommerceTierPriceEntries(companyId, commercePriceEntryId, keywords, start, end, sort);
    }

    public int searchCommerceTierPriceEntriesCount(long companyId, long commercePriceEntryId, String keywords) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        if (commercePriceEntry != null) {
            _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        }
        return this.commercePriceEntryLocalService.searchCommercePriceEntriesCount(companyId, commercePriceEntryId, keywords);
    }

    public CommerceTierPriceEntry updateCommerceTierPriceEntry(long commerceTierPriceEntryId, BigDecimal price, BigDecimal promoPrice, int minQuantity, ServiceContext serviceContext) throws PortalException {
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntry(commerceTierPriceEntryId);
        CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        return this.commerceTierPriceEntryLocalService.updateCommerceTierPriceEntry(commerceTierPriceEntryId, price, promoPrice, minQuantity, serviceContext);
    }

    public CommerceTierPriceEntry updateCommerceTierPriceEntry(long commerceTierPriceEntryId, BigDecimal price, int minQuantity, boolean bulkPricing, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntry(commerceTierPriceEntryId);
        CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        return this.commerceTierPriceEntryLocalService.updateCommerceTierPriceEntry(commerceTierPriceEntryId, price, minQuantity, bulkPricing, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommerceTierPriceEntry updateExternalReferenceCode(CommerceTierPriceEntry commerceTierPriceEntry, String externalReferenceCode) throws PortalException {
        CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        return this.commerceTierPriceEntryLocalService.updateExternalReferenceCode(commerceTierPriceEntry, externalReferenceCode);
    }

    public CommerceTierPriceEntry upsertCommerceTierPriceEntry(long commerceTierPriceEntryId, long commercePriceEntryId, String externalReferenceCode, BigDecimal price, BigDecimal promoPrice, int minQuantity, String priceEntryExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceEntryId);
        if (commercePriceEntry == null && Validator.isNotNull((String)priceEntryExternalReferenceCode)) {
            commercePriceEntry = this.commercePriceEntryLocalService.fetchCommercePriceEntryByReferenceCode(serviceContext.getCompanyId(), priceEntryExternalReferenceCode);
        }
        if (commercePriceEntry != null) {
            _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        }
        return this.commerceTierPriceEntryLocalService.upsertCommerceTierPriceEntry(commerceTierPriceEntryId, commercePriceEntryId, externalReferenceCode, price, promoPrice, minQuantity, priceEntryExternalReferenceCode, serviceContext);
    }

    public CommerceTierPriceEntry upsertCommerceTierPriceEntry(long commerceTierPriceEntryId, long commercePriceEntryId, String externalReferenceCode, BigDecimal price, int minQuantity, boolean bulkPricing, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String priceEntryExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceEntryId);
        if (commercePriceEntry == null && Validator.isNotNull((String)priceEntryExternalReferenceCode)) {
            commercePriceEntry = this.commercePriceEntryLocalService.fetchCommercePriceEntryByReferenceCode(serviceContext.getCompanyId(), priceEntryExternalReferenceCode);
        }
        if (commercePriceEntry != null) {
            _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        }
        return this.commerceTierPriceEntryLocalService.upsertCommerceTierPriceEntry(commerceTierPriceEntryId, commercePriceEntryId, externalReferenceCode, price, minQuantity, bulkPricing, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, priceEntryExternalReferenceCode, serviceContext);
    }
}

