/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.internal.messaging;

import com.liferay.commerce.price.list.internal.helper.CommerceBasePriceListHelper;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"destination.name=liferay/base_price_list"}, service={MessageListener.class})
public class CommerceBasePriceListMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(CommerceBasePriceListMessageListener.class);
    @Reference
    private CommerceBasePriceListHelper _commerceBasePriceListHelper;
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;

    protected void doReceive(Message message) throws Exception {
        block3: {
            long commerceCatalogId = message.getLong("commerceCatalogId");
            CommerceCatalog commerceCatalog = this._commerceCatalogLocalService.fetchCommerceCatalog(commerceCatalogId);
            if (commerceCatalog == null) {
                return;
            }
            try {
                this._commerceBasePriceListHelper.addCatalogBaseCommercePriceList(commerceCatalog);
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)portalException, (Throwable)portalException);
            }
        }
    }
}

