/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.internal.upgrade.v1_1_0;

import com.liferay.commerce.price.list.internal.upgrade.base.BaseCommercePriceListUpgradeProcess;
import com.liferay.commerce.price.list.model.impl.CommercePriceEntryModelImpl;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;

public class CommercePriceEntryUpgradeProcess
extends BaseCommercePriceListUpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CommercePriceEntryUpgradeProcess.class);
    private final CPDefinitionLocalService _cpDefinitionLocalService;
    private final CPInstanceLocalService _cpInstanceLocalService;

    public CommercePriceEntryUpgradeProcess(CPDefinitionLocalService cpDefinitionLocalService, CPInstanceLocalService cpInstanceLocalService) {
        this._cpDefinitionLocalService = cpDefinitionLocalService;
        this._cpInstanceLocalService = cpInstanceLocalService;
    }

    @Override
    protected void doUpgrade() throws Exception {
        this.addColumn(CommercePriceEntryModelImpl.class, "CommercePriceEntry", "CPInstanceUuid", "VARCHAR(75)");
        this.addColumn(CommercePriceEntryModelImpl.class, "CommercePriceEntry", "CProductId", "LONG");
        this._addIndexes("CommercePriceEntry");
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update CommercePriceEntry set CProductId = ?,CPInstanceUuid = ? where CPInstanceId = ?");
             Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select distinct CPInstanceId from CommercePriceEntry");){
            while (resultSet.next()) {
                long cpInstanceId = resultSet.getLong("CPInstanceId");
                CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
                CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
                preparedStatement.setLong(1, cpDefinition.getCProductId());
                preparedStatement.setString(2, cpInstance.getCPInstanceUuid());
                preparedStatement.setLong(3, cpInstanceId);
                preparedStatement.execute();
            }
        }
        this.runSQL("drop index IX_2083879C on CommercePriceEntry");
        this.runSQL("alter table CommercePriceEntry drop column CPInstanceId");
    }

    private void _addIndexes(String tableName) throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        List indexesSQL = this.getIndexesSQL(clazz.getClassLoader(), tableName);
        for (ObjectValuePair indexSQL : indexesSQL) {
            IndexMetadata indexMetadata = (IndexMetadata)indexSQL.getValue();
            if (_log.isInfoEnabled()) {
                _log.info((Object)String.format("Adding index %s to table %s", indexMetadata.getIndexName(), tableName));
            }
            if (!this._tableHasIndex(tableName, indexMetadata.getIndexName())) {
                this.runSQL(indexMetadata.getCreateSQL(null));
                continue;
            }
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)String.format("Index %s already exists on table %s", indexMetadata.getIndexName(), tableName));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _tableHasIndex(String tableName, String indexName) throws Exception {
        DatabaseMetaData metadata = this.connection.getMetaData();
        try (ResultSet resultSet = metadata.getIndexInfo(null, null, tableName, false, false);){
            String curIndexName;
            do {
                if (!resultSet.next()) return false;
            } while (!Objects.equals(indexName, curIndexName = resultSet.getString("index_name")));
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (!_log.isDebugEnabled()) return false;
            _log.debug((Object)exception, (Throwable)exception);
        }
        return false;
    }
}

