/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.impl;

import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.base.CommercePriceEntryServiceBaseImpl;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

public class CommercePriceEntryServiceImpl
extends CommercePriceEntryServiceBaseImpl {
    private static volatile ModelResourcePermission<CommercePriceList> _commercePriceListModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommercePriceEntryServiceImpl.class, (String)"_commercePriceListModelResourcePermission", CommercePriceList.class);
    @ServiceReference(type=CPInstanceService.class)
    private CPInstanceService _cpInstanceService;

    public CommercePriceEntry addCommercePriceEntry(long cpInstanceId, long commercePriceListId, BigDecimal price, BigDecimal promoPrice, ServiceContext serviceContext) throws PortalException {
        return this.addCommercePriceEntry(null, cpInstanceId, commercePriceListId, price, promoPrice, serviceContext);
    }

    @Deprecated
    public CommercePriceEntry addCommercePriceEntry(long cProductId, String cpInstanceUuid, long commercePriceListId, String externalReferenceCode, BigDecimal price, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommercePriceEntry(externalReferenceCode, cProductId, cpInstanceUuid, commercePriceListId, price, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommercePriceEntry addCommercePriceEntry(String externalReferenceCode, long cpInstanceId, long commercePriceListId, BigDecimal price, BigDecimal promoPrice, ServiceContext serviceContext) throws PortalException {
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "UPDATE");
        return this.commercePriceEntryLocalService.addCommercePriceEntry(externalReferenceCode, cpInstanceId, commercePriceListId, price, promoPrice, serviceContext);
    }

    public CommercePriceEntry addCommercePriceEntry(String externalReferenceCode, long cProductId, String cpInstanceUuid, long commercePriceListId, BigDecimal price, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "UPDATE");
        return this.commercePriceEntryLocalService.addCommercePriceEntry(externalReferenceCode, cProductId, cpInstanceUuid, commercePriceListId, price, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommercePriceEntry addOrUpdateCommercePriceEntry(String externalReferenceCode, long commercePriceEntryId, long cProductId, String cpInstanceUuid, long commercePriceListId, BigDecimal price, BigDecimal promoPrice, String skuExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "UPDATE");
        return this.commercePriceEntryLocalService.addOrUpdateCommercePriceEntry(externalReferenceCode, commercePriceEntryId, cProductId, cpInstanceUuid, commercePriceListId, price, promoPrice, skuExternalReferenceCode, serviceContext);
    }

    public CommercePriceEntry addOrUpdateCommercePriceEntry(String externalReferenceCode, long commercePriceEntryId, long cProductId, String cpInstanceUuid, long commercePriceListId, BigDecimal price, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String skuExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "UPDATE");
        return this.commercePriceEntryLocalService.addOrUpdateCommercePriceEntry(externalReferenceCode, commercePriceEntryId, cProductId, cpInstanceUuid, commercePriceListId, price, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, skuExternalReferenceCode, serviceContext);
    }

    public void deleteCommercePriceEntry(long commercePriceEntryId) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        this.commercePriceEntryLocalService.deleteCommercePriceEntry(commercePriceEntry);
    }

    @Deprecated
    public CommercePriceEntry fetchByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        return this.fetchByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public CommercePriceEntry fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (commercePriceEntry != null) {
            _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        }
        return commercePriceEntry;
    }

    public CommercePriceEntry fetchCommercePriceEntry(long commercePriceEntryId) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceEntryId);
        if (commercePriceEntry != null) {
            _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        }
        return commercePriceEntry;
    }

    public List<CommercePriceEntry> getCommercePriceEntries(long commercePriceListId, int start, int end) throws PortalException {
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        return this.commercePriceEntryLocalService.getCommercePriceEntries(commercePriceListId, start, end);
    }

    public List<CommercePriceEntry> getCommercePriceEntries(long commercePriceListId, int start, int end, OrderByComparator<CommercePriceEntry> orderByComparator) throws PortalException {
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        return this.commercePriceEntryLocalService.getCommercePriceEntries(commercePriceListId, start, end, orderByComparator);
    }

    @Deprecated
    public List<CommercePriceEntry> getCommercePriceEntriesByCompanyId(long companyId, int start, int end) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public int getCommercePriceEntriesCount(long commercePriceListId) throws PortalException {
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        return this.commercePriceEntryLocalService.getCommercePriceEntriesCount(commercePriceListId);
    }

    @Deprecated
    public int getCommercePriceEntriesCountByCompanyId(long companyId) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public CommercePriceEntry getCommercePriceEntry(long commercePriceEntryId) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "VIEW");
        return commercePriceEntry;
    }

    public CommercePriceEntry getInstanceBaseCommercePriceEntry(String cpInstanceUuid, String priceListType) {
        return this.commercePriceListFinder.findBasePriceEntry(cpInstanceUuid, priceListType, true);
    }

    public List<CommercePriceEntry> getInstanceCommercePriceEntries(long cpInstanceId, int start, int end) throws PortalException {
        CPInstance cpInstance = this._cpInstanceService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return Collections.emptyList();
        }
        return this.commercePriceListFinder.findByCPInstanceUuid(cpInstance.getCPInstanceUuid(), start, end, true);
    }

    @Deprecated
    public List<CommercePriceEntry> getInstanceCommercePriceEntries(long cpInstanceId, int start, int end, OrderByComparator<CommercePriceEntry> orderByComparator) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public int getInstanceCommercePriceEntriesCount(long cpInstanceId) throws PortalException {
        CPInstance cpInstance = this._cpInstanceService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return 0;
        }
        return this.commercePriceListFinder.countByCPInstanceUuid(cpInstance.getCPInstanceUuid(), true);
    }

    public BaseModelSearchResult<CommercePriceEntry> searchCommercePriceEntries(long companyId, long commercePriceListId, String keywords, int start, int end, Sort sort) throws PortalException {
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        return this.commercePriceEntryLocalService.searchCommercePriceEntries(companyId, commercePriceListId, keywords, start, end, sort);
    }

    public int searchCommercePriceEntriesCount(long companyId, long commercePriceListId, String keywords) throws PortalException {
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "VIEW");
        return this.commercePriceEntryLocalService.searchCommercePriceEntriesCount(companyId, commercePriceListId, keywords);
    }

    public CommercePriceEntry updateCommercePriceEntry(long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, ServiceContext serviceContext) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        return this.commercePriceEntryLocalService.updateCommercePriceEntry(commercePriceEntryId, price, promoPrice, serviceContext);
    }

    public CommercePriceEntry updateCommercePriceEntry(long commercePriceEntryId, BigDecimal price, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, boolean bulkPricing, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        return this.commercePriceEntryLocalService.updateCommercePriceEntry(commercePriceEntryId, price, null, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, bulkPricing, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommercePriceEntry updateCommercePriceEntry(long commercePriceEntryId, BigDecimal price, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.getCommercePriceEntry(commercePriceEntryId);
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        return this.commercePriceEntryLocalService.updateCommercePriceEntry(commercePriceEntryId, price, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    public CommercePriceEntry updateExternalReferenceCode(CommercePriceEntry commercePriceEntry, String externalReferenceCode) throws PortalException {
        return this.updateExternalReferenceCode(externalReferenceCode, commercePriceEntry);
    }

    public CommercePriceEntry updateExternalReferenceCode(String externalReferenceCode, CommercePriceEntry commercePriceEntry) throws PortalException {
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceEntry.getCommercePriceListId(), "UPDATE");
        return this.commercePriceEntryLocalService.updateExternalReferenceCode(externalReferenceCode, commercePriceEntry);
    }

    @Deprecated
    public CommercePriceEntry upsertCommercePriceEntry(long commercePriceEntryId, long cpInstanceId, long commercePriceListId, String externalReferenceCode, BigDecimal price, BigDecimal promoPrice, String skuExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        _commercePriceListModelResourcePermission.check(this.getPermissionChecker(), commercePriceListId, "UPDATE");
        return this.commercePriceEntryLocalService.upsertCommercePriceEntry(commercePriceEntryId, cpInstanceId, commercePriceListId, externalReferenceCode, price, promoPrice, skuExternalReferenceCode, serviceContext);
    }

    @Deprecated
    public CommercePriceEntry upsertCommercePriceEntry(long commercePriceEntryId, long cProductId, String cpInstanceUuid, long commercePriceListId, String externalReferenceCode, BigDecimal price, BigDecimal promoPrice, String skuExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommercePriceEntry(externalReferenceCode, commercePriceEntryId, cProductId, cpInstanceUuid, commercePriceListId, price, promoPrice, skuExternalReferenceCode, serviceContext);
    }

    @Deprecated
    public CommercePriceEntry upsertCommercePriceEntry(long commercePriceEntryId, long cProductId, String cpInstanceUuid, long commercePriceListId, String externalReferenceCode, BigDecimal price, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String skuExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommercePriceEntry(externalReferenceCode, commercePriceEntryId, cProductId, cpInstanceUuid, commercePriceListId, price, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, skuExternalReferenceCode, serviceContext);
    }
}

