/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.impl;

import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListAccountRel;
import com.liferay.commerce.price.list.service.base.CommercePriceListAccountRelLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommercePriceListAccountRelLocalServiceImpl
extends CommercePriceListAccountRelLocalServiceBaseImpl {
    public CommercePriceListAccountRel addCommercePriceListAccountRel(long commercePriceListId, long commerceAccountId, int order, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommercePriceListAccountRel commercePriceListAccountRel = this.commercePriceListAccountRelPersistence.create(this.counterLocalService.increment());
        commercePriceListAccountRel.setCompanyId(user.getCompanyId());
        commercePriceListAccountRel.setUserId(user.getUserId());
        commercePriceListAccountRel.setUserName(user.getFullName());
        commercePriceListAccountRel.setCommerceAccountId(commerceAccountId);
        commercePriceListAccountRel.setCommercePriceListId(commercePriceListId);
        commercePriceListAccountRel.setOrder(order);
        commercePriceListAccountRel.setExpandoBridgeAttributes(serviceContext);
        this.reindexCommercePriceList(commercePriceListId);
        this.commercePriceListLocalService.cleanPriceListCache(serviceContext.getCompanyId());
        return (CommercePriceListAccountRel)this.commercePriceListAccountRelPersistence.update((BaseModel)commercePriceListAccountRel);
    }

    @Override
    public CommercePriceListAccountRel deleteCommercePriceListAccountRel(CommercePriceListAccountRel commercePriceListAccountRel) throws PortalException {
        this.commercePriceListAccountRelPersistence.remove((BaseModel)commercePriceListAccountRel);
        this.expandoRowLocalService.deleteRows(commercePriceListAccountRel.getCommercePriceListAccountRelId());
        this.reindexCommercePriceList(commercePriceListAccountRel.getCommercePriceListId());
        this.commercePriceListLocalService.cleanPriceListCache(commercePriceListAccountRel.getCompanyId());
        return commercePriceListAccountRel;
    }

    @Override
    public CommercePriceListAccountRel deleteCommercePriceListAccountRel(long commercePriceListAccountRelId) throws PortalException {
        CommercePriceListAccountRel commercePriceListAccountRel = this.commercePriceListAccountRelPersistence.findByPrimaryKey(commercePriceListAccountRelId);
        return this.commercePriceListAccountRelLocalService.deleteCommercePriceListAccountRel(commercePriceListAccountRel);
    }

    public void deleteCommercePriceListAccountRels(long commercePriceListId) throws PortalException {
        List commercePriceListAccountRels = this.commercePriceListAccountRelPersistence.findByCommercePriceListId(commercePriceListId);
        for (CommercePriceListAccountRel commercePriceListAccountRel : commercePriceListAccountRels) {
            this.commercePriceListAccountRelLocalService.deleteCommercePriceListAccountRel(commercePriceListAccountRel);
        }
    }

    public void deleteCommercePriceListAccountRelsByCommercePriceListId(long commercePriceListId) throws PortalException {
        List commercePriceListAccountRels = this.commercePriceListAccountRelPersistence.findByCommercePriceListId(commercePriceListId);
        for (CommercePriceListAccountRel commercePriceListAccountRel : commercePriceListAccountRels) {
            this.commercePriceListAccountRelLocalService.deleteCommercePriceListAccountRel(commercePriceListAccountRel);
        }
    }

    public CommercePriceListAccountRel fetchCommercePriceListAccountRel(long commerceAccountId, long commercePriceListId) {
        return this.commercePriceListAccountRelPersistence.fetchByC_C(commerceAccountId, commercePriceListId);
    }

    public List<CommercePriceListAccountRel> getCommercePriceListAccountRels(long commercePriceListId) {
        return this.commercePriceListAccountRelPersistence.findByCommercePriceListId(commercePriceListId);
    }

    public List<CommercePriceListAccountRel> getCommercePriceListAccountRels(long commercePriceListId, int start, int end, OrderByComparator<CommercePriceListAccountRel> orderByComparator) {
        return this.commercePriceListAccountRelPersistence.findByCommercePriceListId(commercePriceListId, start, end, orderByComparator);
    }

    public List<CommercePriceListAccountRel> getCommercePriceListAccountRels(long commercePriceListId, String name, int start, int end) {
        return this.commercePriceListAccountRelFinder.findByCommercePriceListId(commercePriceListId, name, start, end);
    }

    public int getCommercePriceListAccountRelsCount(long commercePriceListId) {
        return this.commercePriceListAccountRelPersistence.countByCommercePriceListId(commercePriceListId);
    }

    public int getCommercePriceListAccountRelsCount(long commercePriceListId, String name) {
        return this.commercePriceListAccountRelFinder.countByCommercePriceListId(commercePriceListId, name);
    }

    protected void reindexCommercePriceList(long commercePriceListId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommercePriceList.class);
        indexer.reindex(CommercePriceList.class.getName(), commercePriceListId);
    }
}

