/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.impl;

import com.liferay.commerce.price.list.exception.CommercePriceEntryDisplayDateException;
import com.liferay.commerce.price.list.exception.CommercePriceEntryExpirationDateException;
import com.liferay.commerce.price.list.exception.CommerceTierPriceEntryDisplayDateException;
import com.liferay.commerce.price.list.exception.CommerceTierPriceEntryExpirationDateException;
import com.liferay.commerce.price.list.exception.DuplicateCommerceTierPriceEntryException;
import com.liferay.commerce.price.list.exception.NoSuchPriceEntryException;
import com.liferay.commerce.price.list.exception.NoSuchTierPriceEntryException;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommerceTierPriceEntry;
import com.liferay.commerce.price.list.service.base.CommerceTierPriceEntryLocalServiceBaseImpl;
import com.liferay.commerce.price.list.service.persistence.CommercePriceEntryPersistence;
import com.liferay.commerce.price.list.util.comparator.CommerceTierPriceEntryMinQuantityComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class CommerceTierPriceEntryLocalServiceImpl
extends CommerceTierPriceEntryLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "groupId", "uid"};
    private static final Log _log = LogFactoryUtil.getLog(CommerceTierPriceEntryLocalServiceImpl.class);
    @BeanReference(type=CommercePriceEntryPersistence.class)
    private CommercePriceEntryPersistence _commercePriceEntryPersistence;

    public CommerceTierPriceEntry addCommerceTierPriceEntry(long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, boolean bulkPricing, int minQuantity, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceTierPriceEntry(null, commercePriceEntryId, price, promoPrice, bulkPricing, minQuantity, serviceContext);
    }

    public CommerceTierPriceEntry addCommerceTierPriceEntry(long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, int minQuantity, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceTierPriceEntry(null, commercePriceEntryId, price, promoPrice, minQuantity, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTierPriceEntry addCommerceTierPriceEntry(String externalReferenceCode, long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, boolean bulkPricing, int minQuantity, ServiceContext serviceContext) throws PortalException {
        GregorianCalendar now = new GregorianCalendar();
        return this.addCommerceTierPriceEntry(externalReferenceCode, commercePriceEntryId, price, promoPrice, minQuantity, bulkPricing, true, null, null, null, null, now.get(2), now.get(5), now.get(1), now.get(10), now.get(12), 0, 0, 0, 0, 0, true, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTierPriceEntry addCommerceTierPriceEntry(String externalReferenceCode, long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, int minQuantity, boolean bulkPricing, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        this.validate(0L, commercePriceEntryId, minQuantity);
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        this.validateExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        Date expirationDate = null;
        Date date = new Date();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CommerceTierPriceEntryDisplayDateException.class);
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CommerceTierPriceEntryExpirationDateException.class);
        }
        long commerceTierPriceEntryId = this.counterLocalService.increment();
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryPersistence.create(commerceTierPriceEntryId);
        commerceTierPriceEntry.setExternalReferenceCode(externalReferenceCode);
        commerceTierPriceEntry.setCompanyId(user.getCompanyId());
        commerceTierPriceEntry.setUserId(user.getUserId());
        commerceTierPriceEntry.setUserName(user.getFullName());
        commerceTierPriceEntry.setCommercePriceEntryId(commercePriceEntryId);
        commerceTierPriceEntry.setPrice(price);
        commerceTierPriceEntry.setPromoPrice(promoPrice);
        commerceTierPriceEntry.setDiscountDiscovery(discountDiscovery);
        commerceTierPriceEntry.setDiscountLevel1(discountLevel1);
        commerceTierPriceEntry.setDiscountLevel2(discountLevel2);
        commerceTierPriceEntry.setDiscountLevel3(discountLevel3);
        commerceTierPriceEntry.setDiscountLevel4(discountLevel4);
        commerceTierPriceEntry.setMinQuantity(minQuantity);
        commerceTierPriceEntry.setExpandoBridgeAttributes(serviceContext);
        commerceTierPriceEntry.setDisplayDate(displayDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commerceTierPriceEntry.setStatus(2);
        } else {
            commerceTierPriceEntry.setStatus(3);
        }
        commerceTierPriceEntry.setExpirationDate(expirationDate);
        commerceTierPriceEntry.setStatusByUserId(user.getUserId());
        commerceTierPriceEntry.setStatusDate(serviceContext.getModifiedDate(date));
        commerceTierPriceEntry = (CommerceTierPriceEntry)this.commerceTierPriceEntryPersistence.update((BaseModel)commerceTierPriceEntry);
        this.commercePriceEntryLocalService.setHasTierPrice(commercePriceEntryId, true, bulkPricing);
        return this.startWorkflowInstance(user.getUserId(), commerceTierPriceEntry, serviceContext);
    }

    public CommerceTierPriceEntry addCommerceTierPriceEntry(String externalReferenceCode, long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, int minQuantity, ServiceContext serviceContext) throws PortalException {
        GregorianCalendar now = new GregorianCalendar();
        return this.addCommerceTierPriceEntry(externalReferenceCode, commercePriceEntryId, price, promoPrice, minQuantity, true, true, null, null, null, null, now.get(2), now.get(5), now.get(1), now.get(10), now.get(12), 0, 0, 0, 0, 0, true, serviceContext);
    }

    public CommerceTierPriceEntry addCommerceTierPriceEntry(String externalReferenceCode, long commercePriceEntryId, BigDecimal price, int minQuantity, boolean bulkPricing, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceTierPriceEntry(externalReferenceCode, commercePriceEntryId, price, null, minQuantity, bulkPricing, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommerceTierPriceEntry addOrUpdateCommerceTierPriceEntry(String externalReferenceCode, long commerceTierPriceEntryId, long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, int minQuantity, boolean bulkPricing, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String priceEntryExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        CommercePriceEntry commercePriceEntry;
        CommerceTierPriceEntry commerceTierPriceEntry;
        block7: {
            if (commerceTierPriceEntryId > 0L) {
                try {
                    return this.updateCommerceTierPriceEntry(commerceTierPriceEntryId, price, promoPrice, minQuantity, bulkPricing, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
                }
                catch (NoSuchTierPriceEntryException noSuchTierPriceEntryException) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug((Object)("Unable to find tier price entry with ID: " + commerceTierPriceEntryId), (Throwable)noSuchTierPriceEntryException);
                }
            }
        }
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        if (Validator.isNotNull((String)externalReferenceCode) && (commerceTierPriceEntry = this.commerceTierPriceEntryPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode)) != null) {
            return this.updateCommerceTierPriceEntry(commerceTierPriceEntry.getCommerceTierPriceEntryId(), price, promoPrice, minQuantity, bulkPricing, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
        }
        if (commercePriceEntryId > 0L) {
            this.validate(0L, commercePriceEntryId, minQuantity);
            commercePriceEntry = this._commercePriceEntryPersistence.findByPrimaryKey(commercePriceEntryId);
            return this.addCommerceTierPriceEntry(externalReferenceCode, commercePriceEntry.getCommercePriceEntryId(), price, promoPrice, minQuantity, bulkPricing, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
        }
        if (Validator.isNotNull((String)priceEntryExternalReferenceCode)) {
            commercePriceEntry = this._commercePriceEntryPersistence.findByC_ERC(serviceContext.getCompanyId(), priceEntryExternalReferenceCode);
            this.validate(0L, commercePriceEntry.getCommercePriceEntryId(), minQuantity);
            return this.addCommerceTierPriceEntry(externalReferenceCode, commercePriceEntry.getCommercePriceEntryId(), price, promoPrice, minQuantity, bulkPricing, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
        }
        StringBundler sb = new StringBundler(6);
        sb.append("{commercePriceEntryId=");
        sb.append(commercePriceEntryId);
        sb.append(", ");
        sb.append("priceEntryExternalReferenceCode=");
        sb.append(priceEntryExternalReferenceCode);
        sb.append('}');
        throw new NoSuchPriceEntryException(sb.toString());
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTierPriceEntry addOrUpdateCommerceTierPriceEntry(String externalReferenceCode, long commerceTierPriceEntryId, long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, int minQuantity, String priceEntryExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        GregorianCalendar now = new GregorianCalendar();
        return this.addOrUpdateCommerceTierPriceEntry(externalReferenceCode, commerceTierPriceEntryId, commercePriceEntryId, price, promoPrice, minQuantity, true, true, null, null, null, null, now.get(2), now.get(5), now.get(1), now.get(10), now.get(12), 0, 0, 0, 0, 0, true, priceEntryExternalReferenceCode, serviceContext);
    }

    public CommerceTierPriceEntry addOrUpdateCommerceTierPriceEntry(String externalReferenceCode, long commerceTierPriceEntryId, long commercePriceEntryId, BigDecimal price, int minQuantity, boolean bulkPricing, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String priceEntryExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommerceTierPriceEntry(externalReferenceCode, commerceTierPriceEntryId, commercePriceEntryId, price, null, minQuantity, bulkPricing, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, priceEntryExternalReferenceCode, serviceContext);
    }

    public void checkCommerceTierPriceEntries() throws PortalException {
        this.checkCommerceTierPriceEntriesByDisplayDate();
        this.checkCommerceTierPriceEntriesByExpirationDate();
    }

    public void deleteCommerceTierPriceEntries(long commercePriceEntryId) throws PortalException {
        List commerceTierPriceEntries = this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntries(commercePriceEntryId, -1, -1);
        for (CommerceTierPriceEntry commerceTierPriceEntry : commerceTierPriceEntries) {
            this.commerceTierPriceEntryLocalService.deleteCommerceTierPriceEntry(commerceTierPriceEntry);
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceTierPriceEntry deleteCommerceTierPriceEntry(CommerceTierPriceEntry commerceTierPriceEntry) throws PortalException {
        this.commerceTierPriceEntryPersistence.remove((BaseModel)commerceTierPriceEntry);
        List commerceTierPriceEntries = this.commerceTierPriceEntryLocalService.getCommerceTierPriceEntries(commerceTierPriceEntry.getCommercePriceEntryId(), -1, -1);
        if (commerceTierPriceEntries.isEmpty()) {
            this.commercePriceEntryLocalService.setHasTierPrice(commerceTierPriceEntry.getCommercePriceEntryId(), false);
        }
        this.expandoRowLocalService.deleteRows(commerceTierPriceEntry.getCommerceTierPriceEntryId());
        return commerceTierPriceEntry;
    }

    @Override
    public CommerceTierPriceEntry deleteCommerceTierPriceEntry(long commerceTierPriceEntryId) throws PortalException {
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryPersistence.findByPrimaryKey(commerceTierPriceEntryId);
        return this.commerceTierPriceEntryLocalService.deleteCommerceTierPriceEntry(commerceTierPriceEntry);
    }

    public CommerceTierPriceEntry fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        return this.commerceTierPriceEntryPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public List<CommerceTierPriceEntry> fetchCommerceTierPriceEntries(long companyId, int start, int end) {
        return this.commerceTierPriceEntryPersistence.findByCompanyId(companyId, start, end);
    }

    public CommerceTierPriceEntry findClosestCommerceTierPriceEntry(long commercePriceEntryId, int quantity) {
        CommerceTierPriceEntry commerceTierPriceEntry;
        block2: {
            commerceTierPriceEntry = null;
            try {
                commerceTierPriceEntry = this.commerceTierPriceEntryPersistence.findByC_LtM_S_First(commercePriceEntryId, quantity, 0, (OrderByComparator)new CommerceTierPriceEntryMinQuantityComparator(false));
            }
            catch (NoSuchTierPriceEntryException noSuchTierPriceEntryException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)noSuchTierPriceEntryException, (Throwable)noSuchTierPriceEntryException);
            }
        }
        return commerceTierPriceEntry;
    }

    public List<CommerceTierPriceEntry> findCommerceTierPriceEntries(long commercePriceEntryId, int quantity) {
        return this.commerceTierPriceEntryPersistence.findByC_LtM_S(commercePriceEntryId, quantity, 0, -1, -1, (OrderByComparator)new CommerceTierPriceEntryMinQuantityComparator(true));
    }

    public List<CommerceTierPriceEntry> getCommerceTierPriceEntries(long commercePriceEntryId, int start, int end) {
        return this.commerceTierPriceEntryPersistence.findByCommercePriceEntryId(commercePriceEntryId, start, end);
    }

    public List<CommerceTierPriceEntry> getCommerceTierPriceEntries(long commercePriceEntryId, int start, int end, OrderByComparator<CommerceTierPriceEntry> orderByComparator) {
        return this.commerceTierPriceEntryPersistence.findByCommercePriceEntryId(commercePriceEntryId, start, end, orderByComparator);
    }

    public int getCommerceTierPriceEntriesCount(long commercePriceEntryId) {
        return this.commerceTierPriceEntryPersistence.countByCommercePriceEntryId(commercePriceEntryId);
    }

    public int getCommerceTierPriceEntriesCountByCompanyId(long companyId) {
        return this.commerceTierPriceEntryPersistence.countByCompanyId(companyId);
    }

    public Hits search(SearchContext searchContext) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceTierPriceEntry.class);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public BaseModelSearchResult<CommerceTierPriceEntry> searchCommerceTierPriceEntries(long companyId, long commercePriceEntryId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, commercePriceEntryId, keywords, start, end, sort);
        return this.searchCommerceTierPriceEntries(searchContext);
    }

    public int searchCommerceTierPriceEntriesCount(long companyId, long commercePriceEntryId, String keywords) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, commercePriceEntryId, keywords, -1, -1, null);
        return this.searchCommerceTierPriceEntriesCount(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTierPriceEntry updateCommerceTierPriceEntry(long commerceTierPriceEntryId, BigDecimal price, BigDecimal promoPrice, int minQuantity, boolean bulkPricing, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryPersistence.findByPrimaryKey(commerceTierPriceEntryId);
        this.validate(commerceTierPriceEntryId, commerceTierPriceEntry.getCommercePriceEntryId(), minQuantity);
        Date expirationDate = null;
        Date date = new Date();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CommercePriceEntryDisplayDateException.class);
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CommercePriceEntryExpirationDateException.class);
        }
        commerceTierPriceEntry.setPrice(price);
        commerceTierPriceEntry.setPromoPrice(promoPrice);
        commerceTierPriceEntry.setMinQuantity(minQuantity);
        commerceTierPriceEntry.setExpandoBridgeAttributes(serviceContext);
        commerceTierPriceEntry.setDiscountDiscovery(discountDiscovery);
        commerceTierPriceEntry.setDiscountLevel1(discountLevel1);
        commerceTierPriceEntry.setDiscountLevel2(discountLevel2);
        commerceTierPriceEntry.setDiscountLevel3(discountLevel3);
        commerceTierPriceEntry.setDiscountLevel4(discountLevel4);
        commerceTierPriceEntry.setDisplayDate(displayDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commerceTierPriceEntry.setStatus(2);
        } else {
            commerceTierPriceEntry.setStatus(3);
        }
        commerceTierPriceEntry.setExpirationDate(expirationDate);
        commerceTierPriceEntry.setStatusByUserId(user.getUserId());
        commerceTierPriceEntry.setStatusDate(serviceContext.getModifiedDate(date));
        this.commercePriceEntryLocalService.setHasTierPrice(commerceTierPriceEntry.getCommercePriceEntryId(), true, bulkPricing);
        commerceTierPriceEntry = (CommerceTierPriceEntry)this.commerceTierPriceEntryPersistence.update((BaseModel)commerceTierPriceEntry);
        commerceTierPriceEntry = this.startWorkflowInstance(user.getUserId(), commerceTierPriceEntry, serviceContext);
        return commerceTierPriceEntry;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTierPriceEntry updateCommerceTierPriceEntry(long commerceTierPriceEntryId, BigDecimal price, BigDecimal promoPrice, int minQuantity, ServiceContext serviceContext) throws PortalException {
        GregorianCalendar now = new GregorianCalendar();
        return this.updateCommerceTierPriceEntry(commerceTierPriceEntryId, price, promoPrice, minQuantity, true, true, null, null, null, null, now.get(2), now.get(5), now.get(1), now.get(10), now.get(12), 0, 0, 0, 0, 0, true, serviceContext);
    }

    public CommerceTierPriceEntry updateCommerceTierPriceEntry(long commerceTierPriceEntryId, BigDecimal price, int minQuantity, boolean bulkPricing, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.updateCommerceTierPriceEntry(commerceTierPriceEntryId, price, null, minQuantity, bulkPricing, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTierPriceEntry updateExternalReferenceCode(CommerceTierPriceEntry commerceTierPriceEntry, String externalReferenceCode) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        commerceTierPriceEntry.setExternalReferenceCode(externalReferenceCode);
        return (CommerceTierPriceEntry)this.commerceTierPriceEntryPersistence.update((BaseModel)commerceTierPriceEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceTierPriceEntry updateStatus(long userId, long commerceTierPriceEntryId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        Date expirationDate;
        User user = this.userLocalService.getUser(userId);
        Date date = new Date();
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryPersistence.findByPrimaryKey(commerceTierPriceEntryId);
        if (status == 0 && commerceTierPriceEntry.getDisplayDate() != null && date.before(commerceTierPriceEntry.getDisplayDate())) {
            status = 7;
        }
        Date modifiedDate = serviceContext.getModifiedDate(date);
        if (status == 0 && (expirationDate = commerceTierPriceEntry.getExpirationDate()) != null && expirationDate.before(date)) {
            commerceTierPriceEntry.setExpirationDate(null);
        }
        if (status == 3) {
            commerceTierPriceEntry.setExpirationDate(date);
        }
        commerceTierPriceEntry.setStatus(status);
        commerceTierPriceEntry.setStatusByUserId(user.getUserId());
        commerceTierPriceEntry.setStatusByUserName(user.getFullName());
        commerceTierPriceEntry.setStatusDate(modifiedDate);
        return (CommerceTierPriceEntry)this.commerceTierPriceEntryPersistence.update((BaseModel)commerceTierPriceEntry);
    }

    protected SearchContext buildSearchContext(long companyId, long commercePriceEntryId, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"entryClassPK", (Object)keywords).put((Object)"commercePriceEntryId", (Object)commercePriceEntryId).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected void checkCommerceTierPriceEntriesByDisplayDate() throws PortalException {
        List commerceTierPriceEntries = this.commerceTierPriceEntryPersistence.findByLtD_S(new Date(), 7);
        for (CommerceTierPriceEntry commerceTierPriceEntry : commerceTierPriceEntries) {
            long userId = PortalUtil.getValidUserId((long)commerceTierPriceEntry.getCompanyId(), (long)commerceTierPriceEntry.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
            CommercePriceList commercePriceList = commercePriceEntry.getCommercePriceList();
            serviceContext.setScopeGroupId(commercePriceList.getGroupId());
            this.commerceTierPriceEntryLocalService.updateStatus(userId, commerceTierPriceEntry.getCommerceTierPriceEntryId(), 0, serviceContext, new HashMap());
        }
    }

    protected void checkCommerceTierPriceEntriesByExpirationDate() throws PortalException {
        List commerceTierPriceEntries = this.commerceTierPriceEntryPersistence.findByLtE_S(new Date(), 0);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + commerceTierPriceEntries.size() + " commerce tier price entries"));
        }
        if (commerceTierPriceEntries != null && !commerceTierPriceEntries.isEmpty()) {
            for (CommerceTierPriceEntry commerceTierPriceEntry : commerceTierPriceEntries) {
                long userId = PortalUtil.getValidUserId((long)commerceTierPriceEntry.getCompanyId(), (long)commerceTierPriceEntry.getUserId());
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCommand("update");
                CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
                CommercePriceList commercePriceList = commercePriceEntry.getCommercePriceList();
                serviceContext.setScopeGroupId(commercePriceList.getGroupId());
                this.commerceTierPriceEntryLocalService.updateStatus(userId, commerceTierPriceEntry.getCommerceTierPriceEntryId(), 3, serviceContext, new HashMap());
            }
        }
    }

    protected List<CommerceTierPriceEntry> getCommerceTierPriceEntries(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceTierPriceEntry> commerceTierPriceEntries = new ArrayList<CommerceTierPriceEntry>(documents.size());
        for (Document document : documents) {
            long commerceTierPriceEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceTierPriceEntry commerceTierPriceEntry = this.fetchCommerceTierPriceEntry(commerceTierPriceEntryId);
            if (commerceTierPriceEntry == null) {
                commerceTierPriceEntries = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceTierPriceEntry.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceTierPriceEntries == null) continue;
            commerceTierPriceEntries.add(commerceTierPriceEntry);
        }
        return commerceTierPriceEntries;
    }

    protected BaseModelSearchResult<CommerceTierPriceEntry> searchCommerceTierPriceEntries(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceTierPriceEntry.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceTierPriceEntry> commerceTierPriceEntries = this.getCommerceTierPriceEntries(hits);
            if (commerceTierPriceEntries == null) continue;
            return new BaseModelSearchResult(commerceTierPriceEntries, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected int searchCommerceTierPriceEntriesCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceTierPriceEntry.class);
        return GetterUtil.getInteger((Object)indexer.searchCount(searchContext));
    }

    protected CommerceTierPriceEntry startWorkflowInstance(long userId, CommerceTierPriceEntry commerceTierPriceEntry, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        return (CommerceTierPriceEntry)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commerceTierPriceEntry.getCompanyId(), (long)0L, (long)userId, (String)CommerceTierPriceEntry.class.getName(), (long)commerceTierPriceEntry.getCommerceTierPriceEntryId(), (Object)commerceTierPriceEntry, (ServiceContext)serviceContext, workflowContext);
    }

    protected void validate(long commerceTierPriceEntryId, long commercePriceEntryId, int minQuantity) throws PortalException {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryPersistence.findByPrimaryKey(commercePriceEntryId);
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryPersistence.fetchByC_M(commercePriceEntry.getCommercePriceEntryId(), minQuantity);
        if (commerceTierPriceEntry != null && commerceTierPriceEntry.getCommerceTierPriceEntryId() != commerceTierPriceEntryId) {
            throw new DuplicateCommerceTierPriceEntryException();
        }
    }

    protected void validateExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        CommerceTierPriceEntry commerceTierPriceEntry = this.commerceTierPriceEntryPersistence.fetchByC_ERC(companyId, externalReferenceCode);
        if (commerceTierPriceEntry != null) {
            throw new DuplicateCommerceTierPriceEntryException("There is another commerce tier price entry with external reference code " + externalReferenceCode);
        }
    }
}

