/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.internal.search;

import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CommercePriceEntryIndexer
extends BaseIndexer<CommercePriceEntry> {
    public static final String CLASS_NAME = CommercePriceEntry.class.getName();
    public static final String FIELD_COMMERCE_PRICE_LIST_ID = "commercePriceListId";
    public static final String FIELD_EXTERNAL_REFERENCE_CODE = "externalReferenceCode";
    private static final Log _log = LogFactoryUtil.getLog(CommercePriceEntryIndexer.class);
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CommercePriceEntryIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "uid"});
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long commercePriceListId = GetterUtil.getLong((Object)searchContext.getAttribute(FIELD_COMMERCE_PRICE_LIST_ID));
        if (commercePriceListId > 0L) {
            contextBooleanFilter.addRequiredTerm(FIELD_COMMERCE_PRICE_LIST_ID, commercePriceListId);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_EXTERNAL_REFERENCE_CODE, false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "cpDefinitionName", false);
        this.addSearchTerm(searchQuery, searchContext, "sku", false);
        this.addSearchTerm(searchQuery, searchContext, "skuExternalReferenceCode", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(CommercePriceEntry commercePriceEntry) throws Exception {
        this.deleteDocument(commercePriceEntry.getCompanyId(), commercePriceEntry.getCommercePriceEntryId());
    }

    protected Document doGetDocument(CommercePriceEntry commercePriceEntry) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing price entry " + commercePriceEntry));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commercePriceEntry);
        document.addKeyword(FIELD_COMMERCE_PRICE_LIST_ID, commercePriceEntry.getCommercePriceListId());
        document.addKeyword(FIELD_EXTERNAL_REFERENCE_CODE, commercePriceEntry.getExternalReferenceCode());
        CPInstance cpInstance = commercePriceEntry.getCPInstance();
        document.addKeyword("cpInstanceId", cpInstance.getCPInstanceId());
        document.addKeyword("sku", cpInstance.getSku());
        document.addKeyword("skuExternalReferenceCode", cpInstance.getExternalReferenceCode());
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        document.addLocalizedKeyword("cpDefinitionName", cpDefinition.getNameMap());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commercePriceEntry + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, FIELD_COMMERCE_PRICE_LIST_ID, FIELD_COMMERCE_PRICE_LIST_ID);
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CommercePriceEntry commercePriceEntry) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commercePriceEntry.getCompanyId(), this.getDocument(commercePriceEntry), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commercePriceEntryLocalService.getCommercePriceEntry(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this._reindexCommercePriceEntries(companyId);
    }

    private void _reindexCommercePriceEntries(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commercePriceEntryLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commercePriceEntry -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commercePriceEntry)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce price entry " + commercePriceEntry.getCommercePriceEntryId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

