/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.internal.verify;

import com.liferay.commerce.price.list.internal.helper.CommerceBasePriceListHelper;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"verify.process.name=com.liferay.commerce.price.list.service"}, service={CommercePriceListServiceVerifyProcess.class, VerifyProcess.class})
public class CommercePriceListServiceVerifyProcess
extends VerifyProcess {
    @Reference
    private CommerceBasePriceListHelper _commerceBasePriceListHelper;
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;

    protected void doVerify() throws Exception {
        this._verifyBasePriceLists();
    }

    private void _verifyBasePriceLists() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._companyLocalService.forEachCompanyId(companyId -> {
                List commerceCatalogs = this._commerceCatalogLocalService.getCommerceCatalogs(companyId.longValue(), true);
                for (CommerceCatalog commerceCatalog : commerceCatalogs) {
                    this._commerceBasePriceListHelper.addCatalogBaseCommercePriceList(commerceCatalog);
                }
            });
        }
    }
}

