/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.price.list.service.impl;

import com.liferay.commerce.price.list.exception.CommercePriceEntryDisplayDateException;
import com.liferay.commerce.price.list.exception.CommercePriceEntryExpirationDateException;
import com.liferay.commerce.price.list.exception.DuplicateCommercePriceEntryException;
import com.liferay.commerce.price.list.exception.NoSuchPriceEntryException;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceEntryTable;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.base.CommercePriceEntryLocalServiceBaseImpl;
import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class CommercePriceEntryLocalServiceImpl
extends CommercePriceEntryLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "groupId", "uid"};
    private static final Log _log = LogFactoryUtil.getLog(CommercePriceEntryLocalServiceImpl.class);
    @ServiceReference(type=CPDefinitionLocalService.class)
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @ServiceReference(type=CPInstanceLocalService.class)
    private CPInstanceLocalService _cpInstanceLocalService;
    @ServiceReference(type=ExpandoRowLocalService.class)
    private ExpandoRowLocalService _expandoRowLocalService;

    @Deprecated
    public CommercePriceEntry addCommercePriceEntry(long cpInstanceId, long commercePriceListId, BigDecimal price, BigDecimal promoPrice, ServiceContext serviceContext) throws PortalException {
        return this.addCommercePriceEntry(null, cpInstanceId, commercePriceListId, price, promoPrice, serviceContext);
    }

    public CommercePriceEntry addCommercePriceEntry(long cProductId, String cpInstanceUuid, long commercePriceListId, BigDecimal price, BigDecimal promoPrice, ServiceContext serviceContext) throws PortalException {
        return this.addCommercePriceEntry(cProductId, cpInstanceUuid, commercePriceListId, null, price, promoPrice, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceEntry addCommercePriceEntry(long cProductId, String cpInstanceUuid, long commercePriceListId, String externalReferenceCode, BigDecimal price, BigDecimal promoPrice, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommercePriceEntry(externalReferenceCode, cProductId, cpInstanceUuid, commercePriceListId, price, promoPrice, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceEntry addCommercePriceEntry(long cProductId, String cpInstanceUuid, long commercePriceListId, String externalReferenceCode, BigDecimal price, BigDecimal promoPrice, ServiceContext serviceContext) throws PortalException {
        return this.addCommercePriceEntry(externalReferenceCode, cProductId, cpInstanceUuid, commercePriceListId, price, promoPrice, serviceContext);
    }

    @Deprecated
    public CommercePriceEntry addCommercePriceEntry(long cProductId, String cpInstanceUuid, long commercePriceListId, String externalReferenceCode, BigDecimal price, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommercePriceEntry(externalReferenceCode, cProductId, cpInstanceUuid, commercePriceListId, price, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    public CommercePriceEntry addCommercePriceEntry(String externalReferenceCode, long cpInstanceId, long commercePriceListId, BigDecimal price, BigDecimal promoPrice, ServiceContext serviceContext) throws PortalException {
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        return this.commercePriceEntryLocalService.addCommercePriceEntry(cpDefinition.getCProductId(), cpInstance.getCPInstanceUuid(), commercePriceListId, externalReferenceCode, price, promoPrice, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceEntry addCommercePriceEntry(String externalReferenceCode, long cProductId, String cpInstanceUuid, long commercePriceListId, BigDecimal price, BigDecimal promoPrice, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        this.validateExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        Date expirationDate = null;
        Date date = new Date();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CommercePriceEntryDisplayDateException.class);
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CommercePriceEntryExpirationDateException.class);
        }
        long commercePriceEntryId = this.counterLocalService.increment();
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryPersistence.create(commercePriceEntryId);
        commercePriceEntry.setExternalReferenceCode(externalReferenceCode);
        commercePriceEntry.setCompanyId(user.getCompanyId());
        commercePriceEntry.setUserId(user.getUserId());
        commercePriceEntry.setUserName(user.getFullName());
        commercePriceEntry.setCommercePriceListId(commercePriceListId);
        commercePriceEntry.setPrice(price);
        commercePriceEntry.setPromoPrice(promoPrice);
        commercePriceEntry.setDiscountDiscovery(discountDiscovery);
        commercePriceEntry.setDiscountLevel1(discountLevel1);
        commercePriceEntry.setDiscountLevel2(discountLevel2);
        commercePriceEntry.setDiscountLevel3(discountLevel3);
        commercePriceEntry.setDiscountLevel4(discountLevel4);
        commercePriceEntry.setExpandoBridgeAttributes(serviceContext);
        commercePriceEntry.setCPInstanceUuid(cpInstanceUuid);
        commercePriceEntry.setCProductId(cProductId);
        commercePriceEntry.setDisplayDate(displayDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commercePriceEntry.setStatus(2);
        } else {
            commercePriceEntry.setStatus(3);
        }
        commercePriceEntry.setExpirationDate(expirationDate);
        commercePriceEntry.setStatusByUserId(user.getUserId());
        commercePriceEntry.setStatusDate(serviceContext.getModifiedDate(date));
        commercePriceEntry = (CommercePriceEntry)this.commercePriceEntryPersistence.update((BaseModel)commercePriceEntry);
        commercePriceEntry = this.startWorkflowInstance(user.getUserId(), commercePriceEntry, serviceContext);
        return commercePriceEntry;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceEntry addCommercePriceEntry(String externalReferenceCode, long cProductId, String cpInstanceUuid, long commercePriceListId, BigDecimal price, BigDecimal promoPrice, ServiceContext serviceContext) throws PortalException {
        GregorianCalendar now = new GregorianCalendar();
        return this.addCommercePriceEntry(cProductId, cpInstanceUuid, commercePriceListId, externalReferenceCode, price, promoPrice, true, null, null, null, null, now.get(2), now.get(5), now.get(1), now.get(10), now.get(12), 0, 0, 0, 0, 0, true, serviceContext);
    }

    public CommercePriceEntry addCommercePriceEntry(String externalReferenceCode, long cProductId, String cpInstanceUuid, long commercePriceListId, BigDecimal price, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommercePriceEntry(externalReferenceCode, cProductId, cpInstanceUuid, commercePriceListId, price, null, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommercePriceEntry addOrUpdateCommercePriceEntry(String externalReferenceCode, long commercePriceEntryId, long cProductId, String cpInstanceUuid, long commercePriceListId, BigDecimal price, BigDecimal promoPrice, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String skuExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        block8: {
            if (commercePriceEntryId > 0L) {
                try {
                    return this.updateCommercePriceEntry(commercePriceEntryId, price, promoPrice, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
                }
                catch (NoSuchPriceEntryException noSuchPriceEntryException) {
                    if (!_log.isDebugEnabled()) break block8;
                    _log.debug((Object)("Unable to find price entry with ID: " + commercePriceEntryId), (Throwable)noSuchPriceEntryException);
                }
            }
        }
        CommercePriceEntry commercePriceEntry = null;
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        if (!Validator.isBlank((String)externalReferenceCode)) {
            commercePriceEntry = this.commercePriceEntryPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode);
        }
        if (commercePriceEntry != null) {
            return this.updateCommercePriceEntry(commercePriceEntry.getCommercePriceEntryId(), price, promoPrice, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
        }
        if (cProductId > 0L && cpInstanceUuid != null) {
            return this.addCommercePriceEntry(externalReferenceCode, cProductId, cpInstanceUuid, commercePriceListId, price, promoPrice, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
        }
        if (Validator.isNotNull((String)skuExternalReferenceCode)) {
            CPInstance cpInstance = this._cpInstanceLocalService.getCPInstanceByExternalReferenceCode(skuExternalReferenceCode, serviceContext.getCompanyId());
            CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
            return this.addCommercePriceEntry(externalReferenceCode, cpDefinition.getCProductId(), cpInstance.getCPInstanceUuid(), commercePriceListId, price, promoPrice, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
        }
        throw new NoSuchCPInstanceException(StringBundler.concat((Object[])new Object[]{"{cProductId=", cProductId, ", cpInstanceUuid=", cpInstanceUuid, ", skuExternalReferenceCode=", skuExternalReferenceCode, Character.valueOf('}')}));
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceEntry addOrUpdateCommercePriceEntry(String externalReferenceCode, long commercePriceEntryId, long cProductId, String cpInstanceUuid, long commercePriceListId, BigDecimal price, BigDecimal promoPrice, String skuExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        GregorianCalendar now = new GregorianCalendar();
        return this.addOrUpdateCommercePriceEntry(externalReferenceCode, commercePriceEntryId, cProductId, cpInstanceUuid, commercePriceListId, price, promoPrice, true, null, null, null, null, now.get(2), now.get(5), now.get(1), now.get(10), now.get(12), 0, 0, 0, 0, 0, true, skuExternalReferenceCode, serviceContext);
    }

    public CommercePriceEntry addOrUpdateCommercePriceEntry(String externalReferenceCode, long commercePriceEntryId, long cProductId, String cpInstanceUuid, long commercePriceListId, BigDecimal price, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String skuExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommercePriceEntry(externalReferenceCode, commercePriceEntryId, cProductId, cpInstanceUuid, commercePriceListId, price, null, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, skuExternalReferenceCode, serviceContext);
    }

    public void checkCommercePriceEntries() throws PortalException {
        this.checkCommercePriceEntriesByDisplayDate();
        this.checkCommercePriceEntriesByExpirationDate();
    }

    public void deleteCommercePriceEntries(long commercePriceListId) throws PortalException {
        List commercePriceEntries = this.commercePriceEntryLocalService.getCommercePriceEntries(commercePriceListId, -1, -1);
        for (CommercePriceEntry commercePriceEntry : commercePriceEntries) {
            this.commercePriceEntryLocalService.deleteCommercePriceEntry(commercePriceEntry);
        }
    }

    public void deleteCommercePriceEntries(String cpInstanceUuid) throws PortalException {
        List commercePriceEntries = this.commercePriceEntryPersistence.findByCPInstanceUuid(cpInstanceUuid);
        for (CommercePriceEntry commercePriceEntry : commercePriceEntries) {
            this.commercePriceEntryLocalService.deleteCommercePriceEntry(commercePriceEntry);
        }
    }

    @Deprecated
    public void deleteCommercePriceEntriesByCPInstanceId(long cpInstanceId) throws PortalException {
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        if (cpInstance != null) {
            this.commercePriceEntryLocalService.deleteCommercePriceEntries(cpInstance.getCPInstanceUuid());
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommercePriceEntry deleteCommercePriceEntry(CommercePriceEntry commercePriceEntry) throws PortalException {
        this.commerceTierPriceEntryLocalService.deleteCommerceTierPriceEntries(commercePriceEntry.getCommercePriceEntryId());
        this.commercePriceEntryPersistence.remove((BaseModel)commercePriceEntry);
        this._expandoRowLocalService.deleteRows(commercePriceEntry.getCommercePriceEntryId());
        return commercePriceEntry;
    }

    @Override
    public CommercePriceEntry deleteCommercePriceEntry(long commercePriceEntryId) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryPersistence.findByPrimaryKey(commercePriceEntryId);
        return this.commercePriceEntryLocalService.deleteCommercePriceEntry(commercePriceEntry);
    }

    @Deprecated
    public CommercePriceEntry fetchByExternalReferenceCode(long companyId, String externalReferenceCode) {
        return this.fetchByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public CommercePriceEntry fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commercePriceEntryPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    @Deprecated
    public CommercePriceEntry fetchCommercePriceEntry(long cpInstanceId, long commercePriceListId) {
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return null;
        }
        return this.commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, cpInstance.getCPInstanceUuid());
    }

    @Deprecated
    public CommercePriceEntry fetchCommercePriceEntry(long cpInstanceId, long commercePriceListId, boolean useAncestor) {
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return null;
        }
        return this.commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, cpInstance.getCPInstanceUuid(), useAncestor);
    }

    public CommercePriceEntry fetchCommercePriceEntry(long commercePriceListId, String cpInstanceUuid) {
        List commercePriceEntries = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceEntryTable.INSTANCE), commercePriceListId, cpInstanceUuid, -1).orderBy(new OrderByExpression[]{CommercePriceEntryTable.INSTANCE.displayDate.descending(), CommercePriceEntryTable.INSTANCE.createDate.descending()}).limit(0, 1));
        if (commercePriceEntries.isEmpty()) {
            return null;
        }
        return (CommercePriceEntry)commercePriceEntries.get(0);
    }

    public CommercePriceEntry fetchCommercePriceEntry(long commercePriceListId, String cpInstanceUuid, boolean useAncestor) {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, cpInstanceUuid, 0);
        if (!useAncestor || commercePriceEntry != null) {
            return commercePriceEntry;
        }
        CommercePriceList commercePriceList = this.commercePriceListLocalService.fetchCommercePriceList(commercePriceListId);
        if (commercePriceList == null || commercePriceList.getParentCommercePriceListId() == 0L) {
            return null;
        }
        return this.commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceList.getParentCommercePriceListId(), cpInstanceUuid, useAncestor);
    }

    public CommercePriceEntry fetchCommercePriceEntry(long commercePriceListId, String cpInstanceUuid, int status) {
        List commercePriceEntries = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePriceEntryTable.INSTANCE), commercePriceListId, cpInstanceUuid, status).orderBy(new OrderByExpression[]{CommercePriceEntryTable.INSTANCE.displayDate.descending(), CommercePriceEntryTable.INSTANCE.createDate.descending()}).limit(0, 1));
        if (commercePriceEntries.isEmpty()) {
            return null;
        }
        return (CommercePriceEntry)commercePriceEntries.get(0);
    }

    public List<CommercePriceEntry> getCommercePriceEntries(long commercePriceListId, int start, int end) {
        return this.commercePriceEntryPersistence.findByCommercePriceListId(commercePriceListId, start, end);
    }

    public List<CommercePriceEntry> getCommercePriceEntries(long commercePriceListId, int start, int end, OrderByComparator<CommercePriceEntry> orderByComparator) {
        return this.commercePriceEntryPersistence.findByCommercePriceListId(commercePriceListId, start, end, orderByComparator);
    }

    public List<CommercePriceEntry> getCommercePriceEntriesByCompanyId(long companyId, int start, int end) {
        return this.commercePriceEntryPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCommercePriceEntriesCount(long commercePriceListId) {
        return this.commercePriceEntryPersistence.countByCommercePriceListId(commercePriceListId);
    }

    public int getCommercePriceEntriesCountByCompanyId(long companyId) {
        return this.commercePriceEntryPersistence.countByCompanyId(companyId);
    }

    public CommercePriceEntry getInstanceBaseCommercePriceEntry(String cpInstanceUuid, String priceListType) {
        return this.commercePriceListFinder.findBasePriceEntry(cpInstanceUuid, priceListType);
    }

    @Deprecated
    public List<CommercePriceEntry> getInstanceCommercePriceEntries(long cpInstanceId, int start, int end) {
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return Collections.emptyList();
        }
        return this.commercePriceEntryLocalService.getInstanceCommercePriceEntries(cpInstance.getCPInstanceUuid(), start, end);
    }

    @Deprecated
    public List<CommercePriceEntry> getInstanceCommercePriceEntries(long cpInstanceId, int start, int end, OrderByComparator<CommercePriceEntry> orderByComparator) {
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return Collections.emptyList();
        }
        return this.commercePriceEntryLocalService.getInstanceCommercePriceEntries(cpInstance.getCPInstanceUuid(), start, end, orderByComparator);
    }

    public List<CommercePriceEntry> getInstanceCommercePriceEntries(String cpInstanceUuid, int start, int end) {
        return this.commercePriceListFinder.findByCPInstanceUuid(cpInstanceUuid, start, end);
    }

    public List<CommercePriceEntry> getInstanceCommercePriceEntries(String cpInstanceUuid, int start, int end, OrderByComparator<CommercePriceEntry> orderByComparator) {
        return this.commercePriceEntryPersistence.findByCPInstanceUuid(cpInstanceUuid, start, end, orderByComparator);
    }

    @Deprecated
    public int getInstanceCommercePriceEntriesCount(long cpInstanceId) {
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return 0;
        }
        return this.commercePriceEntryLocalService.getInstanceCommercePriceEntriesCount(cpInstance.getCPInstanceUuid());
    }

    public int getInstanceCommercePriceEntriesCount(String cpInstanceUuid) {
        return this.commercePriceListFinder.countByCPInstanceUuid(cpInstanceUuid);
    }

    public Hits search(SearchContext searchContext) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommercePriceEntry.class);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public BaseModelSearchResult<CommercePriceEntry> searchCommercePriceEntries(long companyId, long commercePriceListId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, commercePriceListId, keywords, start, end, sort);
        return this.searchCommercePriceEntries(searchContext);
    }

    public int searchCommercePriceEntriesCount(long companyId, long commercePriceListId, String keywords) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, commercePriceListId, keywords, -1, -1, null);
        return this.searchCommercePriceEntriesCount(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceEntry setHasTierPrice(long commercePriceEntryId, boolean hasTierPrice) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryPersistence.findByPrimaryKey(commercePriceEntryId);
        commercePriceEntry.setHasTierPrice(hasTierPrice);
        commercePriceEntry.setBulkPricing(true);
        return (CommercePriceEntry)this.commercePriceEntryPersistence.update((BaseModel)commercePriceEntry);
    }

    public CommercePriceEntry setHasTierPrice(long commercePriceEntryId, boolean hasTierPrice, boolean bulkPricing) throws PortalException {
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryPersistence.findByPrimaryKey(commercePriceEntryId);
        commercePriceEntry.setHasTierPrice(hasTierPrice);
        commercePriceEntry.setBulkPricing(bulkPricing);
        return (CommercePriceEntry)this.commercePriceEntryPersistence.update((BaseModel)commercePriceEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceEntry updateCommercePriceEntry(long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, boolean bulkPricing, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryPersistence.findByPrimaryKey(commercePriceEntryId);
        Date expirationDate = null;
        Date date = new Date();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CommercePriceEntryDisplayDateException.class);
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CommercePriceEntryExpirationDateException.class);
        }
        commercePriceEntry.setExpandoBridgeAttributes(serviceContext);
        commercePriceEntry.setPrice(price);
        commercePriceEntry.setPromoPrice(promoPrice);
        commercePriceEntry.setDiscountDiscovery(discountDiscovery);
        commercePriceEntry.setDiscountLevel1(discountLevel1);
        commercePriceEntry.setDiscountLevel2(discountLevel2);
        commercePriceEntry.setDiscountLevel3(discountLevel3);
        commercePriceEntry.setDiscountLevel4(discountLevel4);
        commercePriceEntry.setBulkPricing(bulkPricing);
        commercePriceEntry.setDisplayDate(displayDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commercePriceEntry.setStatus(2);
        } else {
            commercePriceEntry.setStatus(3);
        }
        commercePriceEntry.setExpirationDate(expirationDate);
        commercePriceEntry.setStatusByUserId(user.getUserId());
        commercePriceEntry.setStatusDate(serviceContext.getModifiedDate(date));
        commercePriceEntry = (CommercePriceEntry)this.commercePriceEntryPersistence.update((BaseModel)commercePriceEntry);
        commercePriceEntry = this.startWorkflowInstance(user.getUserId(), commercePriceEntry, serviceContext);
        return commercePriceEntry;
    }

    public CommercePriceEntry updateCommercePriceEntry(long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.updateCommercePriceEntry(commercePriceEntryId, price, promoPrice, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, true, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceEntry updateCommercePriceEntry(long commercePriceEntryId, BigDecimal price, BigDecimal promoPrice, ServiceContext serviceContext) throws PortalException {
        GregorianCalendar now = new GregorianCalendar();
        return this.updateCommercePriceEntry(commercePriceEntryId, price, promoPrice, true, null, null, null, null, now.get(2), now.get(5), now.get(1), now.get(10), now.get(12), 0, 0, 0, 0, 0, true, serviceContext);
    }

    public CommercePriceEntry updateCommercePriceEntry(long commercePriceEntryId, BigDecimal price, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.updateCommercePriceEntry(commercePriceEntryId, price, null, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceEntry updateExternalReferenceCode(CommercePriceEntry commercePriceEntry, String externalReferenceCode) throws PortalException {
        return this.updateExternalReferenceCode(externalReferenceCode, commercePriceEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceEntry updateExternalReferenceCode(String externalReferenceCode, CommercePriceEntry commercePriceEntry) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        commercePriceEntry.setExternalReferenceCode(externalReferenceCode);
        return (CommercePriceEntry)this.commercePriceEntryPersistence.update((BaseModel)commercePriceEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceEntry updateStatus(long userId, long commercePriceEntryId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        Date expirationDate;
        User user = this.userLocalService.getUser(userId);
        Date date = new Date();
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryPersistence.findByPrimaryKey(commercePriceEntryId);
        if (status == 0 && commercePriceEntry.getDisplayDate() != null && date.before(commercePriceEntry.getDisplayDate())) {
            status = 7;
        }
        Date modifiedDate = serviceContext.getModifiedDate(date);
        if (status == 0 && (expirationDate = commercePriceEntry.getExpirationDate()) != null && expirationDate.before(date)) {
            commercePriceEntry.setExpirationDate(null);
        }
        if (status == 3) {
            commercePriceEntry.setExpirationDate(date);
        }
        commercePriceEntry.setStatus(status);
        commercePriceEntry.setStatusByUserId(user.getUserId());
        commercePriceEntry.setStatusByUserName(user.getFullName());
        commercePriceEntry.setStatusDate(modifiedDate);
        return (CommercePriceEntry)this.commercePriceEntryPersistence.update((BaseModel)commercePriceEntry);
    }

    @Deprecated
    public CommercePriceEntry upsertCommercePriceEntry(long commercePriceEntryId, long cpInstanceId, long commercePriceListId, String externalReferenceCode, BigDecimal price, BigDecimal promoPrice, String skuExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        return this.commercePriceEntryLocalService.upsertCommercePriceEntry(commercePriceEntryId, cpDefinition.getCProductId(), cpInstance.getCPInstanceUuid(), commercePriceListId, externalReferenceCode, price, promoPrice, skuExternalReferenceCode, serviceContext);
    }

    @Deprecated
    public CommercePriceEntry upsertCommercePriceEntry(long commercePriceEntryId, long cProductId, String cpInstanceUuid, long commercePriceListId, String externalReferenceCode, BigDecimal price, BigDecimal promoPrice, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String skuExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommercePriceEntry(externalReferenceCode, commercePriceEntryId, cProductId, cpInstanceUuid, commercePriceListId, price, promoPrice, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, skuExternalReferenceCode, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommercePriceEntry upsertCommercePriceEntry(long commercePriceEntryId, long cProductId, String cpInstanceUuid, long commercePriceListId, String externalReferenceCode, BigDecimal price, BigDecimal promoPrice, String skuExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommercePriceEntry(externalReferenceCode, commercePriceEntryId, cProductId, cpInstanceUuid, commercePriceListId, price, promoPrice, skuExternalReferenceCode, serviceContext);
    }

    @Deprecated
    public CommercePriceEntry upsertCommercePriceEntry(long commercePriceEntryId, long cProductId, String cpInstanceUuid, long commercePriceListId, String externalReferenceCode, BigDecimal price, boolean discountDiscovery, BigDecimal discountLevel1, BigDecimal discountLevel2, BigDecimal discountLevel3, BigDecimal discountLevel4, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String skuExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        return this.upsertCommercePriceEntry(commercePriceEntryId, cProductId, cpInstanceUuid, commercePriceListId, externalReferenceCode, price, discountDiscovery, discountLevel1, discountLevel2, discountLevel3, discountLevel4, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, skuExternalReferenceCode, serviceContext);
    }

    protected SearchContext buildSearchContext(long companyId, long commercePriceListId, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"entryClassPK", (Object)keywords).put((Object)"commercePriceListId", (Object)commercePriceListId).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected void checkCommercePriceEntriesByDisplayDate() throws PortalException {
        List commercePriceEntries = this.commercePriceEntryPersistence.findByLtD_S(new Date(), 7);
        for (CommercePriceEntry commercePriceEntry : commercePriceEntries) {
            long userId = PortalUtil.getValidUserId((long)commercePriceEntry.getCompanyId(), (long)commercePriceEntry.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            CommercePriceList commercePriceList = commercePriceEntry.getCommercePriceList();
            serviceContext.setScopeGroupId(commercePriceList.getGroupId());
            this.commercePriceEntryLocalService.updateStatus(userId, commercePriceEntry.getCommercePriceEntryId(), 0, serviceContext, new HashMap());
        }
    }

    protected void checkCommercePriceEntriesByExpirationDate() throws PortalException {
        List commercePriceEntries = this.commercePriceEntryPersistence.findByLtE_S(new Date(), 0);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + commercePriceEntries.size() + " commerce price entries"));
        }
        if (commercePriceEntries != null && !commercePriceEntries.isEmpty()) {
            for (CommercePriceEntry commercePriceEntry : commercePriceEntries) {
                long userId = PortalUtil.getValidUserId((long)commercePriceEntry.getCompanyId(), (long)commercePriceEntry.getUserId());
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCommand("update");
                CommercePriceList commercePriceList = commercePriceEntry.getCommercePriceList();
                serviceContext.setScopeGroupId(commercePriceList.getGroupId());
                this.commercePriceEntryLocalService.updateStatus(userId, commercePriceEntry.getCommercePriceEntryId(), 3, serviceContext, new HashMap());
            }
        }
    }

    protected List<CommercePriceEntry> getCommercePriceEntries(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommercePriceEntry> commercePriceEntries = new ArrayList<CommercePriceEntry>(documents.size());
        for (Document document : documents) {
            long commercePriceEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommercePriceEntry commercePriceEntry = this.fetchCommercePriceEntry(commercePriceEntryId);
            if (commercePriceEntry == null) {
                commercePriceEntries = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommercePriceEntry.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commercePriceEntries == null) continue;
            commercePriceEntries.add(commercePriceEntry);
        }
        return commercePriceEntries;
    }

    protected BaseModelSearchResult<CommercePriceEntry> searchCommercePriceEntries(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommercePriceEntry.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommercePriceEntry> commercePriceEntries = this.getCommercePriceEntries(hits);
            if (commercePriceEntries == null) continue;
            return new BaseModelSearchResult(commercePriceEntries, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected int searchCommercePriceEntriesCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommercePriceEntry.class);
        return GetterUtil.getInteger((Object)indexer.searchCount(searchContext));
    }

    protected CommercePriceEntry startWorkflowInstance(long userId, CommercePriceEntry commercePriceEntry, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        return (CommercePriceEntry)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commercePriceEntry.getCompanyId(), (long)0L, (long)userId, (String)CommercePriceEntry.class.getName(), (long)commercePriceEntry.getCommercePriceEntryId(), (Object)commercePriceEntry, (ServiceContext)serviceContext, workflowContext);
    }

    protected void validateExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        CommercePriceEntry commercePriceEntry = this.commercePriceEntryPersistence.fetchByC_ERC(companyId, externalReferenceCode);
        if (commercePriceEntry != null) {
            throw new DuplicateCommercePriceEntryException("There is another commerce price entry with external reference code " + externalReferenceCode);
        }
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, long commercePriceListId, String cpInstanceUuid, int status) {
        return fromStep.from((Table)CommercePriceEntryTable.INSTANCE).where(CommercePriceEntryTable.INSTANCE.commercePriceListId.eq((Object)commercePriceListId).and((Expression)CommercePriceEntryTable.INSTANCE.CPInstanceUuid.eq((Object)cpInstanceUuid)).and(() -> {
            if (status == -1) {
                return CommercePriceEntryTable.INSTANCE.status.neq((Object)8);
            }
            return CommercePriceEntryTable.INSTANCE.status.eq((Object)status);
        }));
    }
}

